/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Central;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.ViewRequest;
import org.netbeans.core.windows.WindowSystemSnapshot;
import org.netbeans.core.windows.view.View;
import org.netbeans.core.windows.view.ViewEvent;
import org.netbeans.core.windows.view.ViewFactory;
import org.openide.windows.TopComponent;

class ViewRequestor {
    private final Central central;
    private final View view;
    private final List<ViewRequest> requests = new ArrayList<ViewRequest>(10);
    private WindowSystemSnapshot snapshot;
    private boolean reentryFlag = false;
    private static final boolean DEBUG = Debug.isLoggable(ViewRequestor.class);

    public ViewRequestor(Central central) {
        this.central = central;
        this.view = ViewFactory.createWindowSystemView(central);
    }

    public boolean isDragInProgress() {
        return this.view.isDragInProgress();
    }

    public Frame getMainWindow() {
        return this.view.getMainWindow();
    }

    public Component getEditorAreaComponent() {
        return this.view.getEditorAreaComponent();
    }

    public String guessSlideSide(TopComponent topComponent) {
        return this.view.guessSlideSide(topComponent);
    }

    public void scheduleRequest(ViewRequest viewRequest) {
        if (viewRequest.type == 0) {
            this.postVisibilityRequest(viewRequest);
            return;
        }
        this.coallesceRequest(viewRequest);
        this.postRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void coallesceRequest(ViewRequest viewRequest) {
        Object object = viewRequest.source;
        int n = viewRequest.type;
        boolean bl = n == 9 || n == 7 || n == 8 || n == 5 || n == 6 || n == 1 || n == 2 || n == 3 || n == 4 || n == 11 || n == 22 || n == 20 || n == 14 || n == 21 || n == 10 || n == 34 || n == 31 || n == 32 || n == 33 || n == 44 || n == 46 || n == 61 || n == 64 || n == 63;
        List<ViewRequest> list = this.requests;
        synchronized (list) {
            Object object2 = null;
            if (bl) {
                Iterator<ViewRequest> iterator = this.requests.iterator();
                while (iterator.hasNext()) {
                    ViewRequest viewRequest2 = iterator.next();
                    if (object != viewRequest2.source || n != viewRequest2.type) continue;
                    iterator.remove();
                    object2 = viewRequest2.oldValue;
                    break;
                }
            }
            if (object2 != null) {
                this.requests.add(new ViewRequest(viewRequest.source, viewRequest.type, object2, viewRequest.newValue));
            } else {
                this.requests.add(viewRequest);
            }
        }
    }

    private void postRequest() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.processRequest();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewRequestor.this.processRequest();
                }
            });
        }
    }

    private void postVisibilityRequest(final ViewRequest viewRequest) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.processVisibilityRequest(viewRequest);
        } else {
            final long l = System.currentTimeMillis();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (DEBUG) {
                        ViewRequestor.debugLog("Rescheduling request into AWT took=" + (System.currentTimeMillis() - l) + " ms");
                    }
                    ViewRequestor.this.processVisibilityRequest(viewRequest);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest() {
        ViewRequest[] viewRequestArray;
        if (this.reentryFlag) {
            return;
        }
        if (this.snapshot == null) {
            return;
        }
        List<ViewRequest> list = this.requests;
        synchronized (list) {
            if (this.requests.isEmpty()) {
                return;
            }
            viewRequestArray = this.requests.toArray(new ViewRequest[0]);
            this.requests.clear();
        }
        list = new ArrayList<ViewRequest>();
        this.updateSnapshot(viewRequestArray);
        for (int i = 0; i < viewRequestArray.length; ++i) {
            ViewRequest viewRequest = viewRequestArray[i];
            if (DEBUG) {
                ViewRequestor.debugLog("Creating a view event for " + viewRequest);
            }
            list.add((ViewRequest)((Object)this.getViewEvent(viewRequest)));
        }
        this.dispatchRequest(list.toArray(new ViewEvent[0]), this.snapshot);
    }

    private void processVisibilityRequest(ViewRequest viewRequest) {
        this.snapshot = (Boolean)viewRequest.newValue != false ? this.central.createWindowSystemSnapshot() : null;
        this.dispatchRequest(new ViewEvent[]{new ViewEvent(viewRequest.source, viewRequest.type, viewRequest.oldValue, viewRequest.newValue)}, this.snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchRequest(ViewEvent[] viewEventArray, WindowSystemSnapshot windowSystemSnapshot) {
        try {
            this.reentryFlag = true;
            this.view.changeGUI(viewEventArray, windowSystemSnapshot);
        }
        finally {
            this.reentryFlag = false;
            this.processRequest();
        }
    }

    private void updateSnapshot(ViewRequest[] viewRequestArray) {
        long l = System.currentTimeMillis();
        WindowSystemSnapshot windowSystemSnapshot = this.central.createWindowSystemSnapshot();
        this.snapshot.setMainWindowBoundsJoined(windowSystemSnapshot.getMainWindowBoundsJoined());
        this.snapshot.setMainWindowBoundsSeparated(windowSystemSnapshot.getMainWindowBoundsSeparated());
        this.snapshot.setMainWindowFrameStateJoined(windowSystemSnapshot.getMainWindowFrameStateJoined());
        this.snapshot.setMainWindowFrameStateSeparated(windowSystemSnapshot.getMainWindowFrameStateSeparated());
        this.snapshot.setEditorAreaState(windowSystemSnapshot.getEditorAreaState());
        this.snapshot.setEditorAreaFrameState(windowSystemSnapshot.getEditorAreaFrameState());
        this.snapshot.setEditorAreaBounds(windowSystemSnapshot.getEditorAreaBounds());
        this.snapshot.setActiveModeSnapshot(windowSystemSnapshot.getActiveModeSnapshot());
        this.snapshot.setMaximizedModeSnapshot(windowSystemSnapshot.getMaximizedModeSnapshot());
        this.snapshot.setModeStructureSnapshot(windowSystemSnapshot.getModeStructureSnapshot());
        this.snapshot.setToolbarConfigurationName(windowSystemSnapshot.getToolbarConfigurationName());
        this.snapshot.setProjectName(windowSystemSnapshot.getProjectName());
        if (DEBUG) {
            ViewRequestor.debugLog("Updating winsys snapshot took=" + (System.currentTimeMillis() - l) + " ms");
            ViewRequestor.debugLog(this.snapshot.toString());
        }
    }

    private ViewEvent getViewEvent(ViewRequest viewRequest) {
        Object object = viewRequest.source;
        int n = viewRequest.type;
        Object object2 = viewRequest.oldValue;
        Object object3 = viewRequest.newValue;
        if (n == 22) {
            return new ViewEvent(((ModeImpl)object).getName(), n, object2, object3);
        }
        if (n == 23) {
            return new ViewEvent(((ModeImpl)object).getName(), n, object2, object3);
        }
        if (n == 24) {
            return new ViewEvent(((ModeImpl)object).getName(), n, object2, object3);
        }
        if (n == 20) {
            return new ViewEvent(((ModeImpl)object).getName(), n, object2, object3);
        }
        if (n == 21) {
            return new ViewEvent(((ModeImpl)object).getName(), n, object2, object3);
        }
        if (n == 34) {
            return new ViewEvent(((ModeImpl)object).getName(), n, object2, object3);
        }
        if (n == 31) {
            return new ViewEvent(((ModeImpl)object).getName(), n, object2, object3);
        }
        if (n == 32) {
            return new ViewEvent(((ModeImpl)object).getName(), n, object2, object3);
        }
        if (n == 33) {
            return new ViewEvent(((ModeImpl)object).getName(), n, object2, object3);
        }
        if (n == 44) {
            return new ViewEvent(((ModeImpl)object).getName(), n, object2, object3);
        }
        if (n == 45) {
            return new ViewEvent(((ModeImpl)object).getName(), n, object2, object3);
        }
        return new ViewEvent(object, n, object2, object3);
    }

    private static void debugLog(String string) {
        Debug.log(ViewRequestor.class, string);
    }
}

