/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.AssociationDesc;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

public class DefaultLocalApplicationProperties
implements LocalApplicationProperties {
    private static final String REBOOT_NEEDED_KEY = "rebootNeeded";
    private static final String UPDATE_CHECK_KEY = "forcedUpdateCheck";
    private static final String NATIVELIB_DIR_KEY = "nativeLibDir";
    private static final String INSTALL_DIR_KEY = "installDir";
    private static final String LAST_ACCESSED_KEY = "lastAccessed";
    private static final String LAUNCH_COUNT_KEY = "launchCount";
    private static final String ASK_INSTALL_KEY = "askedInstall";
    private static final String SHORTCUT_KEY = "locallyInstalled";
    private static final String EXTENSION_KEY = "extensionInstalled";
    private static final String JNLP_INSTALLED_KEY = "jnlpInstalled";
    private static final String INDIRECT_PATH_KEY = "indirectPath";
    private static final String ASSOCIATION_MIME_KEY = "mime.types.";
    private static final String REGISTERED_TITLE_KEY = "title";
    private static final String ASSOCIATION_EXTENSIONS_KEY = "extensions.";
    private static final String DRAGGED_APPLET_KEY = "draggedApplet";
    private static final String DOCUMENTBASE_KEY = "documentBase";
    private static final String CODEBASE_KEY = "codebase";
    private static final DateFormat _df = DateFormat.getDateTimeInstance();
    private Properties _properties;
    private URL _location;
    private String _versionId;
    private long _lastAccessed;
    private boolean _isApplicationDescriptor;
    private boolean _dirty;
    private boolean _isShortcutInstalledSystem;

    public DefaultLocalApplicationProperties(URL uRL, String string, boolean bl) {
        this._location = uRL;
        this._versionId = string;
        this._isApplicationDescriptor = bl;
        this._properties = this.getLocalApplicationPropertiesStorage(this);
        this._isShortcutInstalledSystem = false;
    }

    public URL getLocation() {
        return this._location;
    }

    public String getVersionId() {
        return this._versionId;
    }

    public void setLastAccessed(Date date) {
        this.put(LAST_ACCESSED_KEY, _df.format(date));
    }

    public Date getLastAccessed() {
        return this.getDate(LAST_ACCESSED_KEY);
    }

    public void incrementLaunchCount() {
        int n = this.getLaunchCount();
        this.put(LAUNCH_COUNT_KEY, Integer.toString(++n));
    }

    public int getLaunchCount() {
        return this.getInteger(LAUNCH_COUNT_KEY);
    }

    public void setAskedForInstall(boolean bl) {
        this.put(ASK_INSTALL_KEY, new Boolean(bl).toString());
    }

    public boolean getAskedForInstall() {
        return this.getBoolean(ASK_INSTALL_KEY);
    }

    public void setRebootNeeded(boolean bl) {
        this.put(REBOOT_NEEDED_KEY, new Boolean(bl).toString());
    }

    public boolean isRebootNeeded() {
        return this.getBoolean(REBOOT_NEEDED_KEY);
    }

    public void setDraggedApplet() {
        this.put(DRAGGED_APPLET_KEY, new Boolean(true).toString());
    }

    public boolean isDraggedApplet() {
        return this.getBoolean(DRAGGED_APPLET_KEY);
    }

    public void setDocumentBase(String string) {
        this.put(DOCUMENTBASE_KEY, string);
    }

    public String getDocumentBase() {
        return this.get(DOCUMENTBASE_KEY);
    }

    public void setCodebase(String string) {
        this.put(CODEBASE_KEY, string);
    }

    public String getCodebase() {
        return this.get(CODEBASE_KEY);
    }

    public void setShortcutInstalled(boolean bl) {
        this.put(SHORTCUT_KEY, new Boolean(bl).toString());
    }

    public boolean isShortcutInstalled() {
        return this.getBoolean(SHORTCUT_KEY);
    }

    public boolean isShortcutInstalledSystem() {
        return this._isShortcutInstalledSystem;
    }

    public void setExtensionInstalled(boolean bl) {
        this.setShortcutInstalled(false);
        this.put(EXTENSION_KEY, new Boolean(bl).toString());
    }

    public boolean isExtensionInstalled() {
        return this.getBoolean(EXTENSION_KEY) || this.getBoolean(SHORTCUT_KEY);
    }

    public void setJnlpInstalled(boolean bl) {
        this.put(JNLP_INSTALLED_KEY, new Boolean(bl).toString());
    }

    public boolean isJnlpInstalled() {
        return this.getBoolean(JNLP_INSTALLED_KEY);
    }

    public boolean forceUpdateCheck() {
        return this.getBoolean(UPDATE_CHECK_KEY);
    }

    public void setForceUpdateCheck(boolean bl) {
        this.put(UPDATE_CHECK_KEY, new Boolean(bl).toString());
    }

    public boolean isApplicationDescriptor() {
        return this._isApplicationDescriptor;
    }

    public boolean isExtensionDescriptor() {
        return !this._isApplicationDescriptor;
    }

    public String getInstallDirectory() {
        return this.get(INSTALL_DIR_KEY);
    }

    public void setInstallDirectory(String string) {
        this.put(INSTALL_DIR_KEY, string);
    }

    public String getNativeLibDirectory() {
        return this.get(NATIVELIB_DIR_KEY);
    }

    public void setNativeLibDirectory(String string) {
        this.put(NATIVELIB_DIR_KEY, string);
    }

    public String getRegisteredTitle() {
        return this.get(REGISTERED_TITLE_KEY);
    }

    public void setRegisteredTitle(String string) {
        this.put(REGISTERED_TITLE_KEY, string);
    }

    public void setAssociations(AssociationDesc[] associationDescArray) {
        int n = 0;
        if (associationDescArray == null) {
            AssociationDesc[] associationDescArray2 = this.getAssociations();
            if (associationDescArray2 != null) {
                this.put(ASSOCIATION_MIME_KEY + n, null);
                this.put(ASSOCIATION_EXTENSIONS_KEY + n, null);
            }
        } else {
            for (n = 0; n < associationDescArray.length; ++n) {
                this.put(ASSOCIATION_MIME_KEY + n, associationDescArray[n].getMimeType());
                this.put(ASSOCIATION_EXTENSIONS_KEY + n, associationDescArray[n].getExtensions());
            }
            this.put(ASSOCIATION_MIME_KEY + n, null);
            this.put(ASSOCIATION_EXTENSIONS_KEY + n, null);
        }
    }

    public void addAssociation(AssociationDesc associationDesc) {
        AssociationDesc[] associationDescArray;
        AssociationDesc[] associationDescArray2 = this.getAssociations();
        if (associationDescArray2 == null) {
            associationDescArray = new AssociationDesc[1];
        } else {
            associationDescArray = new AssociationDesc[associationDescArray2.length + 1];
            for (int i = 0; i < associationDescArray2.length; ++i) {
                associationDescArray[i] = associationDescArray2[i];
            }
        }
        associationDescArray[i] = associationDesc;
        this.setAssociations(associationDescArray);
    }

    public AssociationDesc[] getAssociations() {
        ArrayList<AssociationDesc> arrayList = new ArrayList<AssociationDesc>();
        int n = 0;
        while (true) {
            String string = this.get(ASSOCIATION_MIME_KEY + n);
            String string2 = this.get(ASSOCIATION_EXTENSIONS_KEY + n);
            if (string == null && string2 == null) break;
            arrayList.add(new AssociationDesc(string2, string, null, null));
            ++n;
        }
        return arrayList.toArray(new AssociationDesc[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, String string2) {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            if (string2 == null) {
                this._properties.remove(string);
            } else {
                this._properties.put(string, string2);
            }
            this._dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String string) {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            return (String)this._properties.get(string);
        }
    }

    public int getInteger(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public boolean getBoolean(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return false;
        }
        return Boolean.valueOf(string2);
    }

    public Date getDate(String string) {
        String string2 = this.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            return _df.parse(string2);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesNewVersionExist() {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            long l = Cache.getLastAccessed(Environment.isSystemCacheMode());
            if (l == 0L) {
                return false;
            }
            if (l > this._lastAccessed) {
                return true;
            }
        }
        return false;
    }

    public synchronized void store() throws IOException {
        this.putLocalApplicationPropertiesStorage(this, this._properties);
        this._dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIfNecessary() {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            if (!this._dirty && this.doesNewVersionExist()) {
                this.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        DefaultLocalApplicationProperties defaultLocalApplicationProperties = this;
        synchronized (defaultLocalApplicationProperties) {
            Properties properties;
            this._properties = properties = this.getLocalApplicationPropertiesStorage(this);
            this._dirty = false;
        }
    }

    private Properties getLocalApplicationPropertiesStorage(DefaultLocalApplicationProperties defaultLocalApplicationProperties) {
        Properties properties = new Properties();
        try {
            URL uRL = defaultLocalApplicationProperties.getLocation();
            String string = defaultLocalApplicationProperties.getVersionId();
            if (uRL != null) {
                char c = defaultLocalApplicationProperties.isApplicationDescriptor() ? (char)'A' : 'E';
                byte[] byArray = Cache.getLapData(c, uRL, string, true);
                if (byArray != null) {
                    properties.load(new ByteArrayInputStream(byArray));
                    String string2 = (String)properties.get(SHORTCUT_KEY);
                    if (string2 != null) {
                        this._isShortcutInstalledSystem = Boolean.valueOf(string2);
                    }
                }
                if ((byArray = Cache.getLapData(c, uRL, string, false)) != null) {
                    properties.load(new ByteArrayInputStream(byArray));
                }
                this._lastAccessed = System.currentTimeMillis();
            }
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        return properties;
    }

    private void putLocalApplicationPropertiesStorage(DefaultLocalApplicationProperties defaultLocalApplicationProperties, Properties properties) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, "LAP");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byteArrayOutputStream.close();
        char c = defaultLocalApplicationProperties.isApplicationDescriptor() ? (char)'A' : 'E';
        Cache.putLapData(c, defaultLocalApplicationProperties.getLocation(), defaultLocalApplicationProperties.getVersionId(), byteArrayOutputStream.toByteArray());
        this._lastAccessed = System.currentTimeMillis();
    }
}

