/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.panel.IProperty;
import com.sun.deploy.panel.RadioProperty;
import com.sun.deploy.panel.TextFieldProperty;
import com.sun.deploy.panel.ToggleProperty;
import com.sun.deploy.panel.TreeRenderers;
import com.sun.deploy.resources.ResourceManager;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class TreeEditors {
    private static DefaultTreeCellEditor _radioEditor = null;
    private static DefaultTreeCellEditor _checkBoxEditor = null;
    private static DefaultTreeCellEditor _textFieldEditor = null;
    private static TreeEditors _instance = null;

    private static TreeEditors getInstance() {
        if (_instance == null) {
            _instance = new TreeEditors();
        }
        return _instance;
    }

    private DefaultTreeCellEditor getEditor(JTree jTree, IProperty iProperty) {
        DefaultTreeCellRenderer defaultTreeCellRenderer = TreeRenderers.getRenderer();
        if (iProperty instanceof RadioProperty) {
            if (_radioEditor == null) {
                _radioEditor = new RadioEditor(jTree, defaultTreeCellRenderer);
            }
            return _radioEditor;
        }
        if (iProperty instanceof ToggleProperty) {
            if (_checkBoxEditor == null) {
                _checkBoxEditor = new CheckBoxEditor(jTree, defaultTreeCellRenderer);
            }
            return _checkBoxEditor;
        }
        if (iProperty instanceof TextFieldProperty) {
            if (_textFieldEditor == null) {
                _textFieldEditor = new TextFieldEditor(jTree, defaultTreeCellRenderer);
            }
            return _textFieldEditor;
        }
        return null;
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private class CheckBoxEditor
    extends DeployEditor {
        private JCheckBox cb = new JCheckBox();

        public CheckBoxEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
            this.cb.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CheckBoxEditor.this.editingStopped();
                }
            });
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            IProperty iProperty = (IProperty)object;
            this.cb.setSelected(iProperty.isSelected());
            this.cb.setText(iProperty.getDescription());
            this.cb.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            return this.cb;
        }

        public Object getCellEditorValue() {
            return this.cb.isSelected() ? "true" : "false";
        }
    }

    public static final class DelegateEditor
    implements TreeCellEditor {
        private Vector vListeners = new Vector();
        private TreeCellEditor currentEditor;
        private JTree tree;
        private CellEditorListener listener = new CellEditorListener(){

            public void editingStopped(ChangeEvent changeEvent) {
                Vector vector = (Vector)DelegateEditor.this.vListeners.clone();
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    ((CellEditorListener)iterator.next()).editingStopped(changeEvent);
                }
            }

            public void editingCanceled(ChangeEvent changeEvent) {
                Vector vector = (Vector)DelegateEditor.this.vListeners.clone();
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    ((CellEditorListener)iterator.next()).editingCanceled(changeEvent);
                }
            }
        };

        public DelegateEditor(JTree jTree) {
            this.tree = jTree;
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            return this.currentEditor.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.vListeners.add(cellEditorListener);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.vListeners.remove(cellEditorListener);
        }

        public Object getCellEditorValue() {
            return this.currentEditor != null ? this.currentEditor.getCellEditorValue() : null;
        }

        public boolean isCellEditable(EventObject eventObject) {
            this.setCurrentEditor(eventObject);
            return this.currentEditor != null;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return this.currentEditor == null ? true : this.currentEditor.shouldSelectCell(eventObject);
        }

        public boolean stopCellEditing() {
            return this.currentEditor != null ? this.currentEditor.stopCellEditing() : true;
        }

        public void cancelCellEditing() {
            if (this.currentEditor != null) {
                this.currentEditor.cancelCellEditing();
            }
        }

        private void setCurrentEditor(EventObject eventObject) {
            TreeCellEditor treeCellEditor = this.pickEditor(eventObject);
            if (this.currentEditor != null) {
                this.currentEditor.removeCellEditorListener(this.listener);
            }
            this.currentEditor = treeCellEditor;
            if (this.currentEditor != null) {
                this.currentEditor.addCellEditorListener(this.listener);
            }
        }

        private TreeCellEditor pickEditor(EventObject eventObject) {
            DefaultTreeCellEditor defaultTreeCellEditor = null;
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath.getLastPathComponent() instanceof IProperty) {
                    IProperty iProperty = (IProperty)treePath.getLastPathComponent();
                    String string = iProperty.getPropertyName();
                    if (iProperty instanceof RadioProperty) {
                        string = ((RadioProperty)iProperty).getGroupName();
                    }
                    if (!Config.get().isPropertyLocked(string)) {
                        defaultTreeCellEditor = TreeEditors.getInstance().getEditor(this.tree, iProperty);
                    }
                }
            } else {
                TreePath treePath = this.tree.getSelectionPath();
                if (treePath.getLastPathComponent() instanceof TextFieldProperty) {
                    IProperty iProperty = (IProperty)treePath.getLastPathComponent();
                    if (!Config.get().isPropertyLocked(iProperty.getPropertyName())) {
                        defaultTreeCellEditor = TreeEditors.getInstance().getEditor(this.tree, iProperty);
                    }
                }
            }
            return defaultTreeCellEditor;
        }
    }

    private class DeployEditor
    extends DefaultTreeCellEditor {
        private Vector vListeners = new Vector();
        private ChangeEvent changeEvent = new ChangeEvent(this);

        public DeployEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.vListeners.add(cellEditorListener);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.vListeners.add(cellEditorListener);
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)eventObject;
                return mouseEvent.getID() != 506;
            }
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        protected void editingStopped() {
            Vector vector = (Vector)this.vListeners.clone();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ((CellEditorListener)iterator.next()).editingStopped(this.changeEvent);
            }
        }

        protected void editingCancelled() {
            Vector vector = (Vector)this.vListeners.clone();
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                ((CellEditorListener)iterator.next()).editingCanceled(this.changeEvent);
            }
        }
    }

    private class RadioEditor
    extends DeployEditor {
        private JRadioButton button = new JRadioButton();

        public RadioEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
            this.button.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    RadioEditor.this.editingStopped();
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    RadioEditor.this.editingCancelled();
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }
            });
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            IProperty iProperty = (IProperty)object;
            this.button.setSelected(iProperty.isSelected());
            this.button.setText(iProperty.getDescription());
            this.button.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            return this.button;
        }

        public Object getCellEditorValue() {
            String string = "";
            if (this.button.isSelected()) {
                string = this.button.getText();
            }
            return string;
        }
    }

    private class TextFieldEditor
    extends DeployEditor {
        private JPanel panel = new JPanel();
        private JButton browse_btn = new JButton(TreeEditors.access$300("deploy.advanced.browse.browse_btn"));
        private JTextField path = new JTextField("");

        public TextFieldEditor(JTree jTree, DefaultTreeCellRenderer defaultTreeCellRenderer) {
            super(jTree, defaultTreeCellRenderer);
            this.panel.setLayout(new BorderLayout());
            this.path.setColumns(22);
            this.panel.add((Component)this.path, "Center");
            this.panel.add((Component)this.browse_btn, "East");
            this.browse_btn.setMnemonic(ResourceManager.getVKCode("deploy.advanced.browse.browse_btn.mnemonic"));
            this.path.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TextFieldEditor.this.editingStopped();
                }
            });
            this.browse_btn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(2);
                    jFileChooser.setDialogTitle(TreeEditors.getMessage("deploy.advanced.browse.title"));
                    jFileChooser.setApproveButtonText(TreeEditors.getMessage("deploy.advanced.browse.select"));
                    String string = TreeEditors.getMessage("deploy.advanced.browse.select_tooltip");
                    jFileChooser.setApproveButtonToolTipText(string);
                    int n = ResourceManager.getVKCode("deploy.advanced.browse.select_mnemonic");
                    jFileChooser.setApproveButtonMnemonic(n);
                    File file = new File(TextFieldEditor.this.path.getText());
                    jFileChooser.setCurrentDirectory(file);
                    if (jFileChooser.showDialog(TextFieldEditor.this.panel, null) == 0) {
                        String string2 = "";
                        try {
                            string2 = jFileChooser.getSelectedFile().getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            string2 = jFileChooser.getSelectedFile().getPath();
                        }
                        TextFieldEditor.this.path.setText(string2);
                    }
                    TextFieldEditor.this.editingStopped();
                }
            });
            Set<AWTKeyStroke> set = Collections.synchronizedSet(new HashSet());
            set.add(AWTKeyStroke.getAWTKeyStroke(39, 0, true));
            this.panel.setFocusTraversalKeys(0, set);
            set.clear();
            set.add(AWTKeyStroke.getAWTKeyStroke(37, 0, true));
            this.panel.setFocusTraversalKeys(1, set);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0, true);
            this.panel.getInputMap(1).put(keyStroke, "StopEditingAction");
            this.panel.getActionMap().put("StopEditingAction", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TextFieldEditor.this.editingStopped();
                }
            });
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            if (bl) {
                this.panel.setBackground(this.renderer.getBackgroundSelectionColor());
                this.panel.setBorder(BorderFactory.createLineBorder(this.renderer.getBorderSelectionColor()));
            } else {
                this.panel.setBackground(this.renderer.getBackgroundNonSelectionColor());
                this.panel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            IProperty iProperty = (IProperty)object;
            this.path.setText(iProperty.getValue());
            this.path.setFont(jTree.getFont());
            return this.panel;
        }

        public Object getCellEditorValue() {
            return this.path.getText();
        }
    }
}

