/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.cpu;

import com.sun.tools.visualvm.sampler.cpu.FlatProfilerContainer;
import java.util.Stack;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.MethodInfoMapper;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTVisitorAdapter;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;

final class CCTFlattener
extends CPUCCTVisitorAdapter {
    private final Object containerGuard = new Object();
    private FlatProfileContainer container;
    private Stack parentStack = new Stack();
    private int[] invDiff;
    private int[] invPM;
    private int[] nCalleeInvocations;
    private long[] timePM0;
    private long[] timePM1;
    private int nMethods;
    private boolean collectingTwoTimeStamps;
    private MethodInfoMapper methodInfoMapper;
    private InstrumentationFilter filter;

    CCTFlattener(boolean twoStamps, MethodInfoMapper mapper, InstrumentationFilter f) {
        this.nMethods = mapper.getMaxMethodId();
        this.methodInfoMapper = mapper;
        this.collectingTwoTimeStamps = twoStamps;
        this.filter = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FlatProfileContainer getFlatProfile() {
        Object object = this.containerGuard;
        synchronized (object) {
            return this.container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterWalk() {
        long wholeGraphTime0 = 0L;
        long wholeGraphTime1 = 0L;
        long totalNInv = 0L;
        for (int i = 0; i < this.nMethods; ++i) {
            double time = (double)this.timePM0[i] / 1000.0;
            if (time < 0.0) {
                time = 0.0;
            }
            this.timePM0[i] = (long)time;
            if (i > 0) {
                wholeGraphTime0 = (long)((double)wholeGraphTime0 + time);
            }
            if (this.collectingTwoTimeStamps) {
                time = (double)this.timePM1[i] / 1000.0;
                this.timePM1[i] = (long)time;
                if (i > 0) {
                    wholeGraphTime1 = (long)((double)wholeGraphTime1 + time);
                }
            }
            totalNInv += (long)this.invPM[i];
        }
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = new FlatProfilerContainer(this.methodInfoMapper, this.collectingTwoTimeStamps, this.timePM0, this.timePM1, this.invPM, new char[0], wholeGraphTime0, wholeGraphTime1, this.invPM.length);
        }
        this.timePM1 = null;
        this.timePM0 = null;
        this.nCalleeInvocations = null;
        this.invDiff = null;
        this.invPM = null;
        this.parentStack.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeWalk() {
        this.timePM0 = new long[this.nMethods];
        this.timePM1 = new long[this.collectingTwoTimeStamps ? this.nMethods : 0];
        this.invPM = new int[this.nMethods];
        this.invDiff = new int[this.nMethods];
        this.nCalleeInvocations = new int[this.nMethods];
        this.parentStack.clear();
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = null;
        }
    }

    public void visit(MethodCPUCCTNode node) {
        boolean filteredOut;
        MethodCPUCCTNode currentParent = this.parentStack.isEmpty() ? null : (MethodCPUCCTNode)this.parentStack.peek();
        boolean bl = filteredOut = node.getFilteredStatus() == 2;
        if (!filteredOut) {
            String jvmClassName = this.methodInfoMapper.getInstrMethodClass(node.getMethodId()).replace('.', '/');
            boolean bl2 = filteredOut = !this.filter.passesFilter(jvmClassName);
        }
        if (filteredOut) {
            if (currentParent != null && !currentParent.isRoot()) {
                int n = currentParent.getMethodId();
                this.invDiff[n] = this.invDiff[n] + node.getNCalls();
                int n2 = currentParent.getMethodId();
                this.timePM0[n2] = this.timePM0[n2] + node.getNetTime0();
                if (this.collectingTwoTimeStamps) {
                    int n3 = currentParent.getMethodId();
                    this.timePM1[n3] = this.timePM1[n3] + node.getNetTime1();
                }
            }
        } else {
            int n = node.getMethodId();
            this.timePM0[n] = this.timePM0[n] + node.getNetTime0();
            if (this.collectingTwoTimeStamps) {
                int n4 = node.getMethodId();
                this.timePM1[n4] = this.timePM1[n4] + node.getNetTime1();
            }
            int n5 = node.getMethodId();
            this.invPM[n5] = this.invPM[n5] + node.getNCalls();
            if (currentParent != null && !currentParent.isRoot()) {
                int n6 = currentParent.getMethodId();
                this.nCalleeInvocations[n6] = this.nCalleeInvocations[n6] + node.getNCalls();
            }
            currentParent = node;
        }
        this.parentStack.push(currentParent);
    }

    public void visitPost(MethodCPUCCTNode node) {
        this.parentStack.pop();
    }

    public void visitPost(ThreadCPUCCTNode node) {
        this.parentStack.clear();
    }
}

