/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.DelegateActionMap;
import org.openide.windows.TopComponent;

final class DefaultTopComponentLookup
extends ProxyLookup
implements LookupListener {
    private static final Object PRESENT = new Object();
    private Reference<TopComponent> tc;
    private LookupListener listener;
    private Map<Lookup, Lookup.Result> attachedTo;
    private Lookup actionMap;

    public DefaultTopComponentLookup(TopComponent topComponent) {
        this.tc = new WeakReference<TopComponent>(topComponent);
        this.listener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), null);
        this.actionMap = Lookups.singleton((Object)new DelegateActionMap(topComponent));
        this.updateLookups(topComponent.getActivatedNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLookups(Node[] nodeArray) {
        Map<Object, Object> map;
        if (nodeArray == null) {
            AbstractLookup.Content content = new AbstractLookup.Content();
            AbstractLookup abstractLookup = new AbstractLookup(content);
            content.addPair((AbstractLookup.Pair)new NoNodesPair());
            this.setLookups(new Lookup[]{abstractLookup, this.actionMap});
            return;
        }
        Lookup[] lookupArray = new Lookup[nodeArray.length];
        DefaultTopComponentLookup defaultTopComponentLookup = this;
        synchronized (defaultTopComponentLookup) {
            map = this.attachedTo == null ? Collections.emptyMap() : new HashMap<Lookup, Lookup.Result>(this.attachedTo);
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            lookupArray[i] = nodeArray[i].getLookup();
            if (map == null) continue;
            map.remove(nodeArray[i]);
        }
        for (Lookup.Result result : map.values()) {
            result.removeLookupListener(this.listener);
        }
        Object object = this;
        synchronized (object) {
            this.attachedTo = null;
        }
        this.setLookups(new Lookup[]{new NoNodeLookup((Lookup)new ProxyLookup(lookupArray), nodeArray), Lookups.fixed((Object[])nodeArray), this.actionMap});
    }

    public void resultChanged(LookupEvent lookupEvent) {
        TopComponent topComponent = this.tc.get();
        if (topComponent == null) {
            this.updateLookups(null);
            return;
        }
        this.updateLookups(topComponent.getActivatedNodes());
    }

    private static boolean isNodeQuery(Class<?> clazz) {
        return Node.class.isAssignableFrom(clazz) || clazz.isAssignableFrom(Node.class);
    }

    protected synchronized void beforeLookup(Lookup.Template<?> template) {
        if (this.attachedTo == null && DefaultTopComponentLookup.isNodeQuery(template.getType())) {
            Lookup[] lookupArray = this.getLookups();
            this.attachedTo = new WeakHashMap<Lookup, Lookup.Result>(lookupArray.length * 2);
            for (int i = 0; i < lookupArray.length - 2; ++i) {
                Lookup.Result result = lookupArray[i].lookup(template);
                result.addLookupListener(this.listener);
                this.attachedTo.put(lookupArray[i], result);
            }
        }
    }

    private static final class NoNodeLookup
    extends Lookup {
        private final Lookup delegate;
        private final Map<Object, Object> verboten;

        public NoNodeLookup(Lookup lookup, Object[] objectArray) {
            this.delegate = lookup;
            this.verboten = new IdentityHashMap<Object, Object>();
            int n = 0;
            while (n < objectArray.length) {
                this.verboten.put(objectArray[n++], PRESENT);
            }
        }

        public <T> T lookup(Class<T> clazz) {
            if (clazz == Node.class) {
                return null;
            }
            Object object = this.delegate.lookup(clazz);
            if (this.verboten.containsKey(object)) {
                for (Object e : this.lookupAll(clazz)) {
                    if (this.verboten.containsKey(e)) continue;
                    return (T)e;
                }
                return null;
            }
            return (T)object;
        }

        public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
            if (template.getType() == Node.class) {
                return Lookup.EMPTY.lookup(new Lookup.Template(Node.class));
            }
            return new ExclusionResult(this.delegate.lookup(template), this.verboten);
        }

        private static final class ExclusionResult<T>
        extends Lookup.Result<T>
        implements LookupListener {
            private final Lookup.Result<T> delegate;
            private final Map<Object, Object> verboten;
            private final List<LookupListener> listeners = new ArrayList<LookupListener>();

            public ExclusionResult(Lookup.Result<T> result, Map<Object, Object> map) {
                this.delegate = result;
                this.verboten = map;
            }

            public Collection<? extends T> allInstances() {
                Collection collection = this.delegate.allInstances();
                ArrayList arrayList = new ArrayList(collection.size());
                for (Object e : collection) {
                    if (this.verboten.containsKey(e)) continue;
                    arrayList.add(e);
                }
                return arrayList;
            }

            public Set<Class<? extends T>> allClasses() {
                return this.delegate.allClasses();
            }

            public Collection<? extends Lookup.Item<T>> allItems() {
                Collection collection = this.delegate.allItems();
                ArrayList<Lookup.Item> arrayList = new ArrayList<Lookup.Item>(collection.size());
                for (Lookup.Item item : collection) {
                    if (this.verboten.containsKey(item.getInstance())) continue;
                    arrayList.add(item);
                }
                return arrayList;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addLookupListener(LookupListener lookupListener) {
                List<LookupListener> list = this.listeners;
                synchronized (list) {
                    if (this.listeners.isEmpty()) {
                        this.delegate.addLookupListener((LookupListener)this);
                    }
                    this.listeners.add(lookupListener);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeLookupListener(LookupListener lookupListener) {
                List<LookupListener> list = this.listeners;
                synchronized (list) {
                    this.listeners.remove(lookupListener);
                    if (this.listeners.isEmpty()) {
                        this.delegate.removeLookupListener((LookupListener)this);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent lookupEvent) {
                LookupListener[] lookupListenerArray;
                LookupEvent lookupEvent2 = new LookupEvent((Lookup.Result)this);
                List<LookupListener> list = this.listeners;
                synchronized (list) {
                    lookupListenerArray = this.listeners.toArray(new LookupListener[this.listeners.size()]);
                }
                for (int i = 0; i < lookupListenerArray.length; ++i) {
                    lookupListenerArray[i].resultChanged(lookupEvent2);
                }
            }
        }
    }

    private static final class NoNodesPair
    extends AbstractLookup.Pair {
        protected boolean creatorOf(Object object) {
            return false;
        }

        public String getDisplayName() {
            return this.getId();
        }

        public String getId() {
            return "none";
        }

        public Object getInstance() {
            return null;
        }

        public Class getType() {
            return Node.class;
        }

        protected boolean instanceOf(Class clazz) {
            return Node.class.isAssignableFrom(clazz);
        }
    }
}

