/*
 *
 *  Copyright (C) 2007 Mindspeed Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _QOSLIB_H
#define _QOSLIB_H


#include "qos_fops.h"

#define CONF_FILE_PATH	"/etc/config/qos.conf"

/*
* Debug macros
*/
#define QOSLIB_PRINT	1
#define QOSLIB_ERR	1
#define	QOSLIB_INIT	1
#define	QOSLIB_INFO	1
#define QOSLIB_STATS	1


#ifdef QOSLIB_PRINT
#define QOSLIB_PRINTF(type, info, args...) do {if(type) printf("\n" info, ## args);} while(0);
#else
#define QOSLIB_PRINTF(type, info, args...) do {} while(0);
#endif



/*
* Prototypes
*/
int qos_adm_get_mode (int fd,unsigned char *mode);
int qos_adm_set_mode (int fd, unsigned char mode);

int qos_adm_get_stats(int fd, struct _ADM_COUNTER *stats);
void qos_adm_dump_stats(int adm_index, struct _ADM_COUNTER *stats);

int qos_adm_get_lru(int fd, struct _ADM_LRU_STATS *lru);

int qos_adm_set_discard_conf (int fd, struct _ADM_DISCARD_CONF *conf);
int qos_adm_set_flowctrl_conf (int fd, struct _ADM_FLOWCTRL_CONF *conf);
int qos_adm_set_shaper_conf (int fd, struct _ADM_SHAPER_CONF *conf);
int qos_adm_get_shaper_conf (int fd, struct _ADM_SHAPER_CONF *conf);

int qos_adm_add_camentry (int fd, struct _ADM_TCAM_CONF *conf);
int qos_adm_remove_camentry (int fd, unsigned char index);
int qos_adm_change_camentry (int fd, struct _ADM_TCAM_CONF *conf);
int qos_adm_add_camentry_before (int fd, struct _ADM_TCAM_CONF *conf, unsigned int index);
int qos_adm_add_camentry_bottom (int fd, struct _ADM_TCAM_CONF *conf);
int qos_adm_add_camentry_top (int fd, struct _ADM_TCAM_CONF *conf);
int qos_adm_set_camentry_state (int fd, struct _ADM_TCAM_STATE *state);
int qos_adm_get_camentry (int fd, struct _ADM_TCAM_CONF *conf);
void qos_adm_dump_camentry(struct _ADM_TCAM_ENTRY *entry);

int qos_adm_set_policer_conf (int fd, struct _ADM_POLICER_CONF *conf);
int qos_adm_get_policer_conf (int fd, struct _ADM_POLICER_CONF *conf);

int qos_adm_set_lru_conf (int fd, struct _ADM_LRU_CONF *conf);
int qos_adm_get_lru_stats(int fd, struct _ADM_LRU_STATS *stats);

int qos_sch_get_stats(int fd, struct _SCH_COUNTER *stats);
void qos_sch_dump_stats(int sch_index, struct _SCH_COUNTER *stats);
int qos_sch_set_shaper_state (int fd, struct _SCH_SHAPER_STATE *state);
int qos_sch_get_shaper_state (int fd, struct _SCH_SHAPER_STATE *state);
int qos_sch_set_shaper_conf(int fd, struct _SCH_SHAPER_CONF *conf);
int qos_sch_get_shaper_conf(int fd, struct _SCH_SHAPER_CONF *conf);
int qos_sch_set_queue_weight(int fd, struct _SCH_QUEUE_WEIGHT *conf);
int qos_sch_get_queue_weight(int fd, struct _SCH_QUEUE_WEIGHT *conf);

int qos_open(const char *dev_name, int non_blocking);
void qos_close (int fd);

int qos_config_parser(char *conffilepath);

int qos_reset_adm (int fd, unsigned char *flag);
int qos_reset_sch (int fd, unsigned char *flag);

int qos_dump_regs (int fd);

#endif
