/*
 *
 *  Copyright (C) 2008 Mindspeed Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _ADM_H
#define _ADM_H

#include "m83xxx_common.h"

#define ADM0	0
#define ADM1	1
#define ADM_NUM_DROP_ZONE	4
#define ADM_TCAM_MAX_ENTRIES	32
#define ADM_QMAX_HEADROOM	16

#define CHECK_ADM(adm)		(adm > ADM1 ? 0 : 1) /* return 0 if adm is out of range */


extern unsigned long *FAKE_EMAC0_BASE;
extern unsigned long *FAKE_EMAC1_BASE;

/* There's one admittance block per GEM interface */
#ifdef C1K_REG_SIM
#warning !!!!!!!! running with fake gemac registers
#define adm_base(adm) (get_gemac_base(adm) + 0x4000)
#else
#define adm_base(adm) ((adm > 0 ? APB_VADDR(EMAC1_BASE) : APB_VADDR(EMAC0_BASE)) + 0x4000)
#endif
/******************************** STATUS register ********************************/
#define ADM_STATUS_REG(adm)			(volatile unsigned long *)(adm_base(adm) + 0x0000)

#define ADM_STATUS_ACCEPTED_BIT			0
#define ADM_STATUS_ACCEPTED_W			0x01
#define ADM_GET_STATUS_ACCEPTED(adm)		(*ADM_STATUS_REG(adm) >> ADM_STATUS_ACCEPTED_BIT) & ADM_STATUS_ACCEPTED_W

#define ADM_STATUS_DROPPED_BIT			1
#define ADM_STATUS_DROPPED_W			0x01
#define ADM_GET_STATUS_DROPPED(adm)		(*ADM_STATUS_REG(adm) >> ADM_STATUS_DROPPED_BIT) & ADM_STATUS_DROPPED_W

#define ADM_STATUS_QZONE_BIT			2
#define ADM_STATUS_QZONE_W			0x07
#define ADM_GET_STATUS_QZONE(adm)		(*ADM_STATUS_REG(adm) >> ADM_STATUS_QZONE_BIT) & ADM_STATUS_QZONE_W

#define ADM_STATUS_CLASSFIFODEPTH_BIT		5
#define ADM_STATUS_CLASSFIFODEPTH_W		0x1F
#define ADM_GET_STATUS_CLASSFIFODEPTH(adm)	(*ADM_STATUS_REG(adm) >> ADM_STATUS_CLASSFIFODEPTH_BIT) & ADM_STATUS_CLASSFIFODEPTH_W

#define	ADM_STATUS_TCAMENTRY_BIT		10
#define	ADM_STATUS_TCAMENTRY_W			0x1F
#define ADM_GET_STATUS_TCAMENTRY		(*ADM_STATUS_REG(adm) >> ADM_STATUS_TCAMENTRY_BIT) & ADM_STATUS_TCAMENTRY_W

#define ADM_STATUS_TCAMHIT_BIT			15
#define ADM_STATUS_TCAMHIT_W			0x01
#define ADM_GET_STATUS_TCAMHIT			(*ADM_STATUS_REG(adm) >> ADM_STATUS_TCAMHIT_BIT) & ADM_STATUS_TCAMHIT_W

#define ADM_STATUS_PAUSESENT_BIT		16
#define ADM_STATUS_PAUSESENT_W			0x01
#define ADM_GET_STATUS_PAUSESENT		(*ADM_STATUS_REG(adm) >> ADM_STATUS_PAUSESENT_BIT) & ADM_STATUS_PAUSESENT_W

#define ADM_STATUS_PACKETTYPE_BIT		17
#define ADM_STATUS_PACKETTYPE_W			0x03
#define ADM_GET_STATUS_PACKETTYPE		(*ADM_STATUS_REG(adm) >> ADM_STATUS_PACKETTYPE_BIT) & ADM_STATUS_PACKETTYPE_W

#define ADM_STATUS_DROP_CONGESTION_BIT		19
#define ADM_STATUS_DROP_CONGESTION_W		0x01
#define ADM_GET_STATUS_DROP_CONGESTION		(*ADM_STATUS_REG(adm) >> ADM_STATUS_DROP_CONGESTION_BIT) & ADM_STATUS_DROP_CONGESTION_W

#define ADM_STATUS_DROP_QFULL_BIT		20
#define ADM_STATUS_DROP_QFULL_W			0x01
#define ADM_GET_STATUS_DROP_QFULL		(*ADM_STATUS_REG(adm) >> ADM_STATUS_DROP_QFULL_BIT) & ADM_STATUS_DROP_QFULL_W

#define ADM_STATUS_DROP_SHAPER_BIT		21
#define ADM_STATUS_DROP_SHAPER_W		0x01
#define ADM_GET_STATUS_DROP_SHAPER		(*ADM_STATUS_REG(adm) >> ADM_STATUS_DROP_SHAPER_BIT) & ADM_STATUS_DROP_SHAPER_W

#define ADM_STATUS_DROP_ACL_BIT			22
#define ADM_STATUS_DROP_ACL_W			0x01
#define ADM_GET_STATUS_DROP_ACL			(*ADM_STATUS_REG(adm) >> ADM_STATUS_DROP_ACL_BIT) & ADM_STATUS_DROP_ACL_W

#define ADM_STATUS_DROP_POLICER0_BIT		23	
#define ADM_STATUS_DROP_POLICER0_W		0x01
#define ADM_GET_STATUS_DROP_POLICER0		(*ADM_STATUS_REG(adm) >> ADM_STATUS_DROP_POLICER0_BIT) & ADM_STATUS_DROP_POLICER0_W

#define ADM_STATUS_DROP_POLICER1_BIT		24
#define ADM_STATUS_DROP_POLICER1_W		0x01
#define ADM_GET_STATUS_DROP_POLICER1		(*ADM_STATUS_REG(adm) >> ADM_STATUS_DROP_POLICER1_BIT) & ADM_STATUS_DROP_POLICER1_W

#define ADM_STATUS_DROP_ERROR_BIT		25
#define ADM_STATUS_DROP_ERROR_W			0x01
#define ADM_GET_STATUS_DROP_ERROR		(*ADM_STATUS_REG(adm) >> ADM_STATUS_DROP_ERROR_BIT) & ADM_STATUS_DROP_ERROR_W

#define ADM_STATUS_PKTSEQNUM_BIT		26
#define ADM_STATUS_PKTSEQNUM_W			0x1F
#define ADM_GET_STATUS_PKTSEQNUM		(*ADM_STATUS_REG(adm) >> ADM_STATUS_PKTSEQNUM_BIT) & ADM_STATUS_PKTSEQNUM_W

#define ADM_STATUS_READY_BIT			31
#define ADM_STATUS_READY_W			0x01
#define ADM_GET_STATUS_READY(adm)		(*ADM_STATUS_REG(adm) >> ADM_STATUS_READY_BIT) & ADM_STATUS_READY_W


/************************************ PACKET DEQUEUED register **********************************************/
#define ADM_PKT_DEQUEUED_REG(adm)		(volatile unsigned long *)(adm_base(adm) + 0x0004)

#define ADM_PKT_DEQUEUED_BIT			0
#define ADM_PKT_DEQUEUED_W			0x3FFF
#define ADM_GET_PKT_DEQUEUED(adm)		(*ADM_PKT_DEQUEUED_REG(adm) >> ADM_PKT_DEQUEUED_BIT) & ADM_PKT_DEQUEUED_W
#define ADM_SET_PKT_DEQUEUED(adm,value)		*ADM_PKT_DEQUEUED_REG(adm) |= (value & ADM_PKT_DEQUEUED_BIT) << ADM_PKT_DEQUEUED_W

/******************************************* CONFIGURATION register *******************************************/
#define ADM_CONF_REG(adm)			(volatile unsigned long *)(adm_base(adm) + 0x0008)

#define ADM_CONF_MODE_BIT			0
#define ADM_CONF_MODE_W				0x01
#define ADM_GET_CONF_MODE(adm)			(*ADM_CONF_REG(adm) >> ADM_CONF_MODE_BIT) & ADM_CONF_MODE_W
#define ADM_SET_CONF_MODE_DISCARD(adm)		*ADM_CONF_REG(adm) &= ~(ADM_CONF_MODE_W << ADM_CONF_MODE_BIT) /* 0 = DISCARD */
#define ADM_SET_CONF_MODE_FLOWCTRL(adm)		*ADM_CONF_REG(adm) |= (ADM_CONF_MODE_W << ADM_CONF_MODE_BIT) /* 1 = FLOWCTRL */

#define ADM_CONF_ADMITERR_BIT			1
#define ADM_CONF_ADMITERR_W			0x01
#define ADM_GET_CONF_ADMITERR(adm)		(*ADM_CONF_REG(adm) >> ADM_CONF_ADMITERR_BIT) & ADM_CONF_ADMITERR_W
#define ADM_SET_CONF_ADMITERR(adm)		*ADM_CONF_REG(adm) |= (ADM_CONF_ADMITERR_W << ADM_CONF_ADMITERR_BIT) /* 1 = ADMIT ERRORS PKTS */
#define ADM_SET_CONF_DISCARDERR(adm)		*ADM_CONF_REG(adm) &= ~(ADM_CONF_ADMITERR_W << ADM_CONF_ADMITERR_BIT) /* 0 = DISCARD ERRORS PKTS*/

#define ADM_CONF_WEIGTH_BIT			4
#define ADM_CONF_WEIGTH_W			0x0F
#define ADM_SET_CONF_WEIGTH(adm,value)		SET_REG_BITSHIFT(ADM_CONF_REG(adm), value, ADM_CONF_WEIGTH_W , ADM_CONF_WEIGTH_BIT)

#define ADM_CONF_PROB0_BIT			16
#define ADM_CONF_PROB0_W			0x0F
#define ADM_SET_CONF_PROB0(adm,value)		SET_REG_BITSHIFT(ADM_CONF_REG(adm), value, ADM_CONF_PROB0_W , ADM_CONF_PROB0_BIT)

#define ADM_CONF_PROB1_BIT			20
#define ADM_CONF_PROB1_W			0x0F
#define ADM_SET_CONF_PROB1(adm,value)		SET_REG_BITSHIFT(ADM_CONF_REG(adm), value, ADM_CONF_PROB1_W , ADM_CONF_PROB1_BIT)

#define ADM_CONF_PROB2_BIT			24
#define ADM_CONF_PROB2_W			0x0F
#define ADM_SET_CONF_PROB2(adm,value)		SET_REG_BITSHIFT(ADM_CONF_REG(adm) , value, ADM_CONF_PROB2_W , ADM_CONF_PROB2_BIT)

#define ADM_CONF_PROB3_BIT			28
#define ADM_CONF_PROB3_W			0x0F
#define ADM_SET_CONF_PROB3(adm,value)		SET_REG_BITSHIFT(ADM_CONF_REG(adm) , value, ADM_CONF_PROB3_W , ADM_CONF_PROB3_BIT)


/****************************************** CONTROL register ********************************************/
#define ADM_CTRL_REG(adm)			(volatile unsigned long *)(adm_base(adm) + 0x000C)

#define ADM_CTRL_ADM_ENABLE_BIT			0
#define ADM_CTRL_ADM_ENABLE_W			1
#define ADM_GET_CTRL_ADM_ENABLE(adm)		(*ADM_CTRL_REG(adm) >> ADM_CTRL_ADM_ENABLE_BIT) & ADM_CTRL_ADM_ENABLE_W	
#define ADM_SET_CTRL_ADM_ENABLE(adm)		*ADM_CTRL_REG(adm) |= (1 << ADM_CTRL_ADM_ENABLE_BIT)
#define ADM_SET_CTRL_ADM_DISABLE(adm)		*ADM_CTRL_REG(adm) &= ~(1 << ADM_CTRL_ADM_ENABLE_BIT)

#define ADM_CTRL_TCAM_ENABLE_BIT		1
#define ADM_CTRL_TCAM_ENABLE_W			1
#define ADM_GET_CTRL_TCAM_ENABLE(adm)		(*ADM_CTRL_REG(adm) >> ADM_CTRL_TCAM_ENABLE_BIT) & ADM_CTRL_TCAM_ENABLE_W	
#define ADM_SET_CTRL_TCAM_ENABLE(adm)		*ADM_CTRL_REG(adm) |= (1 << ADM_CTRL_TCAM_ENABLE_BIT)
#define ADM_SET_CTRL_TCAM_DISABLE(adm)		*ADM_CTRL_REG(adm) &= ~(1 << ADM_CTRL_TCAM_ENABLE_BIT)

#define ADM_CTRL_POLICER_ENABLE_BIT		2
#define ADM_CTRL_POLICER_ENABLE_W		1
#define ADM_GET_CTRL_POLICER_ENABLE(adm)	(*ADM_CTRL_REG(adm) >> ADM_CTRL_POLICER_ENABLE_BIT) & ADM_CTRL_POLICER_ENABLE_W	
#define ADM_SET_CTRL_POLICER_ENABLE(adm)	*ADM_CTRL_REG(adm) |= (1 << ADM_CTRL_POLICER_ENABLE_BIT)
#define ADM_SET_CTRL_POLICER_DISABLE(adm)	*ADM_CTRL_REG(adm) &= ~(1 << ADM_CTRL_POLICER_ENABLE_BIT)

#define ADM_CTRL_SHAPER_ENABLE_BIT		3
#define ADM_CTRL_SHAPER_ENABLE_W		1
#define ADM_GET_CTRL_SHAPER_ENABLE(adm)		(*ADM_CTRL_REG(adm) >> ADM_CTRL_SHAPER_ENABLE_BIT) & ADM_CTRL_SHAPER_ENABLE_W	
#define ADM_SET_CTRL_SHAPER_ENABLE(adm)		*ADM_CTRL_REG(adm) |= (1 << ADM_CTRL_SHAPER_ENABLE_BIT)
#define ADM_SET_CTRL_SHAPER_DISABLE(adm)	*ADM_CTRL_REG(adm) &= ~(1 << ADM_CTRL_SHAPER_ENABLE_BIT)

#define ADM_CTRL_DISCARD_ENABLE_BIT		4
#define ADM_CTRL_DISCARD_ENABLE_W		1
#define ADM_GET_CTRL_DISCARD_ENABLE(adm)	(*ADM_CTRL_REG(adm) >> ADM_CTRL_DISCARD_ENABLE_BIT) & ADM_CTRL_DISCARD_ENABLE_W	
#define ADM_SET_CTRL_DISCARD_ENABLE(adm)	*ADM_CTRL_REG(adm) |= (1 << ADM_CTRL_DISCARD_ENABLE_BIT)
#define ADM_SET_CTRL_DISCARD_DISABLE(adm)	*ADM_CTRL_REG(adm) &= ~(1 << ADM_CTRL_DISCARD_ENABLE_BIT)

#define ADM_CTRL_FLOWCTRL_ENABLE_BIT		5
#define ADM_CTRL_FLOWCTRL_ENABLE_W		1
#define ADM_GET_CTRL_FLOWCTRL_ENABLE(adm)	(*ADM_CTRL_REG(adm) >> ADM_CTRL_FLOWCTRL_ENABLE_BIT) & ADM_CTRL_FLOWCTRL_ENABLE_W	
#define ADM_SET_CTRL_FLOWCTRL_ENABLE(adm)	*ADM_CTRL_REG(adm) |= (1 << ADM_CTRL_FLOWCTRL_ENABLE_BIT)
#define ADM_SET_CTRL_FLOWCTRL_DISABLE(adm)	*ADM_CTRL_REG(adm) &= ~(1 << ADM_CTRL_FLOWCTRL_ENABLE_BIT)

#define ADM_CTRL_STATISTICS_ENABLE_BIT		6
#define ADM_CTRL_STATISTICS_ENABLE_W		1
#define ADM_GET_CTRL_STATISTICS_ENABLE(adm)	(*ADM_CTRL_REG(adm) >> ADM_CTRL_STATISTICS_ENABLE_BIT) & ADM_CTRL_STATISTICS_ENABLE_W	
#define ADM_SET_CTRL_STATISTICS_ENABLE(adm)	*ADM_CTRL_REG(adm) |= (1 << ADM_CTRL_STATISTICS_ENABLE_BIT)
#define ADM_SET_CTRL_STATISTICS_DISABLE(adm)	*ADM_CTRL_REG(adm) &= ~(1 << ADM_CTRL_STATISTICS_ENABLE_BIT)

#define ADM_CTRL_SNAPSHOT_ENABLE_BIT		16
#define ADM_CTRL_SNAPSHOT_ENABLE_W		1
#define ADM_GET_CTRL_SNAPSHOT_ENABLE(adm)	(*ADM_CTRL_REG(adm) >> ADM_CTRL_SNAPSHOT_ENABLE_BIT) & ADM_CTRL_SNAPSHOT_ENABLE_W	
#define ADM_SET_CTRL_SNAPSHOT_ENABLE(adm)	*ADM_CTRL_REG(adm) |= (1 << ADM_CTRL_SNAPSHOT_ENABLE_BIT)
#define ADM_SET_CTRL_SNAPSHOT_DISABLE(adm)	*ADM_CTRL_REG(adm) &= ~(1 << ADM_CTRL_SNAPSHOT_ENABLE_BIT)

#define ADM_CTRL_DIS_GEM_SNAPSHOT_BIT		17
#define ADM_CTRL_DIS_GEM_SNAPSHOT_W		1
#define ADM_GET_CTRL_GEM_SNAPSHOT_ENABLE(adm)	(*ADM_CTRL_REG(adm) >> ADM_CTRL_DIS_GEM_SNAPSHOT_BIT) & ADM_CTRL_DIS_GEM_SNAPSHOT_W	
#define ADM_SET_CTRL_GEM_SNAPSHOT_ENABLE(adm)	*ADM_CTRL_REG(adm) |= (1 << ADM_CTRL_DIS_GEM_SNAPSHOT_BIT)
#define ADM_SET_CTRL_GEM_SNAPSHOT_DISABLE(adm)	*ADM_CTRL_REG(adm) &= ~(1 << ADM_CTRL_DIS_GEM_SNAPSHOT_BIT)


/* 0x4010 - 0x401C reserved*/


/*************************************** PORT ***********************************************/
#define ADM_PORT_BASE				0x0020
#define adm_port(adm)				(adm_base(adm) + ADM_PORT_BASE)
#define ADM_PORT_SHA_FRAC_RATE(adm)		(volatile unsigned long *)(adm_port(adm) + 0x00)
#define ADM_PORT_SHA_MAX_CREDIT(adm)		(volatile unsigned long *)(adm_port(adm) + 0x04)
#define ADM_PORT_SHA_CREDIT(adm)		(volatile unsigned long *)(adm_port(adm) + 0x08)
#define ADM_PORT_SHA_CTRL(adm)			(volatile unsigned long *)(adm_port(adm) + 0x0C)
#define ADM_PORT_SHA_PKT_OVER(adm)		(volatile unsigned long *)(adm_port(adm) + 0x10)

#define ADM_PORT_SHA_FRAC_RATE_BIT		0
#define ADM_PORT_SHA_FRAC_RATE_W		0xFF
#define ADM_SET_PORT_SHA_FRAC_RATE(adm,value)	SET_REG_BITSHIFT(ADM_PORT_SHA_FRAC_RATE(adm) , value, ADM_PORT_SHA_FRAC_RATE_W , ADM_PORT_SHA_FRAC_RATE_BIT)
#define ADM_GET_PORT_SHA_FRAC_RATE(adm)		(*ADM_PORT_SHA_FRAC_RATE(adm) >> ADM_PORT_SHA_FRAC_RATE_BIT) & ADM_PORT_SHA_FRAC_RATE_W	

#define ADM_PORT_SHA_MAX_CREDIT_BIT		0
#define ADM_PORT_SHA_MAX_CREDIT_W		0x0FFFFF
#define ADM_SET_PORT_SHA_MAX_CREDIT(adm,value)	SET_REG_BITSHIFT(ADM_PORT_SHA_MAX_CREDIT(adm) , value, ADM_PORT_SHA_MAX_CREDIT_W , ADM_PORT_SHA_MAX_CREDIT_BIT)
#define ADM_GET_PORT_SHA_MAX_CREDIT(adm)	(*ADM_PORT_SHA_MAX_CREDIT(adm) >> ADM_PORT_SHA_MAX_CREDIT_BIT) & ADM_PORT_SHA_MAX_CREDIT_W	


#define ADM_PORT_SHA_CREDIT_BIT			0
#define ADM_PORT_SHA_CREDIT_W			0x0FFFFF
#define ADM_SET_PORT_SHA_CREDIT(adm,value)	SET_REG_BITSHIFT(ADM_PORT_SHA_CREDIT(adm), value, ADM_PORT_SHA_CREDIT_W , ADM_PORT_SHA_CREDIT_BIT)
#define ADM_GET_PORT_SHA_CREDIT(adm)		(*ADM_PORT_SHA_CREDIT(adm) >> ADM_PORT_SHA_CREDIT_BIT) & ADM_PORT_SHA_CREDIT_W	


#define ADM_PORT_SHA_PKT_OVER_BIT		0
#define ADM_PORT_SHA_PKT_OVER_W			0x0FFFFF
#define ADM_SET_PORT_SHA_PKT_OVER(adm,value)	 SET_REG_BITSHIFT(ADM_PORT_SHA_PKT_OVER(adm) , value, ADM_PORT_SHA_PKT_OVER_W ,ADM_PORT_SHA_PKT_OVER_BIT)
#define ADM_GET_PORT_SHA_PKT_OVER(adm)		(*ADM_PORT_SHA_PKT_OVER(adm) >> ADM_PORT_SHA_PKT_OVER_BIT) & ADM_PORT_SHA_PKT_OVER_W	

#define ADM_PORT_SHA_ENABLE_BIT			4
#define ADM_PORT_SHA_ENABLE_W			1
#define ADM_SET_PORT_SHA_ENABLE(adm,value)	SET_REG_BITSHIFT(ADM_PORT_SHA_CTRL(adm), value, ADM_PORT_SHA_ENABLE_W ,ADM_PORT_SHA_ENABLE_BIT)
#define ADM_GET_PORT_SHA_ENABLE(adm)		(*ADM_PORT_SHA_CTRL(adm) >> ADM_PORT_SHA_ENABLE_BIT) & ADM_PORT_SHA_ENABLE_W	

#define ADM_PORT_SHA_CLK_BIT			0
#define ADM_PORT_SHA_CLK_W			0x0F
#define ADM_SET_PORT_SHA_CLOCK(adm,value)	SET_REG_BITSHIFT(ADM_PORT_SHA_CTRL(adm), value, ADM_PORT_SHA_CLK_W , ADM_PORT_SHA_CLK_BIT)
#define ADM_GET_PORT_SHA_CLOCK(adm)		(*ADM_PORT_SHA_CTRL(adm) >> ADM_PORT_SHA_CLK_BIT) & ADM_PORT_SHA_CLK_W	


/* 0x4034 - 0x403C reserved */

/*************************************** STATISTICS ******************************************/
#define ADM_STATIS_BASE				0x0040
#define adm_statis(adm)				(adm_base(adm) + ADM_STATIS_BASE)
#define ADM_STATIS_PORT_BYTE_CNT(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x00)
#define ADM_STATIS_PORT_PKT_CNT(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x04)
#define ADM_STATIS_RSVD_BYTE_CNT(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x08)
#define	ADM_STATIS_RSVD_PKT_CNT(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x0C)
#define ADM_STATIS_MNGD_BYTE_CNT(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x10)
#define	ADM_STATIS_MNGD_PKT_CNT(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x14)
#define ADM_STATIS_PKT_DROP_CNT(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x18)
#define ADM_STATIS_PKT_DROP_ERROR(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x1C)
#define ADM_STATIS_PKT_DROP_DENIED(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x20)
#define ADM_STATIS_PKT_DROP_POL0(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x24)
#define ADM_STATIS_PKT_DROP_POL1(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x28)
#define ADM_STATIS_PKT_DROP_QFULL(adm)		(volatile unsigned long *)(adm_statis(adm) + 0x2C)
#define ADM_STATIS_PKT_DROP_SHAPER		(volatile unsigned long *)(adm_statis(adm) + 0x30)
#define ADM_STATIS_PKT_DROP_MNGD_CNGS		(volatile unsigned long *)(adm_statis(adm) + 0x34)
#define ADM_STATIS_PKT_DROP_UNMNGD_CNGS		(volatile unsigned long *)(adm_statis(adm) + 0x38)

/* 0x407C reserved */

/************************************ DEPTH ***********************************************************/
#define ADM_DEPTH_BASE				0x0080
#define adm_depth(adm)				(adm_base(adm) + ADM_DEPTH_BASE)
#define ADM_DEPTH_Q_DEPTH(adm)			(volatile unsigned long *)(adm_depth(adm) + 0x00)
#define ADM_DEPTH_AVG_Q_DEPTH(adm)		(volatile unsigned long *)(adm_depth(adm) + 0x04)
#define ADM_DEPTH_Q_FULL_THRESHOLD(adm)		(volatile unsigned long *)(adm_depth(adm) + 0x08)
#define ADM_DEPTH_Q_DROP_MAX(adm)		(volatile unsigned long *)(adm_depth(adm) + 0x0C)
#define ADM_DEPTH_Q_DROP_MIN(adm)		(volatile unsigned long *)(adm_depth(adm) + 0x10)
#define ADM_DEPTH_PAUSE_INT_TIMER(adm)		(volatile unsigned long *)(adm_depth(adm) + 0x14)
#define ADM_DEPTH_DECAY_TIMER(adm)		(volatile unsigned long *)(adm_depth(adm) + 0x18)
#define ADM_DEPTH_DROP_RANDOM(adm)		(volatile unsigned long *)(adm_depth(adm) + 0x1C)

#define ADM_DEPTH_Q_FULL_THRESHOLD_BIT		0
#define ADM_DEPTH_Q_FULL_THRESHOLD_W		0xFFFF
#define ADM_GET_Q_FULL_THRESHOLD(adm)	(*ADM_DEPTH_Q_FULL_THRESHOLD(adm) >>  ADM_DEPTH_Q_FULL_THRESHOLD_BIT) & ADM_DEPTH_Q_FULL_THRESHOLD_W;
#define ADM_SET_Q_FULL_THRESHOLD(adm,value)	SET_REG_BITSHIFT(ADM_DEPTH_Q_FULL_THRESHOLD(adm), value, ADM_DEPTH_Q_FULL_THRESHOLD_W, ADM_DEPTH_Q_FULL_THRESHOLD_BIT)

#define ADM_DEPTH_Q_DROP_MAX_BIT		8
#define ADM_DEPTH_Q_DROP_MAX_W			0xFFFF
#define ADM_SET_Q_DROP_MAX(adm,value)  SET_REG_BITSHIFT(ADM_DEPTH_Q_DROP_MAX(adm) , value, ADM_DEPTH_Q_DROP_MAX_W, ADM_DEPTH_Q_DROP_MAX_BIT)

#define ADM_SET_FLOWCTRL_ON_TRESHOLD(adm,value) ADM_SET_Q_DROP_MAX(adm, value)

#define ADM_DEPTH_Q_DROP_MIN_BIT		8
#define ADM_DEPTH_Q_DROP_MIN_W			0xFFFF
#define ADM_SET_Q_DROP_MIN(adm,value)		SET_REG_BITSHIFT(ADM_DEPTH_Q_DROP_MIN(adm), value, ADM_DEPTH_Q_DROP_MIN_W , ADM_DEPTH_Q_DROP_MIN_BIT)
#define ADM_SET_FLOWCTRL_OFF_TRESHOLD(adm,value) ADM_SET_Q_DROP_MIN(adm, value)

#define ADM_DEPTH_Q_DEPTH_BIT			0
#define ADM_DEPTH_Q_DEPTH_W			0xFFFF
#define ADM_SET_DEPTH_Q_DEPTH(adm,value)	SET_REG_BITSHIFT(ADM_DEPTH_Q_DEPTH(adm), value, ADM_DEPTH_Q_DEPTH_W , ADM_DEPTH_Q_DEPTH_BIT)

#define ADM_DEPTH_AVG_Q_DEPTH_BIT		16
#define ADM_DEPTH_AVG_Q_DEPTH_W			0xFFFF
#define ADM_SET_DEPTH_AVG_Q_DEPTH(adm,value)	SET_REG_BITSHIFT(ADM_DEPTH_AVG_Q_DEPTH(adm), value, ADM_DEPTH_AVG_Q_DEPTH_W , ADM_DEPTH_AVG_Q_DEPTH_BIT)

#define ADM_DEPTH_DECAY_TIMER_BIT		0
#define ADM_DEPTH_DECAY_TIMER_W			0xFFFFFF
#define ADM_SET_DEPTH_DECAY_TIMER(adm,value)	 SET_REG_BITSHIFT(ADM_DEPTH_DECAY_TIMER(adm), value, ADM_DEPTH_DECAY_TIMER_W , ADM_DEPTH_DECAY_TIMER_BIT)

#define ADM_DEPTH_PAUSE_INT_TIMER_BIT			0
#define ADM_DEPTH_PAUSE_INT_TIMER_W			0xFFFF
#define ADM_SET_DEPTH_PAUSE_INT_TIMER(adm,value)	SET_REG_BITSHIFT(ADM_DEPTH_PAUSE_INT_TIMER(adm), value, ADM_DEPTH_PAUSE_INT_TIMER_W , ADM_DEPTH_PAUSE_INT_TIMER_BIT)


/****************************************** POLICER  ***********************************************/
#define ADM_POLICER0_BASE			0x00A0
#define ADM_POLICER1_BASE			0x00B0
#define ADM_POLICER_BASE(policer)		(policer > 0 ? ADM_POLICER1_BASE : ADM_POLICER0_BASE)
#define adm_pol(adm,policer)			(adm_base(adm) + ADM_POLICER_BASE(policer))
#define ADM_POL_FRAC_RATE(adm,policer)		(volatile unsigned long *)(adm_pol(adm,policer) + 0x00)
#define ADM_POL_MAX_CREDIT(adm,policer)		(volatile unsigned long *)(adm_pol(adm,policer) + 0x04)
#define ADM_POL_CREDIT(adm,policer)		(volatile unsigned long *)(adm_pol(adm,policer) + 0x08)
#define ADM_POL_CTRL(adm,policer)		(volatile unsigned long *)(adm_pol(adm,policer) + 0x0C)

#define ADM_POLICER_FRAC_RATE_BIT			0
#define ADM_POLICER_FRAC_RATE_W				0xFF
#define	ADM_GET_POLICER_FRAC_RATE(adm,policer)		*ADM_POL_FRAC_RATE(adm,policer)
#define	ADM_SET_POLICER_FRAC_RATE(adm,policer,value)	SET_REG_BITSHIFT(ADM_POL_FRAC_RATE(adm,policer), value, ADM_POLICER_FRAC_RATE_W , ADM_POLICER_FRAC_RATE_BIT)

#define ADM_POLICER_MAX_CREDIT_BIT			0
#define ADM_POLICER_MAX_CREDIT_W			0x0FFFFF
#define	ADM_GET_POLICER_MAX_CREDIT(adm,policer)		*ADM_POL_MAX_CREDIT(adm,policer)
#define	ADM_SET_POLICER_MAX_CREDIT(adm,policer,value)	SET_REG_BITSHIFT(ADM_POL_MAX_CREDIT(adm,policer), value, ADM_POLICER_MAX_CREDIT_W , ADM_POLICER_MAX_CREDIT_BIT)

#define ADM_POLICER_INIT_BURST_BIT			0
#define ADM_POLICER_INIT_BURST_W			0x1FFFFF
#define	ADM_GET_POLICER_INIT_BURST(adm,policer)		*ADM_POL_CREDIT(adm,policer)
#define	ADM_SET_POLICER_INIT_BURST(adm,policer,value)	 SET_REG_BITSHIFT(ADM_POL_CREDIT(adm,policer), value, ADM_POLICER_INIT_BURST_W ,< ADM_POLICER_INIT_BURST_BIT)

#define ADM_POLICER_ENABLE_BIT				4
#define ADM_POLICER_ENABLE_W				0x01
#define	ADM_GET_POLICER_ENABLE(adm,policer)		(*ADM_POL_CTRL(adm,policer) >>  ADM_POLICER_ENABLE_BIT) & ADM_POLICER_ENABLE_W
#define	ADM_SET_POLICER_ENABLE(adm,policer,value)	 SET_REG_BITSHIFT(ADM_POL_CTRL(adm,policer), value, ADM_POLICER_ENABLE_W , ADM_POLICER_ENABLE_BIT)

#define ADM_POLICER_CLOCK_BIT				0
#define ADM_POLICER_CLOCK_W				0x0F
#define	ADM_GET_POLICER_CLOCK(adm,policer)		(*ADM_POL_CTRL(adm,policer) >>  ADM_POLICER_CLOCK_BIT) & ADM_POLICER_CLOCK_W
#define	ADM_SET_POLICER_CLOCK(adm,policer,value)	SET_REG_BITSHIFT(ADM_POL_CTRL(adm,policer), value, ADM_POLICER_CLOCK_W , ADM_POLICER_CLOCK_BIT)

/****************************************** LRU ***************************************************/
#define ADM_LRU_BASE			0x00C0
#define adm_lru(adm)			(adm_base(adm) + ADM_LRU_BASE)
#define ADM_LRU_ENTRY(adm)		(volatile unsigned long *)(adm_lru(adm) + 0x00)
#define ADM_LRU_ENTRY_MASK(adm)		(volatile unsigned long *)(adm_lru(adm) + 0x04)
#define ADM_LRU_HIT_CNT_0_3(adm)	(volatile unsigned long *)(adm_lru(adm) + 0x08)
#define ADM_LRU_HIT_CNT_4_7(adm)	(volatile unsigned long *)(adm_lru(adm) + 0x0C)
#define ADM_LRU_HIT_CNT_8_11(adm)	(volatile unsigned long *)(adm_lru(adm) + 0x10)
#define ADM_LRU_HIT_CNT_12_15(adm)	(volatile unsigned long *)(adm_lru(adm) + 0x14)
#define ADM_LRU_HIT_CNT_16_19(adm)	(volatile unsigned long *)(adm_lru(adm) + 0x18)
#define ADM_LRU_HIT_CNT_20_23(adm)	(volatile unsigned long *)(adm_lru(adm) + 0x1C)
#define ADM_LRU_HIT_CNT_24_27(adm)	(volatile unsigned long *)(adm_lru(adm) + 0x20)
#define ADM_LRU_HIT_CNT_28_31(adm)	(volatile unsigned long *)(adm_lru(adm) + 0x24)
#define ADM_LRU_TIMER(adm)		(volatile unsigned long *)(adm_lru(adm) + 0x28)
#define ADM_LRU_PERIOD(adm)		(volatile unsigned long *)(adm_lru(adm) + 0x2C)
#define ADM_LRU_CTRL(adm)		(volatile unsigned long *)(adm_lru(adm) + 0x30)

#define ADM_GET_LRU_ENTRY_BIT		0
#define ADM_GET_LRU_ENTRY_W		0x1F
#define ADM_GET_LRU_ENTRY(adm)		(*ADM_LRU_ENTRY(adm) >> ADM_GET_LRU_ENTRY_BIT) & ADM_GET_LRU_ENTRY_W

#define ADM_GET_LRU_ENTRY_HIT_BIT	16	
#define ADM_GET_LRU_ENTRY_HIT_W		0xFF
#define ADM_GET_LRU_ENTRY_HIT(adm)	(*ADM_LRU_ENTRY(adm) >> ADM_GET_LRU_ENTRY_HIT_BIT) & ADM_GET_LRU_ENTRY_HIT_W

#define ADM_GET_LRU_MASTER_ENABLE_BIT	31	
#define ADM_GET_LRU_MASTER_ENABLE_W	0x1
#define ADM_SET_LRU_MASTER_DISABLE(adm)  *ADM_LRU_ENTRY(adm) |= (ADM_TCAM_VALID_W << ADM_TCAM_VALID_BIT)
#define ADM_SET_LRU_MASTER_ENABLE(adm)   *ADM_LRU_ENTRY(adm) &= ~(ADM_TCAM_VALID_W << ADM_TCAM_VALID_BIT)

#define ADM_GET_LRU_HIT(adm,index)	(*(ADM_LRU_HIT_CNT_0_3(adm) + (index >> 2))) >> ((index & 0x03) * 8)
#define ADM_GET_LRU_HIT_GROUP(adm,index) (*(ADM_LRU_HIT_CNT_0_3(adm) + (index >> 2)))
#define ADM_GET_LRU_HIT_GROUP_ADDR(adm,index) (ADM_LRU_HIT_CNT_0_3(adm) + (index >> 2))
	
#define ADM_SET_LRU_ENABLE(adm,entry)	*ADM_LRU_ENTRY_MASK(adm) |= (1 << entry)

#define ADM_SET_LRU_DISABLE(adm,entry)	*ADM_LRU_ENTRY_MASK(adm) &= ~(1 << entry)

#define ADM_SET_LRU_PERIOD(adm,value)	*ADM_LRU_PERIOD(adm) = value

#define ADM_SET_LRU_MASK(adm,value)	*ADM_LRU_ENTRY_MASK(adm) = value

#define ADM_SET_LRU_STATE(adm, value)	*ADM_LRU_CTRL(adm) |= value

/* 0x40F4 - 0x40FC reserved */

/********************************************** BATCH ******************************************************/
#define ADM_BATCH_BASE			0x0100
#define adm_batch(adm)			(adm_base(adm) + ADM_BATCH_BASE)
#define ADM_BATCH_PKT_CNT(adm)		(volatile unsigned long *)(adm_batch(adm) + 0x00)
#define ADM_BATCH_PKT_THRESHOLD(adm)	(volatile unsigned long *)(adm_batch(adm) + 0x04)
#define ADM_BATCH_TIMER(adm)		(volatile unsigned long *)(adm_batch(adm) + 0x08)
#define ADM_BATCH_TIMER_INIT_VAL(adm)	(volatile unsigned long *)(adm_batch(adm) + 0x0C)
#define ADM_BATCH_INT_STATUS(adm)	(volatile unsigned long *)(adm_batch(adm) + 0x10)

/******************************************* TCAM **********************************************************/
/* Up to 31 entries can be configured */
#define ADM_TCAM_BASE				0x0800
#define ADM_TCAM_ENTRY_SIZE			0x0040
#define check_entry(entry)			(entry > (ADM_TCAM_MAX_ENTRIES - 1) ? 0 : entry) /* means upon error entry 0 is selected */
#define adm_tcam(adm, entry)			(adm_base(adm) + ADM_TCAM_BASE + (check_entry(entry) * ADM_TCAM_ENTRY_SIZE))
#define ADM_TCAM_VALID(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x00)
#define ADM_TCAM_ETHERTYPE(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x04)
#define ADM_TCAM_VLANID(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x08)
#define ADM_TCAM_PPPOEPROTO(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x0C)
#define ADM_TCAM_IPTOS(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x10)
#define ADM_TCAM_IPPROTO(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x14)
#define ADM_TCAM_IPSRC(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x18)
#define ADM_TCAM_IPDST(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x1C)
#define ADM_TCAM_L4_SPORT(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x20)
#define ADM_TCAM_L4_DPORT(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x24)
#define ADM_TCAM_MCAST(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x28)
#define ADM_TCAM_STATE(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x2C)
#define ADM_TCAM_MASK_REG0(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x30)
#define ADM_TCAM_MASK_REG1(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x34)
#define ADM_TCAM_MASK_REG2(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x38)
#define ADM_TCAM_RESERVED(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry) + 0x3C)

#define ADM_GET_TCAM_ENTRY(adm,entry)		(volatile unsigned long *)(adm_tcam(adm,entry))

#define ADM_TCAM_VALID_BIT				0
#define ADM_TCAM_VALID_W				0x01
#define ADM_GET_TCAM_ENABLE(adm,entry)			(*ADM_TCAM_VALID(adm,entry) >> ADM_TCAM_VALID_BIT) & ADM_TCAM_VALID_W
#define ADM_SET_TCAM_ENABLE(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_VALID(adm,entry), value, ADM_TCAM_VALID_W,  ADM_TCAM_VALID_BIT)

#define ADM_TCAM_ETHERTYPE_BIT				0
#define ADM_TCAM_ETHERTYPE_W				0xFFFF
#define ADM_GET_TCAM_ETHERTYPE(adm,entry)		(*ADM_TCAM_ETHERTYPE(adm,entry) >> ADM_TCAM_ETHERTYPE_BIT) & ADM_TCAM_ETHERTYPE_W
#define ADM_SET_TCAM_ETHERTYPE(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_ETHERTYPE(adm,entry), value, ADM_TCAM_ETHERTYPE_W , ADM_TCAM_ETHERTYPE_BIT)

#define ADM_TCAM_VLANID_BIT				0
#define ADM_TCAM_VLANID_W				0xFFFF
#define ADM_GET_TCAM_VLANID(adm,entry)			(*ADM_TCAM_VLANID(adm,entry) >> ADM_TCAM_VLANID_BIT) & ADM_TCAM_VLANID_W
#define ADM_SET_TCAM_VLANID(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_VLANID(adm,entry), value, ADM_TCAM_VLANID_W , ADM_TCAM_VLANID_BIT)

#define	ADM_TCAM_PPPOEPROTO_IP4_BIT			0
#define ADM_TCAM_PPPOEPROTO_IP4_W			0x01
#define ADM_GET_TCAM_PPPOEPROTO_IP4(adm,entry)		(*ADM_TCAM_PPPOEPROTO(adm,entry) >> ADM_TCAM_PPPOEPROTO_IP4_BIT) & ADM_TCAM_PPPOEPROTO_IP4_W
#define ADM_SET_TCAM_PPPOEPROTO_IP4(adm,entry,value) SET_REG_BITSHIFT(ADM_TCAM_PPPOEPROTO(adm,entry), value, ADM_TCAM_PPPOEPROTO_IP4_W , ADM_TCAM_PPPOEPROTO_IP4_BIT)

#define	ADM_TCAM_PPPOEPROTO_IP6_BIT			1
#define ADM_TCAM_PPPOEPROTO_IP6_W			0x01
#define ADM_GET_TCAM_PPPOEPROTO_IP6(adm,entry)		(*ADM_TCAM_PPPOEPROTO(adm,entry) >> ADM_TCAM_PPPOEPROTO_IP6_BIT) & ADM_TCAM_PPPOEPROTO_IP6_W
#define ADM_SET_TCAM_PPPOEPROTO_IP6(adm,entry,value)	 SET_REG_BITSHIFT(ADM_TCAM_PPPOEPROTO(adm,entry), value, ADM_TCAM_PPPOEPROTO_IP6_W, ADM_TCAM_PPPOEPROTO_IP6_BIT)

#define	ADM_TCAM_IPTOS_BIT				0
#define ADM_TCAM_IPTOS_W				0xFF
#define ADM_GET_TCAM_IPTOS(adm,entry)			(*ADM_TCAM_IPTOS(adm,entry) >> ADM_TCAM_IPTOS_BIT) & ADM_TCAM_IPTOS_W
#define ADM_SET_TCAM_IPTOS(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_IPTOS(adm,entry) , value, ADM_TCAM_IPTOS_W , ADM_TCAM_IPTOS_BIT)

#define	ADM_TCAM_IPPROTO_BIT				0
#define ADM_TCAM_IPPROTO_W				0xFF
#define ADM_GET_TCAM_IPPROTO(adm,entry)			(*ADM_TCAM_IPPROTO(adm,entry) >> ADM_TCAM_IPPROTO_BIT) & ADM_TCAM_IPPROTO_W
#define ADM_SET_TCAM_IPPROTO(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_IPPROTO(adm,entry) , value, ADM_TCAM_IPPROTO_W , ADM_TCAM_IPPROTO_BIT)

#define ADM_GET_TCAM_IPSRC(adm,entry)			*ADM_TCAM_IPSRC(adm,entry)
#define ADM_SET_TCAM_IPSRC(adm,entry,value)		*ADM_TCAM_IPSRC(adm,entry) = value

#define ADM_GET_TCAM_IPDST(adm,entry)			*ADM_TCAM_IPDST(adm,entry)
#define ADM_SET_TCAM_IPDST(adm,entry,value)		*ADM_TCAM_IPDST(adm,entry) = value

#define	ADM_TCAM_L4_SPORT_MIN_BIT			0
#define ADM_TCAM_L4_SPORT_MIN_W				0xFFFF
#define ADM_GET_TCAM_L4_SPORT_MIN(adm,entry)		(*ADM_TCAM_L4_SPORT(adm,entry) >> ADM_TCAM_L4_SPORT_MIN_BIT) & ADM_TCAM_L4_SPORT_MIN_W
#define ADM_SET_TCAM_L4_SPORT_MIN(adm,entry,value)	SET_REG_BITSHIFT(ADM_TCAM_L4_SPORT(adm,entry), value, ADM_TCAM_L4_SPORT_MIN_W , ADM_TCAM_L4_SPORT_MIN_BIT)

#define	ADM_TCAM_L4_SPORT_MAX_BIT			16
#define ADM_TCAM_L4_SPORT_MAX_W				0xFFFF
#define ADM_GET_TCAM_L4_SPORT_MAX(adm,entry)		(*ADM_TCAM_L4_SPORT(adm,entry) >> ADM_TCAM_L4_SPORT_MAX_BIT) & ADM_TCAM_L4_SPORT_MAX_W
#define ADM_SET_TCAM_L4_SPORT_MAX(adm,entry,value)	SET_REG_BITSHIFT(ADM_TCAM_L4_SPORT(adm,entry), value, ADM_TCAM_L4_SPORT_MAX_W , ADM_TCAM_L4_SPORT_MAX_BIT)

#define ADM_SET_TCAM_L4_SPORT(adm,entry,min,max)	ADM_SET_TCAM_L4_SPORT_MIN(adm,entry,min); ADM_SET_TCAM_L4_SPORT_MAX(adm,entry,max)

#define	ADM_TCAM_L4_DPORT_MIN_BIT			0
#define ADM_TCAM_L4_DPORT_MIN_W				0xFFFF
#define ADM_GET_TCAM_L4_DPORT_MIN(adm,entry)		(*ADM_TCAM_L4_DPORT(adm,entry) >> ADM_TCAM_L4_SPORT_MIN_BIT) & ADM_TCAM_L4_DPORT_MIN_W
#define ADM_SET_TCAM_L4_DPORT_MIN(adm,entry,value)	SET_REG_BITSHIFT(ADM_TCAM_L4_DPORT(adm,entry), value, ADM_TCAM_L4_DPORT_MIN_W , ADM_TCAM_L4_SPORT_MIN_BIT)

#define	ADM_TCAM_L4_DPORT_MAX_BIT			16
#define ADM_TCAM_L4_DPORT_MAX_W				0xFFFF
#define ADM_GET_TCAM_L4_DPORT_MAX(adm,entry)		(*ADM_TCAM_L4_DPORT(adm,entry) >> ADM_TCAM_L4_DPORT_MAX_BIT) & ADM_TCAM_L4_DPORT_MAX_W
#define ADM_SET_TCAM_L4_DPORT_MAX(adm,entry,value)	SET_REG_BITSHIFT(ADM_TCAM_L4_DPORT(adm,entry), value, ADM_TCAM_L4_DPORT_MAX_W , ADM_TCAM_L4_DPORT_MAX_BIT)

#define ADM_SET_TCAM_L4_DPORT(adm,entry,min,max)	ADM_SET_TCAM_L4_DPORT_MIN(adm,entry,min); ADM_SET_TCAM_L4_DPORT_MAX(adm,entry,max)

#define	ADM_TCAM_MCAST_BIT				0
#define ADM_TCAM_MCAST_W				0x01
#define ADM_GET_TCAM_MCAST(adm,entry)			(*ADM_TCAM_MCAST(adm,entry) >> ADM_TCAM_MCAST_BIT) & ADM_TCAM_MCAST_W
#define ADM_SET_TCAM_MCAST(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_MCAST(adm,entry), value, ADM_TCAM_MCAST_W , ADM_TCAM_MCAST_BIT)

#define	ADM_TCAM_DROP_BIT				0
#define ADM_TCAM_DROP_W					0x01
#define ADM_GET_TCAM_DROP(adm,entry)			(*ADM_TCAM_STATE(adm,entry) >> ADM_TCAM_DROP_BIT) & ADM_TCAM_DROP_W
#define ADM_SET_TCAM_DROP(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_STATE(adm,entry), value, ADM_TCAM_DROP_W , ADM_TCAM_DROP_BIT)

#define	ADM_TCAM_POLICER_BIT				1
#define ADM_TCAM_POLICER_W				0x03
#define ADM_GET_TCAM_POLICER(adm,entry)			(*ADM_TCAM_STATE(adm,entry) >> ADM_TCAM_POLICER_BIT) & ADM_TCAM_POLICER_W
#define ADM_SET_TCAM_POLICER(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_STATE(adm,entry) , value, ADM_TCAM_POLICER_W , ADM_TCAM_POLICER_BIT)

#define	ADM_TCAM_RSVD_BIT				3
#define ADM_TCAM_RSVD_W					0x01
#define ADM_GET_TCAM_RSVD(adm,entry)			(*ADM_TCAM_STATE(adm,entry) >> ADM_TCAM_RSVD_BIT) & ADM_TCAM_RSVD_W
#define ADM_SET_TCAM_RSVD(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_STATE(adm,entry) , value, ADM_TCAM_RSVD_W , ADM_TCAM_RSVD_BIT)

#define ADM_SET_TCAM_ETHERTYPE_MASK_BIT			0
#define ADM_SET_TCAM_ETHERTYPE_MASK_W			0xFFFF
#define ADM_GET_TCAM_ETHERTYPE_MASK(adm,entry)		(*ADM_TCAM_MASK_REG0(adm,entry) >> ADM_SET_TCAM_ETHERTYPE_MASK_BIT) & ADM_SET_TCAM_ETHERTYPE_MASK_W	
#define ADM_SET_TCAM_ETHERTYPE_MASK(adm,entry,value)	 SET_REG_BITSHIFT(ADM_TCAM_MASK_REG0(adm,entry) , value, ADM_SET_TCAM_ETHERTYPE_MASK_W , ADM_SET_TCAM_ETHERTYPE_MASK_BIT)

#define ADM_SET_TCAM_VLAN_MASK_BIT			16
#define ADM_SET_TCAM_VLAN_MASK_W			0xFFFF
#define ADM_GET_TCAM_VLAN_MASK(adm,entry)		(*ADM_TCAM_MASK_REG0(adm,entry) >> ADM_SET_TCAM_VLAN_MASK_BIT) & ADM_SET_TCAM_VLAN_MASK_W
#define ADM_SET_TCAM_VLAN_MASK(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_MASK_REG0(adm,entry), value, ADM_SET_TCAM_VLAN_MASK_W ,ADM_SET_TCAM_VLAN_MASK_BIT)

#define ADM_SET_TCAM_PPPOE_MASK_BIT			0
#define ADM_SET_TCAM_PPPOE_MASK_W			0x03
#define ADM_GET_TCAM_PPPOE_MASK(adm,entry)		(*ADM_TCAM_MASK_REG1(adm,entry) >> ADM_SET_TCAM_PPPOE_MASK_BIT) & ADM_SET_TCAM_PPPOE_MASK_W
#define ADM_SET_TCAM_PPPOE_MASK(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_MASK_REG1(adm,entry), value, ADM_SET_TCAM_PPPOE_MASK_W , ADM_SET_TCAM_PPPOE_MASK_BIT)

#define ADM_SET_TCAM_SPORT_MASK_BIT			2
#define ADM_SET_TCAM_SPORT_MASK_W			0x01
#define ADM_GET_TCAM_SPORT_MASK(adm,entry)		(*ADM_TCAM_MASK_REG1(adm,entry) >> ADM_SET_TCAM_SPORT_MASK_BIT) & ADM_SET_TCAM_SPORT_MASK_W
#define ADM_SET_TCAM_SPORT_MASK(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_MASK_REG1(adm,entry), value, ADM_SET_TCAM_SPORT_MASK_W , ADM_SET_TCAM_SPORT_MASK_BIT)

#define ADM_SET_TCAM_DPORT_MASK_BIT			3
#define ADM_SET_TCAM_DPORT_MASK_W			0x01
#define ADM_GET_TCAM_DPORT_MASK(adm,entry)		(*ADM_TCAM_MASK_REG1(adm,entry) >> ADM_SET_TCAM_DPORT_MASK_BIT) & ADM_SET_TCAM_DPORT_MASK_W
#define ADM_SET_TCAM_DPORT_MASK(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_MASK_REG1(adm,entry), value, ADM_SET_TCAM_DPORT_MASK_W , ADM_SET_TCAM_DPORT_MASK_BIT)

#define ADM_SET_TCAM_IPTOS_MASK_BIT			8
#define ADM_SET_TCAM_IPTOS_MASK_W			0xFF
#define ADM_GET_TCAM_IPTOS_MASK(adm,entry)		(*ADM_TCAM_MASK_REG1(adm,entry) >> ADM_SET_TCAM_IPTOS_MASK_BIT) & ADM_SET_TCAM_IPTOS_MASK_W
#define ADM_SET_TCAM_IPTOS_MASK(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_MASK_REG1(adm,entry) , value, ADM_SET_TCAM_IPTOS_MASK_W , ADM_SET_TCAM_IPTOS_MASK_BIT)

#define ADM_SET_TCAM_IPPROTO_MASK_BIT			16
#define ADM_SET_TCAM_IPPROTO_MASK_W			0xFF
#define ADM_GET_TCAM_IPPROTO_MASK(adm,entry)		(*ADM_TCAM_MASK_REG1(adm,entry) >> ADM_SET_TCAM_IPPROTO_MASK_BIT) & ADM_SET_TCAM_IPPROTO_MASK_W	
#define ADM_SET_TCAM_IPPROTO_MASK(adm,entry,value)	SET_REG_BITSHIFT(ADM_TCAM_MASK_REG1(adm,entry) , value, ADM_SET_TCAM_IPPROTO_MASK_W , ADM_SET_TCAM_IPPROTO_MASK_BIT)

#define ADM_SET_TCAM_MCAST_MASK_BIT			24
#define ADM_SET_TCAM_MCAST_MASK_W			0x01
#define ADM_GET_TCAM_MCAST_MASK(adm,entry)		(*ADM_TCAM_MASK_REG1(adm,entry) >> ADM_SET_TCAM_MCAST_MASK_BIT) & ADM_SET_TCAM_MCAST_MASK_W
#define ADM_SET_TCAM_MCAST_MASK(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_MASK_REG1(adm,entry) , value, ADM_SET_TCAM_MCAST_MASK_W , ADM_SET_TCAM_MCAST_MASK_BIT)

#define ADM_SET_TCAM_BCAST_MASK_BIT			25
#define ADM_SET_TCAM_BCAST_MASK_W			0x01
#define ADM_GET_TCAM_BCAST_MASK(adm,entry)		(*ADM_TCAM_MASK_REG1(adm,entry) >> ADM_SET_TCAM_BCAST_MASK_BIT) & ADM_SET_TCAM_BCAST_MASK_W
#define ADM_SET_TCAM_BCAST_MASK(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_MASK_REG1(adm,entry), value, ADM_SET_TCAM_BCAST_MASK_W , ADM_SET_TCAM_BCAST_MASK_BIT)

#define ADM_SET_TCAM_SADDR_MASK_BIT			0
#define ADM_SET_TCAM_SADDR_MASK_W			0x3F
#define ADM_GET_TCAM_SADDR_MASK(adm,entry)		(*ADM_TCAM_MASK_REG2(adm,entry) >> ADM_SET_TCAM_SADDR_MASK_BIT) & ADM_SET_TCAM_SADDR_MASK_W
#define ADM_SET_TCAM_SADDR_MASK(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_MASK_REG2(adm,entry), value, ADM_SET_TCAM_SADDR_MASK_W , ADM_SET_TCAM_SADDR_MASK_BIT)

#define ADM_SET_TCAM_DADDR_MASK_BIT			8
#define ADM_SET_TCAM_DADDR_MASK_W			0x3F
#define ADM_GET_TCAM_DADDR_MASK(adm,entry)		(*ADM_TCAM_MASK_REG2(adm, entry) >> ADM_SET_TCAM_DADDR_MASK_BIT) & ADM_SET_TCAM_DADDR_MASK_W
#define ADM_SET_TCAM_DADDR_MASK(adm,entry,value)		SET_REG_BITSHIFT(ADM_TCAM_MASK_REG2(adm,entry), value, ADM_SET_TCAM_DADDR_MASK_W , ADM_SET_TCAM_DADDR_MASK_BIT)

#endif /* _ADM_H */
