/*
 *
 *  Copyright (C) 2008 Mindspeed Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _SCH_H
#define _SCH_H

#include "m83xxx_common.h"


extern unsigned long *FAKE_EMAC0_BASE;
extern unsigned long *FAKE_EMAC1_BASE;

/* There's one scheduler block per GEM interface */
#ifdef C1K_REG_SIM
#warning !!!!!!!! running with fake gemac registers
#define sch_base(sch) (get_gemac_base(sch) + 0x8000)
#else
#define sch_base(sch) ((sch > 0 ? APB_VADDR(EMAC1_BASE) : APB_VADDR(EMAC0_BASE)) + 0x8000)
#endif

/******************************** STATUS register ********************************/
#define SCH_STATUS_REG(sch)		(volatile unsigned long *)(sch_base(sch) + 0x00)	

#define SCH_STATUS_QEMPTY_BIT		0
#define SCH_STATUS_QEMPTY_W		0xFF
#define SCH_GET_STATUS_QEMPTY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_QEMPTY_BIT) & SCH_STATUS_QEMPTY_W

#define SCH_STATUS_QNEXT_BIT		8
#define SCH_STATUS_QNEXT_W		0xFF
#define SCH_GET_STATUS_QNEXT(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_QNEXT_BIT) & SCH_STATUS_QNEXT_W

#define SCH_STATUS_Q0RDY_BIT		16
#define SCH_STATUS_Q0RDY_W		0x01
#define SCH_GET_STATUS_Q0RDY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_Q0RDY_BIT) & SCH_STATUS_Q0RDY_W

#define SCH_STATUS_Q1RDY_BIT		17
#define SCH_STATUS_Q1RDY_W		0x01
#define SCH_GET_STATUS_Q1RDY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_Q1RDY_BIT) & SCH_STATUS_Q1RDY_W

#define SCH_STATUS_Q2RDY_BIT		18
#define SCH_STATUS_Q2RDY_W		0x01
#define SCH_GET_STATUS_Q2RDY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_Q2RDY_BIT) & SCH_STATUS_Q2RDY_W

#define SCH_STATUS_Q3RDY_BIT		19
#define SCH_STATUS_Q3RDY_W		0x01
#define SCH_GET_STATUS_Q3RDY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_Q3RDY_BIT) & SCH_STATUS_Q3RDY_W

#define SCH_STATUS_Q4RDY_BIT		20
#define SCH_STATUS_Q4RDY_W		0x01
#define SCH_GET_STATUS_Q4RDY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_Q4RDY_BIT) & SCH_STATUS_Q4RDY_W

#define SCH_STATUS_Q5RDY_BIT		21
#define SCH_STATUS_Q5RDY_W		0x01
#define SCH_GET_STATUS_Q5RDY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_Q5RDY_BIT) & SCH_STATUS_Q5RDY_W

#define SCH_STATUS_BESTRDY_BIT		22
#define SCH_STATUS_BESTRDY_W		0x01
#define SCH_GET_STATUS_BESTRDY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_BESTRDY_BIT) & SCH_STATUS_BESTRDY_W

#define SCH_STATUS_DATARDY_BIT		23
#define SCH_STATUS_DATARDY_W		0x01
#define SCH_GET_STATUS_DATARDY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_DATARDY_BIT) & SCH_STATUS_DATARDY_W

#define SCH_STATUS_VIDEORDY_BIT		24
#define SCH_STATUS_VIDEORDY_W		0x01
#define SCH_GET_STATUS_VIDEORDY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_VIDEORDY_BIT) & SCH_STATUS_VIDEORDY_W

#define SCH_STATUS_VOICERDY_BIT		25
#define SCH_STATUS_VOICERDY_W		0x01
#define SCH_GET_STATUS_VOICERDY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_VOICERDY_BIT) & SCH_STATUS_VOICERDY_W

#define SCH_STATUS_PORTRDY_BIT		26
#define SCH_STATUS_PORTRDY_W		0x01
#define SCH_GET_STATUS_PORTRDY(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_PORTRDY_BIT) & SCH_STATUS_PORTRDY_W

#define SCH_STATUS_QSELSM_BIT		27
#define SCH_STATUS_QSELSM_W		0x07
#define SCH_GET_STATUS_QSELSM(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_QSELSM_BIT) & SCH_STATUS_QSELSM_W

#define SCH_STATUS_PKTERR_BIT		30
#define SCH_STATUS_PKTERR_W		0x01
#define SCH_GET_STATUS_PKTERR(sch)	(*SCH_STATUS_REG(sch) >> SCH_STATUS_PKTERR_BIT) & SCH_STATUS_PKTERR_W

#define SCH_STATUS_RDY_BIT		31
#define SCH_STATUS_RDY_W		0x01
#define SCH_GET_STATUS_RDY(sch)		(*SCH_STATUS_REG(sch) >> SCH_STATUS_RDY_BIT) & SCH_STATUS_RDY_W


/******************************** CONTROL register ********************************/
#define SCH_CTRL_REG(sch)		(volatile unsigned long *)(sch_base(sch) + 0x04)	

#define SCH_CTRL_SHAPER_ENABLE_BIT	0
#define SCH_SET_SHAPER_ENABLE(sch)	*SCH_CTRL_REG(sch) |= (1 << SCH_CTRL_SHAPER_ENABLE_BIT)
#define SCH_SET_SHAPER_DISABLE(sch)	*SCH_CTRL_REG(sch) &= ~(1 << SCH_CTRL_SHAPER_ENABLE_BIT)

#define SCH_CTRL_DWRR_ENABLE_BIT	1
#define SCH_SET_DWRR_ENABLE(sch)	*SCH_CTRL_REG(sch) |= (1 << SCH_CTRL_DWRR_ENABLE_BIT)
#define SCH_SET_DWRR_DISABLE(sch)	*SCH_CTRL_REG(sch) &= ~(1 << SCH_CTRL_DWRR_ENABLE_BIT)

#define SCH_CTRL_SNAPSHOT_BIT		16
#define SCH_SET_SNAPSHOT(sch)		*SCH_CTRL_REG(sch) |= (1 << SCH_CTRL_SNAPSHOT_BIT)

#define SCH_CTRL_GEM_SNAPSHOT_BIT	17
#define SCH_SET_GEM_SNAPSHOT(sch)	*SCH_CTRL_REG(sch) |= (1 << SCH_CTRL_GEM_SNAPSHOT_BIT)



/******************************** PACKET QUEUED register ********************************/
#define SCH_PKT_QUEUED(sch)			(volatile unsigned long *)(sch_base(sch) + 0x08)

#define	SCH_PKT_QUEUED_SIZE_BIT			0
#define SCH_PKT_QUEUED_SIZE_W			0xFFFF
#define	SCH_PKT_QUEUED_Q_BIT			16
#define SCH_PKT_QUEUED_Q_W			0x07

#define SCH_SET_PKT_QUEUED(sch,queue,size)	*SCH_PKT_QUEUED(sch) = ((size & SCH_PKT_QUEUED_SIZE_W) << SCH_PKT_QUEUED_SIZE_BIT) | ((queue & SCH_PKT_QUEUED_Q_W) << SCH_PKT_QUEUED_Q_BIT) 


/******************************** PORT BYTE register ********************************/	
#define SCH_PORT_BYTE_CNT(sch)		(volatile unsigned long *)(sch_base(sch) + 0x0C)

#define SCH_PORT_BYTE_CNT_BIT		0
#define SCH_PORT_BYTE_CNT_W		0xFFFFFFFF
#define SCH_GET_PORT_BYTE_CNT(sch)	(*SCH_PORT_BYTE_CNT(sch) >> SCH_PORT_BYTE_CNT_BIT) & SCH_PORT_BYTE_CNT_W

/******************************** PORT PACKET COUNT register ********************************/
#define SCH_PORT_PKT_CNT(sch)		(volatile unsigned long *)(sch_base(sch) + 0x10)

#define SCH_PORT_PKT_CNT_BIT		0
#define SCH_PORT_PKT_CNT_W		0x03FFFFFF
#define SCH_GET_PORT_PKT_CNT(sch)	(*SCH_PORT_PKT_CNT(sch) >> SCH_PORT_PKT_CNT_BIT) & SCH_PORT_PKT_CNT_W

/******************************** PACKET OVERHEAD register ********************************/
#define SCH_PKT_OVERHEAD(sch)		(volatile unsigned long *)(sch_base(sch) + 0x14)

/******************************** HW FAULT STATUS register ********************************/
#define SCH_HW_FAULT_STATUS(sch)	(volatile unsigned long *)(sch_base(sch) + 0x18)

/******************************** HW FAULT MASK register ********************************/
#define SCH_HW_FAULT_MASK(sch)		(volatile unsigned long *)(sch_base(sch) + 0x1C)

/* 0x8020 - 0x803C reserved */


/******************************** PORT  aggregate Q0 to Q7 ********************************/
#define SCH_PORT_BASE			0x0040
#define sch_port(sch)			(sch_base(sch) + SCH_PORT_BASE)

#define SCH_PORT_BYTE_IN_Q(sch)		(volatile unsigned long *)(sch_port(sch) + 0x00)
#define SCH_PORT_PKT_IN_Q(sch)		(volatile unsigned long *)(sch_port(sch) + 0x04)
#define SCH_PORT_FRAC_RATE(sch)		(volatile unsigned long *)(sch_port(sch) + 0x10)
#define SCH_PORT_MAX_CREDIT(sch)	(volatile unsigned long *)(sch_port(sch) + 0x14)
#define SCH_PORT_CREDIT(sch)		(volatile unsigned long *)(sch_port(sch) + 0x18)
#define SCH_PORT_CONTROL(sch)		(volatile unsigned long *)(sch_port(sch) + 0x1C)

#define SCH_PORT_BYTE_IN_Q_BIT			0
#define SCH_PORT_BYTE_IN_Q_W			0xFFFFFFFF
#define SCH_GET_PORT_BYTE_IN_Q(sch)		(*SCH_PORT_BYTE_IN_Q(sch) >> SCH_PORT_BYTE_IN_Q_BIT) & SCH_PORT_BYTE_IN_Q_W

#define SCH_PORT_PKT_IN_Q_BIT			0
#define SCH_PORT_PKT_IN_Q_W			0x03FFFFFF
#define SCH_GET_PORT_PKT_IN_Q(sch)		(*SCH_PORT_PKT_IN_Q(sch) >> SCH_PORT_PKT_IN_Q_BIT) & SCH_PORT_PKT_IN_Q_W

#define SCH_PORT_FRAC_RATE_BIT			0
#define SCH_PORT_FRAC_RATE_W			0xFF
#define	SCH_GET_PORT_FRAC_RATE(sch)		(*SCH_PORT_FRAC_RATE(sch) >> SCH_PORT_FRAC_RATE_BIT) & SCH_PORT_FRAC_RATE_W
#define	SCH_SET_PORT_FRAC_RATE(sch,value)	SET_REG_BITSHIFT(SCH_PORT_FRAC_RATE(sch) ,value, SCH_PORT_FRAC_RATE_W , SCH_PORT_FRAC_RATE_BIT)

#define SCH_PORT_MAX_CREDIT_BIT			0
#define SCH_PORT_MAX_CREDIT_W			0x0FFFFF
#define	SCH_GET_PORT_MAX_CREDIT(sch)		(*SCH_PORT_MAX_CREDIT(sch) >> SCH_PORT_MAX_CREDIT_BIT) & SCH_PORT_MAX_CREDIT_W
#define	SCH_SET_PORT_MAX_CREDIT(sch,value)	SET_REG_BITSHIFT(SCH_PORT_MAX_CREDIT(sch),value, SCH_PORT_MAX_CREDIT_W , SCH_PORT_MAX_CREDIT_BIT)

#define SCH_PORT_CREDIT_BIT			0
#define SCH_PORT_CREDIT_W			0x1FFFFF
#define	SCH_GET_PORT_INIT_BURST(sch)		(*SCH_PORT_CREDIT(sch) >> SCH_PORT_CREDIT_BIT) & SCH_PORT_CREDIT_W
#define	SCH_SET_PORT_INIT_BURST(sch,value)	SET_REG_BITSHIFT(SCH_PORT_CREDIT(sch) ,value, SCH_PORT_CREDIT_W, SCH_PORT_CREDIT_BIT)

#define SCH_SET_PORT_CONTROL_CLOCK_BIT		0
#define SCH_SET_PORT_CONTROL_CLOCK_W		0x0F
#define SCH_GET_PORT_CONTROL_CLOCK(sch)		(*SCH_PORT_CONTROL(sch) >> SCH_SET_PORT_CONTROL_CLOCK_BIT) & SCH_SET_PORT_CONTROL_CLOCK_W
#define SCH_SET_PORT_CONTROL_CLOCK(sch,value)	SET_REG_BITSHIFT(SCH_PORT_CONTROL(sch) ,value,SCH_SET_PORT_CONTROL_CLOCK_W , SCH_SET_PORT_CONTROL_CLOCK_BIT)

#define SCH_SET_PORT_CONTROL_ENABLE_BIT		4
#define SCH_SET_PORT_CONTROL_ENABLE_W		0x01
#define SCH_GET_PORT_CONTROL_ENABLE(sch)	(*SCH_PORT_CONTROL(sch) >> SCH_SET_PORT_CONTROL_ENABLE_BIT) & SCH_SET_PORT_CONTROL_ENABLE_W
#define SCH_SET_PORT_CONTROL_ENABLE(sch,value)	SET_REG_BITSHIFT(SCH_PORT_CONTROL(sch),value,SCH_SET_PORT_CONTROL_ENABLE_W, SCH_SET_PORT_CONTROL_ENABLE_BIT)




/******************************** GROUP  aggregate Q1 to Q5 ********************************/
#define SCH_GROUP_BASE			0x0060
#define sch_group(sch)			(sch_base(sch) + SCH_GROUP_BASE)
#define SCH_GROUP_BYTE_IN_Q(sch)	(volatile unsigned long *)(sch_group(sch) + 0x00)
#define SCH_GROUP_PKT_IN_Q(sch)		(volatile unsigned long *)(sch_group(sch) + 0x04)
#define SCH_GROUP_FRAC_RATE(sch)	(volatile unsigned long *)(sch_group(sch) + 0x10)
#define SCH_GROUP_MAX_CREDIT(sch)	(volatile unsigned long *)(sch_group(sch) + 0x14)
#define SCH_GROUP_CREDIT(sch)		(volatile unsigned long *)(sch_group(sch) + 0x18)
#define SCH_GROUP_CTRL(sch)		(volatile unsigned long *)(sch_group(sch) + 0x1C)

#define SCH_GROUP_BYTE_IN_Q_BIT			0
#define SCH_GROUP_BYTE_IN_Q_W			0xFFFFFFFF
#define SCH_GET_GROUP_BYTE_IN_Q(sch)		(*SCH_GROUP_BYTE_IN_Q(sch) >> SCH_GROUP_BYTE_IN_Q_BIT) & SCH_GROUP_BYTE_IN_Q_W

#define SCH_GROUP_PKT_IN_Q_BIT			0
#define SCH_GROUP_PKT_IN_Q_W			0x03FFFFFF
#define SCH_GET_GROUP_PKT_IN_Q(sch)		(*SCH_GROUP_PKT_IN_Q(sch) >> SCH_GROUP_PKT_IN_Q_BIT) & SCH_GROUP_PKT_IN_Q_W

#define SCH_GROUP_FRAC_RATE_BIT			0
#define SCH_GROUP_FRAC_RATE_W			0xFF
#define	SCH_GET_GROUP_FRAC_RATE(sch)		(*SCH_GROUP_FRAC_RATE(sch) >> SCH_GROUP_FRAC_RATE_BIT) & SCH_GROUP_FRAC_RATE_W
#define	SCH_SET_GROUP_FRAC_RATE(sch,value)	SET_REG_BITSHIFT(SCH_GROUP_FRAC_RATE(sch) ,value, SCH_GROUP_FRAC_RATE_W , SCH_GROUP_FRAC_RATE_BIT)

#define SCH_GROUP_MAX_CREDIT_BIT		0
#define SCH_GROUP_MAX_CREDIT_W			0x0FFFFF
#define	SCH_GET_GROUP_MAX_CREDIT(sch)		(*SCH_GROUP_MAX_CREDIT(sch) >> SCH_GROUP_MAX_CREDIT_BIT) & SCH_GROUP_MAX_CREDIT_W
#define	SCH_SET_GROUP_MAX_CREDIT(sch,value)	SET_REG_BITSHIFT(SCH_GROUP_MAX_CREDIT(sch) ,value, SCH_GROUP_MAX_CREDIT_W , SCH_GROUP_MAX_CREDIT_BIT)

#define SCH_GROUP_CREDIT_BIT			0
#define SCH_GROUP_CREDIT_W			0x1FFFFF
#define	SCH_GET_GROUP_INIT_BURST(sch)		(*SCH_GROUP_CREDIT(sch) >> SCH_GROUP_CREDIT_BIT) & SCH_GROUP_CREDIT_W
#define	SCH_SET_GROUP_INIT_BURST(sch,value)	SET_REG_BITSHIFT(SCH_GROUP_CREDIT(sch) ,value, SCH_GROUP_CREDIT_W , SCH_GROUP_CREDIT_BIT)

#define SCH_SET_GROUP_CONTROL_CLOCK_BIT		0
#define SCH_SET_GROUP_CONTROL_CLOCK_W		0x0F
#define SCH_GET_GROUP_CONTROL_CLOCK(sch)	(*SCH_GROUP_CTRL(sch) >> SCH_SET_GROUP_CONTROL_CLOCK_BIT) & SCH_SET_GROUP_CONTROL_CLOCK_W
#define SCH_SET_GROUP_CONTROL_CLOCK(sch,value)	SET_REG_BITSHIFT(SCH_GROUP_CTRL(sch),value, SCH_SET_GROUP_CONTROL_CLOCK_W , SCH_SET_GROUP_CONTROL_CLOCK_BIT)

#define SCH_SET_GROUP_CONTROL_ENABLE_BIT	4
#define SCH_SET_GROUP_CONTROL_ENABLE_W		0x01
#define SCH_GET_GROUP_CONTROL_ENABLE(sch)	(*SCH_GROUP_CTRL(sch) >> SCH_SET_GROUP_CONTROL_ENABLE_BIT) & SCH_SET_GROUP_CONTROL_ENABLE_W
#define SCH_SET_GROUP_CONTROL_ENABLE(sch,value)	SET_REG_BITSHIFT(SCH_GROUP_CTRL(sch),value, SCH_SET_GROUP_CONTROL_ENABLE_W, SCH_SET_GROUP_CONTROL_ENABLE_BIT)



/******************************** QUEUES  ********************************/
/* Up to 8 queues  can be configured */
#define SCH_Q_BASE			0x0080
#define SCH_Q_SIZE			0x0020
#define check_queue(queue)		(queue > 7 ? 0 : queue) /* means upon error queue 0 is selected */
#define check_queue1_5(queue)		(check_queue(queue) > 5 ? 1 : queue) /* means upon error queue 1 is selected */
#define check_queue6_7(queue)		(check_queue(queue) < 6 ? 6 : queue) /* means upon error queue 6 is selected */
#define sch_queue(sch, queue)		(sch_base(sch) + SCH_Q_BASE + (check_queue(queue) * SCH_Q_SIZE))
#define sch_queue1_5(sch, queue)	(sch_base(sch) + SCH_Q_BASE + (check_queue1_5(queue) * SCH_Q_SIZE))
#define sch_queue6_7(sch, queue)	(sch_base(sch) + SCH_Q_BASE + (check_queue6_7(queue) * SCH_Q_SIZE))

#define SCH_Q_BYTE_IN_Q(sch,queue)	(volatile unsigned long *)(sch_queue(sch,queue) + 0x00)
#define SCH_Q_PKT_IN_Q(sch,queue)	(volatile unsigned long *)(sch_queue(sch,queue) + 0x04)
#define SCH_Q_IDLE(sch,queue)		(volatile unsigned long *)(sch_queue(sch,queue) + 0x08)

#define SCH_Q_DWRR_WEIGHT(sch,queue)	(volatile unsigned long *)(sch_queue1_5(sch,queue) + 0x10)
#define SCH_Q_DWRR_CREDIT(sch,queue)	(volatile unsigned long *)(sch_queue1_5(sch,queue) + 0x14)

#define SCH_Q_FRAC_RATE(sch,queue)	(volatile unsigned long *)(sch_queue6_7(sch,queue) + 0x10)
#define SCH_Q_MAX_CREDIT(sch,queue)	(volatile unsigned long *)(sch_queue6_7(sch,queue) + 0x14)
#define SCH_Q_CREDIT(sch,queue)		(volatile unsigned long *)(sch_queue6_7(sch,queue) + 0x18)
#define SCH_Q_CONTROL(sch,queue)	(volatile unsigned long *)(sch_queue6_7(sch,queue) + 0x1C)

#define SCH_Q_BYTE_IN_Q_BIT			0
#define SCH_Q_BYTE_IN_Q_W			0xFFFFFFFF
#define SCH_GET_Q_BYTE_IN_Q(sch,queue)		(*SCH_Q_BYTE_IN_Q(sch,queue) >> SCH_Q_BYTE_IN_Q_BIT) & SCH_Q_BYTE_IN_Q_W

#define SCH_Q_PKT_IN_Q_BIT			0
#define SCH_Q_PKT_IN_Q_W			0x03FFFFFF
#define SCH_GET_Q_PKT_IN_Q(sch,queue)		(*SCH_Q_PKT_IN_Q(sch,queue) >> SCH_Q_PKT_IN_Q_BIT) & SCH_Q_PKT_IN_Q_W

#define SCH_Q_IDLE_BIT				0
#define SCH_Q_IDLE_W				0xFFFFFFFF
#define SCH_GET_Q_IDLE(sch,queue)		(*SCH_Q_IDLE(sch,queue) >> SCH_Q_IDLE_BIT) & SCH_Q_IDLE_W

#define SCH_Q_DWRR_WEIGHT_BIT			0
#define SCH_Q_DWRR_WEIGHT_W			0x0FFFFF
#define	SCH_GET_Q_DWRR_WEIGHT(sch,queue)	(*SCH_Q_DWRR_WEIGHT(sch,queue) >> SCH_Q_DWRR_WEIGHT_BIT) & SCH_Q_DWRR_WEIGHT_W
#define	SCH_SET_Q_DWRR_WEIGHT(sch,queue,value)	SET_REG_BITSHIFT(SCH_Q_DWRR_WEIGHT(sch,queue) ,value, SCH_Q_DWRR_WEIGHT_W , SCH_Q_DWRR_WEIGHT_BIT)

#define SCH_Q_DWRR_CREDIT_BIT			0
#define SCH_Q_DWRR_CREDIT_W			0x1FFFFF
#define	SCH_GET_Q_DWRR_CREDIT(sch,queue)	(*SCH_Q_DWRR_CREDIT(sch,queue) >> SCH_Q_DWRR_CREDIT_BIT) & SCH_Q_DWRR_CREDIT_W
#define	SCH_SET_Q_DWRR_CREDIT(sch,queue,value)	SET_REG_BITSHIFT(SCH_Q_DWRR_CREDIT(sch,queue),value, SCH_Q_DWRR_CREDIT_W , SCH_Q_DWRR_CREDIT_BIT)

#define SCH_Q_FRAC_RATE_BIT			0
#define SCH_Q_FRAC_RATE_W			0xFF
#define	SCH_GET_Q_FRAC_RATE(sch,queue)		(*SCH_Q_FRAC_RATE(sch,queue) >> SCH_Q_FRAC_RATE_BIT) & SCH_Q_FRAC_RATE_W
#define	SCH_SET_Q_FRAC_RATE(sch,queue,value)	SET_REG_BITSHIFT(SCH_Q_FRAC_RATE(sch,queue),value, SCH_Q_FRAC_RATE_W , SCH_Q_FRAC_RATE_BIT)

#define SCH_Q_MAX_CREDIT_BIT			0
#define SCH_Q_MAX_CREDIT_W			0x0FFFFF
#define	SCH_GET_Q_MAX_CREDIT(sch,queue)		(*SCH_Q_MAX_CREDIT(sch,queue) >> SCH_Q_MAX_CREDIT_BIT) & SCH_Q_MAX_CREDIT_W
#define	SCH_SET_Q_MAX_CREDIT(sch,queue,value)	SET_REG_BITSHIFT(SCH_Q_MAX_CREDIT(sch,queue),value, SCH_Q_MAX_CREDIT_W , SCH_Q_MAX_CREDIT_BIT)

#define SCH_Q_CREDIT_BIT			0
#define SCH_Q_CREDIT_W				0x1FFFFF
#define	SCH_GET_Q_INIT_BURST(sch,queue)		(*SCH_Q_CREDIT(sch,queue) >> SCH_Q_CREDIT_BIT) & SCH_Q_CREDIT_W
#define	SCH_SET_Q_INIT_BURST(sch,queue,value)	SET_REG_BITSHIFT(SCH_Q_CREDIT(sch,queue) ,value, SCH_Q_CREDIT_W , SCH_Q_CREDIT_BIT)

#define SCH_Q_CONTROL_CLOCK_BIT				0
#define SCH_Q_CONTROL_CLOCK_W				0x0F
#define SCH_GET_Q_CONTROL_CLOCK(sch,queue)		(*SCH_Q_CONTROL(sch,queue) >> SCH_Q_CONTROL_CLOCK_BIT) & SCH_Q_CONTROL_CLOCK_W
#define SCH_SET_Q_CONTROL_CLOCK(sch,queue,value)	SET_REG_BITSHIFT(SCH_Q_CONTROL(sch,queue) ,value, SCH_Q_CONTROL_CLOCK_W , SCH_Q_CONTROL_CLOCK_BIT)

#define SCH_Q_CONTROL_ENABLE_BIT			4
#define SCH_Q_CONTROL_ENABLE_W				0x01
#define SCH_GET_Q_CONTROL_ENABLE(sch,queue)		(*SCH_Q_CONTROL(sch,queue) >> SCH_Q_CONTROL_ENABLE_BIT) & SCH_Q_CONTROL_ENABLE_W
#define SCH_SET_Q_CONTROL_ENABLE(sch,queue,value)	SET_REG_BITSHIFT(SCH_Q_CONTROL(sch,queue) ,value, SCH_Q_CONTROL_ENABLE_W , SCH_Q_CONTROL_ENABLE_BIT)

#endif /* _SCH_H */
