/*
 *
 *  Copyright (C) 2007 Mindspeed Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _QOSDRIVER_H
#define _QOSDRIVER_H

#include "m83xxx_adm.h"
#include "m83xxx_sch.h"
#include "qos_fops.h"


/*
* Debug macros
*/

#define QOS_PRINT	1	
#define QOS_ERR		1
#define QOS_INFO	0
#define QOS_INIT	0
#define QOS_STAT	0
#define QOS_REGS_DUMP	1
#define QOS_IOCTL	0
#define QOS_TCAM_DEBUG	0
#define QOS_POLICER	0
#define QOS_SHAPER	0

#ifdef QOS_PRINT
#define QOS_PRINTK(type, info, args...) do {if(type) printk("\n" info, ## args);} while(0);
#else
#define QOS_PRINTK(type, info, args...) do {} while(0);
#endif


#define QOS_ADM_BLOCK	1
#define QOS_SCH_BLOCK	2

struct _ADM_TCAM_DESC
{
	unsigned char slot;
	struct _ADM_TCAM_ENTRY entry;
};



struct _QOS_ADM
{
	/* To differentiate between the two admittance blocks */
	unsigned char	index;
	
	/* Ingress counters */
	struct _ADM_COUNTER	*counter;

	/* CAM entries table*/
	//unsigned char	cam_slot_table[ADM_TCAM_MAX_ENTRIES];
	//unsigned char	cam_handle_table[ADM_TCAM_MAX_ENTRIES];
	struct _ADM_TCAM_DESC cam_hw_table[ADM_TCAM_MAX_ENTRIES];
	struct _ADM_TCAM_DESC cam_sw_table[ADM_TCAM_MAX_ENTRIES];

	/* LRU counters */
	struct _ADM_LRU_STATS	*lru_stats;
};




struct _QOS_SCH
{
	/* To differentiate between the two scheduler blocks */
	unsigned int index;
};

int qos_proc_info_adm(char* page, char** start, off_t off, int count, int *eof, void* data);
int qos_proc_info_sch(char* page, char** start, off_t off, int count, int *eof, void* data);


#endif /* _QOSDRIVER_H */
