/* -- updatedd: get_connection.h --
 *
 * Copyright (C) 2002, 2003, 2004 Philipp Benner
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef GET_CONNECTION_H
#define GET_CONNECTION_H

#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <fcntl.h>

#define DEFAULT_TIMEOUT 15 //10 seconds wait reply from server

inline int
get_connection(const char *hostname, const int port, const char **err, char *if_name)
{
    struct sockaddr_in addr;
    struct hostent *host;
    int s;
    struct timeval timeout;
    fd_set fdR, fdW;
    int i_select;
    int error;
    socklen_t len;

    if((host = gethostbyname(hostname)) == NULL) {
        *err = "gethostbyname() failed";
        return -1;
    }

    addr.sin_family = AF_INET;
    addr.sin_port   = htons(port);
    addr.sin_addr   = *(struct in_addr*)host->h_addr;

    s = socket(AF_INET, SOCK_STREAM, 0);
    if(s == -1) {
        *err = "socket() failed";
        return -2;
    }

    if(fcntl(s, F_SETFL, O_NONBLOCK) == -1) {
        close(s);
        *err = "set non-block mode failed";
        return -3;
    }

    if(setsockopt(s, SOL_SOCKET, SO_BINDTODEVICE, if_name, strlen(if_name) + 1) != 0) {
        close(s);
        *err = "bind device failed";
        return -4;
    }

    connect(s, (struct sockaddr*)&addr, sizeof(addr));

    FD_ZERO(&fdR);
    FD_ZERO(&fdW);
    FD_SET(s, &fdR);
    FD_SET(s, &fdW);
    timeout.tv_sec = DEFAULT_TIMEOUT;
    timeout.tv_usec = 0;

    i_select = select(s + 1, &fdR, &fdW, NULL, &timeout);

    if(i_select == 0) //timed out
    {
        close(s);
        *err = "connect timed out";
        return -5;
    }
    else if(i_select > 0)
    {
        if(FD_ISSET(s, &fdR) || FD_ISSET(s, &fdW))
        {
            if(getsockopt(s, SOL_SOCKET, SO_ERROR, &error, &len) == 0) 
            {
                if(error != 0)
                {
                    close(s);
                    printf("error:%d errno:%d\n", error, errno);
                    *err = "socket option error";
                    return -6;
                }

            }
            else
            {
                close(s);
                *err = "get socket option error";
                return -7;
            }
        }
    } else {
        close(s);
        *err = "select error";
        return -8;
    }

    return s;

}

#endif /* GET_CONNECTION_H */
