/*
 * Copyright (c) 1998, 1999, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.bdi.OutputListener;

public class TypeScriptOutputListener implements OutputListener {

    private TypeScript script;
    private boolean appendNewline;

    public TypeScriptOutputListener(TypeScript script) {
        this(script, false);
    }

    public TypeScriptOutputListener(TypeScript script, boolean appendNewline) {
        this.script = script;
        this.appendNewline = appendNewline;
    }

    @Override
    public void putString(String s) {
        script.append(s);
        if (appendNewline) {
            script.newline();
    }
    }

}
