

#include <config.h>
#include <version.h>
#if !defined(CONFIG_INTEGRATOR) && ! defined(CONFIG_ARCH_CINTEGRATOR) && ! defined (CONFIG_COMCERTO_900) && !defined (CONFIG_COMCERTO_100) && !defined (CONFIG_COMCERTO_1000)
#include <asm/arch/omap2420.h>
#elif  defined (CONFIG_COMCERTO_900)  || defined (CONFIG_COMCERTO_100) || defined (CONFIG_COMCERTO_1000)
#include <asm/hardware.h>
#endif
	/* Reverse endian*/
	.macro REV_ENDIAN dst, src
#if defined(BE8_MODE)
	rev  \dst, \src
#else
	nop
#endif
	.endm

.global _start
_start: b	reset


/*
 * the actual reset code
 */

reset:

#ifdef CONFIG_COMCERTO_100
#if defined(BE8_MODE)
	setend	be
#endif
/*
	remove lock
*/
	ldr	r2, =GPIO_LOCK_REG
	ldr	r3, =GPIO_IOCTRL_VAL
	str	r3, [r2]
	ldr	r2, =GPIO_IOCTRL_REG
	ldr	r3, [r2]
#if defined(BE8_MODE)
	REV_ENDIAN	r3, r3
#endif
/*
	enable address line A15-A21
*/
	orr	r3, r3, #0xF
#if defined(BE8_MODE)
	REV_ENDIAN	r3, r3
#endif
#endif

#if defined(CONFIG_COMCERTO_1000)
#if defined(BE8_MODE)
	setend	be
#endif
/*
	enable address line A13-A21
*/
	ldr	r2, =GPIO_PIN_SELECT_REG
	ldr	r3, [r2]
#if defined(BE8_MODE)
	REV_ENDIAN	r3, r3
#endif
        bic	r3, r3, #0x40           @ clear bits 6
        bic	r3, r3, #0x4F00         @ clear bits 14,11:8
        bic	r3, r3, #0xE0000000     @ clear bits 31:29
#if defined(BE8_MODE)
	REV_ENDIAN	r3, r3
#endif
#endif
	str	r3, [r2]

rom_second_loc:

	/*
	 * set the cpu to SVC32 mode
	 */
	mrs	r0,cpsr
	bic	r0,r0,#0x1f
	orr	r0,r0,#0xd3
	msr	cpsr,r0

	/* the mask ROM code should have PLL and others stable */
	bl  cpu_init_crit


	ldr	pc, _relocate_nand_u_boot

_relocate_nand_u_boot: .word relocate_nand_u_boot


/*
 *************************************************************************
 *
 * CPU_init_critical registers
 *
 * setup important registers
 * setup memory timing
 *
 *************************************************************************
 */
cpu_init_crit:
	/*
	 * flush v4 I/D caches
	 */
	mov	r0, #0
	mcr	p15, 0, r0, c7, c7, 0	/* flush v3/v4 cache */
	mcr	p15, 0, r0, c8, c7, 0	/* flush v4 TLB */

#if defined(BE8_MODE)
	mrc	p15, 0, r0, c1, c0, 0   /* read control reg */
	orr	r0, r0, #(1 << 25)      /* enable be-8 mode */
	mcr	p15, 0, r0, c1, c0, 0   /* write control reg */
#endif //BE8_MODE

	/*
	 * disable MMU stuff and caches
	 */
	mrc	p15, 0, r0, c1, c0, 0
	bic	r0, r0, #0x00002300	@ clear bits 13, 9:8 (--V- --RS)
	bic	r0, r0, #0x00000087	@ clear bits 7, 2:0 (B--- -CAM)
	orr	r0, r0, #0x00000002	@ set bit 2 (A) Align
	orr	r0, r0, #0x00001000	@ set bit 12 (I) I-Cache
	orr	r0, r0, #0x00400000	@ set bit 22 (U) 
	mcr	p15, 0, r0, c1, c0, 0

	/*
	 * Jump to board specific initialization... The Mask ROM will have already initialized
	 * basic memory.  Go here to bump up clock rate and handle wake up conditions.
	 */
	mov	ip, lr		/* persevere link reg across call */
	bl	lowlevel_init	/* go setup pll,mux,memory */
	mov	lr, ip		/* restore link */
	mov	pc, lr		/* back to my caller */



.globl lowlevel_init
lowlevel_init:

	stmdb	sp!, {ip, lr}
	bl	bsp_init	/* go setup pll, memory */
	ldmia	sp!, {ip, pc}	/* restore registers and return to caller */






