# 
# Copyright (C) 2006 OpenWrt.org
#
# This is free software, licensed under the GNU General Public License v2.
# See /LICENSE for more information.
#

override TARGET_BUILD=
include $(INCLUDE_DIR)/prereq.mk
include $(INCLUDE_DIR)/kernel.mk
include $(INCLUDE_DIR)/host.mk
.NOTPARALLEL:
override MAKEFLAGS=
override MAKE:=$(SUBMAKE)
KDIR=$(KERNEL_BUILD_DIR)

ifneq ($(CONFIG_BIG_ENDIAN),y)
JFFS2OPTS     :=  --pad --little-endian --squash
ifeq ($(CONFIG_BOOT_NAND),y)
JFFS2OPTS     :=  --pad --little-endian --squash -n
endif
SQUASHFS_OPTS :=  -le
else
JFFS2OPTS     :=  --pad --big-endian --squash
ifeq ($(CONFIG_BOOT_NAND),y)
JFFS2OPTS     :=  --pad --big-endian --squash -n
endif
SQUASHFS_OPTS :=  -be
endif
JFFS2_BLOCKSIZE ?= 64k 128k

ifeq ($(CONFIG_BOOT_NAND),y)
  UBIFSOPTS := -x lzo -m 2048 -e 129024 -c 250 -U
  UBINIZEOPTS := -p 131072 -m 2048 -s 512 -O 512
else
  UBIFSOPTS := -x zlib -m 1 -e 130944 -c 250 -U
  UBINIZEOPTS := -p 128KiB -m 1 -s 1
endif

define add_jffs2_mark
	echo -ne '\xde\xad\xc0\xde' >> $(1)
endef

# pad to 64k and add jffs2 end-of-filesystem mark
# do this twice to make sure that this works with 128k blocksize as well
define prepare_generic_squashfs
	dd if=$(1) of=$(KDIR)/tmpfile.1 bs=64k conv=sync
	$(call add_jffs2_mark,$(KDIR)/tmpfile.1)
	dd of=$(1) if=$(KDIR)/tmpfile.1 bs=64k conv=sync
	$(call add_jffs2_mark,$(1))
endef

ifneq ($(CONFIG_TARGET_ROOTFS_INITRAMFS),y)
  ifeq ($(CONFIG_TARGET_ROOTFS_JFFS2),y)
    define Image/mkfs/jffs2/sub
		# FIXME: removing this line will cause strange behaviour in the foreach loop below
		$(STAGING_DIR_HOST)/bin/mkfs.jffs2 $(JFFS2OPTS) -e $(patsubst %k,%KiB,$(1)) -o $(KDIR)/root.jffs2-$(1) -d $(TARGET_DIR)
		$(call add_jffs2_mark,$(KDIR)/root.jffs2-$(1))
		$(call Image/Build,jffs2-$(1))
    endef
    define Image/mkfs/jffs2
		rm -rf $(TARGET_DIR)/jffs
		$(foreach SZ,$(JFFS2_BLOCKSIZE),$(call Image/mkfs/jffs2/sub,$(SZ)))
    endef
  endif

  ifeq ($(CONFIG_TARGET_ROOTFS_UBIFS),y)
    define Image/mkfs/ubifs
		mkdir -p $(TARGET_DIR)/etc/persistence
		mkdir -p $(TARGET_DIR)/data
		mkdir -p $(TARGET_DIR)/config_backup
		
		# Copy to temp dir
		mkdir -p $(TARGET_DIR)/etc/build_temp
		mkdir -p $(TARGET_DIR)/etc/build_temp/config
		mkdir -p $(TARGET_DIR)/etc/build_temp/data
		cp $(TARGET_DIR)/etc/config/* $(TARGET_DIR)/etc/build_temp/config
		cp $(TARGET_DIR)/etc/passwd $(TARGET_DIR)/etc/build_temp/data
		cp $(TARGET_DIR)/etc/group $(TARGET_DIR)/etc/build_temp/data
		cp $(TARGET_DIR)/etc/passwd_md5 $(TARGET_DIR)/etc/build_temp/data
		
		# Make config image
		#$(STAGING_DIR_HOST)/bin/mkfs.jffs2 $(JFFS2OPTS) -e 0x20000 -o $(KDIR)/config.jffs2-128k -d $(TARGET_DIR)/root/etc/build_temp
		
		# Move to default folder
		mkdir -p $(TARGET_DIR)/etc/config-default
		mkdir -p $(TARGET_DIR)/etc/data-default
		cp $(TARGET_DIR)/etc/build_temp/config/* $(TARGET_DIR)/etc/config-default
		cp $(TARGET_DIR)/etc/build_temp/data/* $(TARGET_DIR)/etc/data-default
		
		# Delete them
		rm -rf $(TARGET_DIR)/etc/config
		rm -rf $(TARGET_DIR)/etc/build_temp/config
		rm -rf $(TARGET_DIR)/etc/build_temp/data
		rm -f $(TARGET_DIR)/etc/passwd
		rm -f $(TARGET_DIR)/etc/group
		rm -f $(TARGET_DIR)/etc/passwd_md5
		
		# Make fs image
		mkdir -p $(TARGET_DIR)/etc/myconfig
		$(STAGING_DIR_HOST)/bin/mkfs.ubifs $(UBIFSOPTS) -o $(KDIR)/root.ubifs-zlib -d $(TARGET_DIR)
		$(STAGING_DIR_HOST)/bin/ubinize -o $(KDIR)/root.ubifs-ubinized $(UBINIZEOPTS) $(TOPDIR)/ubifs_args_local.ini
		
		# Recover root fs for further use
		mkdir -p $(TARGET_DIR)/etc/config
		cp $(TARGET_DIR)/etc/config-default/* $(TARGET_DIR)/etc/config
		cp $(TARGET_DIR)/etc/data-default/passwd $(TARGET_DIR)/etc
		cp $(TARGET_DIR)/etc/data-default/group $(TARGET_DIR)/etc
		cp $(TARGET_DIR)/etc/data-default/passwd_md5 $(TARGET_DIR)/etc
		
		# add End-of-Filesystem markers
		#$(call add_jffs2_mark,$(KDIR)/config.jffs2-128k)
	
		$(call Image/Build,ubifs)
    endef
  endif

  ifeq ($(CONFIG_TARGET_ROOTFS_SQUASHFS),y)
    define Image/mkfs/squashfs
		@mkdir -p $(TARGET_DIR)/jffs
		$(STAGING_DIR_HOST)/bin/mksquashfs-lzma $(TARGET_DIR) $(KDIR)/root.squashfs -nopad -noappend -root-owned $(SQUASHFS_OPTS)
		$(call Image/Build,squashfs)
    endef
  endif

  ifeq ($(CONFIG_TARGET_ROOTFS_TGZ),y)
    define Image/mkfs/tgz
		$(TAR) -zcf $(BIN_DIR)/openwrt-$(BOARD)-$(KERNEL)-rootfs.tgz --owner=root --group=root -C $(TARGET_DIR)/ .
    endef
  endif

  ifeq ($(CONFIG_TARGET_ROOTFS_NFS),y)
    define Image/mkfs/nfs
	echo "file system to be installed at $(CONFIG_ROOTFS_NFS_PATH)"
	sudo rm -rf $(CONFIG_ROOTFS_NFS_PATH)
	sudo mkdir -p $(CONFIG_ROOTFS_NFS_PATH)
	sudo cp -a $(TARGET_DIR)/* $(CONFIG_ROOTFS_NFS_PATH)
	sed -i '/option[ \t]*ifname[ \t]*eth0/a\      option auto     disable' $(CONFIG_ROOTFS_NFS_PATH)/etc/config/network
    endef
  endif
else
  define Image/BuildKernel
	cp $(KDIR)/vmlinux.elf $(BIN_DIR)/openwrt-$(BOARD)-$(KERNEL)-vmlinux.elf
  endef
endif


ifeq ($(CONFIG_TARGET_ROOTFS_EXT2FS),y)
  E2SIZE=$(shell echo $$(($(CONFIG_TARGET_ROOTFS_FSPART)*1024)))
  
  define Image/mkfs/ext2
		$(STAGING_DIR_HOST)/bin/genext2fs -U -b $(E2SIZE) -I $(CONFIG_TARGET_ROOTFS_MAXINODE) -d $(TARGET_DIR)/ $(KDIR)/root.ext2
		$(call Image/Build,ext2)
  endef
endif


define Image/mkfs/prepare/default
	find $(TARGET_DIR) -type f -not -perm +0100 -not -name 'ssh_host*' | $(XARGS) chmod 0644
	find $(TARGET_DIR) -type f -perm +0100 | $(XARGS) chmod 0755
	find $(TARGET_DIR) -type d | $(XARGS) chmod 0755
	$(INSTALL_DIR) $(TARGET_DIR)/tmp
	chmod 0777 $(TARGET_DIR)/tmp
endef

define Image/mkfs/prepare
	$(call Image/mkfs/prepare/default)
endef

define BuildImage
download:
prepare:
ifneq ($(IB),1)
  compile: compile-targets
	$(call Build/Compile)
else
  compile:
endif

ifneq ($(IB),1)
  install: compile install-targets
	$(call Image/Prepare)
	$(call Image/mkfs/prepare)
	$(call Image/BuildKernel)
	$(call Image/mkfs/jffs2)
	$(call Image/mkfs/ubifs)
	$(call Image/mkfs/squashfs)
	$(call Image/mkfs/tgz)
	$(call Image/mkfs/ext2)
	$(call Image/mkfs/nfs)
else
  install: compile install-targets
	$(call Image/BuildKernel)
	$(call Image/mkfs/jffs2)
	$(call Image/mkfs/ubifs)
	$(call Image/mkfs/squashfs)
	$(call Image/mkfs/tgz)
	$(call Image/mkfs/ext2)
endif
	
ifneq ($(IB),1)
  clean: clean-targets
	$(call Build/Clean)
else
  clean:
endif

compile-targets:
install-targets:
clean-targets:
patch:
	$(call Build/Patch)
endef


