# Use the default kernel version if the Makefile doesn't override it

ifeq ($(LINUX_VERSION),)
  ifeq ($(KERNEL),2.4)
    LINUX_VERSION:=2.4.34
    LINUX_RELEASE:=1
    LINUX_KERNEL_MD5SUM:=f59665540a7f3351ea416a0dad104b55
  else
    ifeq ($(CONFIG_LINUX_2_6_21),y)
      LINUX_VERSION:=2.6.21.1
      LINUX_RELEASE:=1
      LINUX_KERNEL_MD5SUM:=a28b78793cd368592f7873bf36cb38b0
    endif 
    ifeq ($(CONFIG_LINUX_2_6_33),y)
      LINUX_VERSION:=2.6.33.5
      LINUX_RELEASE:=1
      LINUX_KERNEL_MD5SUM:=4ca73d59b9bdb8f8c30527b17676364d
    endif 
  endif
endif

# disable the md5sum check for unknown kernel versions
LINUX_KERNEL_MD5SUM?=x

KERNEL?=2.$(word 2,$(subst ., ,$(strip $(LINUX_VERSION))))
KERNEL_PATCHVER=$(shell echo '$(LINUX_VERSION)' | cut -d. -f1,2,3 | cut -d- -f1)

