#!/bin/sh

do_check_dnsmasq(){
	#check if dnsmasq crash, restart it 
	ps aux |grep -v "grep dnsmasq" |grep "dnsmasq" >/dev/null 2>/dev/null
	if [ "$?" != "0" ] ;then
		/etc/init.d/dnsmasq restart &
	fi
}

### check VPN mail alert
pid_mailtest=`ps | grep mailtest | grep -q -v grep && echo 1 || echo 0`
if [ "$pid_mailtest" == "0" ]; then
	/etc/mailtest.sh vpn_send &
fi

### kill old state pppd that blocks new pptp connection dialup
[ -d /tmp/pptp_l2l_pid ] && {
		for name_pid in $(ls /tmp/pptp_l2l_pid/* 2>&-); do (
			pname=$(cat $name_pid | awk '{print $1}')
			[ -f /tmp/status_PPTP_data/$pname ] && continue # the old state pppd can dialup new connection, skip ...
			[ -f $name_pid ] &&  /etc/init.d/pptp_l2l_dout tunnel_restart $(cat $name_pid)
		); done
		rm -rf /tmp/pptp_l2l_pid
}

#restart klogd if it disappear
ps | grep "klogd -c1" | grep -v grep >/dev/null 2>/dev/null
[ "$?" = 0 ] || klogd -c1

#restart dnsmasq if it disappear
do_check_dnsmasq

#restart syslogd if logger is stuck
en_syslog=$(uci -q get syslogd.syslogd.status)
if [ "$en_syslog" != "disable" ]; then
	LOGGER_MAX_CNT=10
	cnt_log=$(ps | grep logger | grep -v grep -c)
	[ $cnt_log -ge $LOGGER_MAX_CNT ] && {
		logger "logger_syslog_test" &
		sleep 2
		cnt_log=$(ps | grep "logger_syslog_test" | grep -v grep -c)
		[ "$cnt_log" == "0" ] || {
			echo "Find logger stuck. Do syslogd restart!" > /dev/console
			/etc/init.d/syslog restart
		}
	}

	#restart syslogd if it disappear
	ps | grep "syslogd" | grep -v grep >/dev/null 2>/dev/null
	[ "$?" = 0 ] || {
		echo "Can't not find syslogd. Do syslogd restart!" > /dev/console
		/etc/init.d/syslog restart
	}
fi

#restart lighttpd if disappeared
chk_http=$(ps | grep "lighttpd -f" | grep -v grep -c)
[ "$chk_http" = "0" ] && /etc/init.d/lighttpd restart

