#!/bin/sh

interface=$1
output=$2
if [ "$output" == "json" ]; then
	exit 1
fi
if [ "$interface" == "" ]; then
	echo wan or lan
	exit 1
fi

eval `json -f /var/status_system_interface load network`

intf_list=$(json -f /var/status_system_interface show network | grep "physical=$interface" | cut -d'.' -f 2)
for elem in $intf_list;do
	eval intf_ip_addr=\${network_${elem}_static_ipaddr}
	eval intf_mac_addr=\${network_${elem}_macaddr}
	eval intf_route_ipaddr=\${network_${elem}_gateway}
	eval intf_dns=\${network_${elem}_dns_server}
	eval intf_total_time=\${network_${elem}_total_time}
	eval intf_connection=\${network_${elem}_connection}
	eval intf_proto=\${network_${elem}_proto}
	eval intf_ifname=\${network_${elem}_ifname}
	eval intf_physical=\${network_${elem}_physical}
	eval intf_tx_packets=\${network_${elem}_tx_packets}
	eval intf_rx_packets=\${network_${elem}_rx_packets}
	eval intf_tx_bytes=\${network_${elem}_tx_bytes}
	eval intf_rx_bytes=\${network_${elem}_rx_bytes}
	eval intf_proto6=\${network_${elem}_proto6}
	eval intf_ip6addr=\${network_${elem}_ip6addr}
	eval intf_ip6linkip=\${network_${elem}_ip6linkip}
	eval intf_dns6=\${network_${elem}_dns6}
	eval intf_gateway6=\${network_${elem}_gateway6}

	echo
	echo "Profile            : "$elem
	echo "Connection         : "$intf_connection
	echo "Uptime             : "$intf_total_time "sec"
	echo "MAC address        : "$intf_mac_addr
	echo "IPv4 protocol      : "$intf_proto
	echo "IPv4 address       : "$intf_ip_addr
	echo "IPv4 Gateway       : "$intf_route_ipaddr
	[ "$intf_physical" = "wan" ] && \
	echo "IPv4 DNS           : "$intf_dns
	echo "IPv6 protocol      : "$intf_proto6
	echo "IPv6 address       : "$intf_ip6addr
	echo "Link-local address : "$intf_ip6linkip
	[ "$intf_physical" = "wan" ] && \
	echo "IPv6 gateway       : "$intf_gateway6
	[ "$intf_physical" = "wan" ] && \
	echo "IPv6 DNS           : "$intf_dns6
	echo "Received           : "$intf_rx_packets "packets ("$intf_rx_bytes" bytes)"
	echo "Transmitted        : "$intf_tx_packets "packets ("$intf_tx_bytes" bytes)"
	echo
done
