#!/bin/ash
interface=$1
output=$2
model=$(head -n 1 /etc/version)
switch_model=$(/sbin/mtd fw_printenv 1|grep switch_model|awk -F = '{print $2}')
model_v3900() {
	echo STATUS >  /tmp/ss
	echo $interface >>  /tmp/ss
	
	if [ "$output" = "json" ]; then
		echo true >>  /tmp/ss
		cat /tmp/ss > /proc/rtk8366
		status=$(cat /proc/rtk8366) 
	else
		echo false >>  /tmp/ss
		cat /tmp/ss > /proc/rtk8366
		cat /proc/rtk8366
	fi
	
	if [ "$output" = "json" ]; then
	SFP_DEC=$(echo $(mmiotool -r 0x28000000)| awk -F ": " '{print $2}'|cut -c 1-3) ##fiber SFP detection
	  if [ "$interface" = "lan" ]; then
	   dec=$((($SFP_DEC&0x4)>>2))	  	   
      else
       dec=$((($SFP_DEC&0x8)>>3))	   
      fi 	   
		for g_status in $status;do
			rt=$(echo $g_status  | awk -F. ' { print $1 " " $2 " " $3 " " $4}')
			set -- $rt
			port=$1
			 [ "$interface" = "lan" -a "$port" = "LAN1" ] && {
			  port="LAN_Port_1"
			 } 
			 [ "$interface" = "lan" -a "$port" = "LAN2" ] && {
			  port="LAN_Port_2"
			 } 
			 [ "$interface" = "lan" -a "$port" = "LAN3" ] && {
			  port="LAN_SFP"
			 } 
            if [ "$interface" = "lan" -a "$port" = "LAN_SFP" -a "$dec" -eq "1" ]; then
             link="Down(SFP module disconnected)"
            elif [ "$interface" = "wan" -a "$port" = "WAN5" -a "$dec" -eq "1" ]; then 			
			 link="Down(SFP module disconnected)"
			else
             link=$2
			 if [ "$port" = "WAN5" -a "$link" = "Down" ]; then
			  link="Down(SFP module connected)"
			 elif [ "$port" = "LAN_SFP" -a "$link" = "Down" ]; then
			  link="Down(SFP module connected)"
			 else
			  link=$2
			 fi 
            fi
			speed=$3
			duplex=$4
			
			if [ "$link" = "Up" ];then			
			    json -f /var/status_switch set "switch_${interface}.${port}"  \
				  link="$link" speed="$speed" duplex="$duplex"
			else
           		json -f /var/status_switch set "switch_${interface}.${port}"  \
				  link="$link" speed="" duplex=""
            fi				
		done
	fi
}

model_v2960() {
	/sbin/switch_queue_sender STATUS $(echo $interface | tr [a-z] [A-Z])
	if [ "$output" = "json" ]; then	   
        for n in 1 2 3 4; do	     
	        if [ "$n" -eq "1" ]; then 
             #port=$(cat /var/ar8327_switch_status |sed -n '"$i"p'|awk -F : '{print $2}')	
		     #link=$(cat /var/ar8327_switch_status |sed -n '"$(($i+1))"p'|awk -F : '{print $2}')
             #speed=$(cat /var/ar8327_switch_status |sed -n '"$(($i+2))"p'|awk -F : '{print $2}')	
             #duplex=$(cat /var/ar8327_switch_status |sed -n '"$(($i+3))"p'|awk -F : '{print $2}') 
		     port=$(cat /var/ar8327_switch_status |sed -n '2p'|awk -F : '{print $2}')
              if [ "$interface" = "lan" ]; then
               port="LAN_Port_1"
              fi			 
		     link=$(cat /var/ar8327_switch_status |sed -n '3p'|awk -F : '{print $2}')
             speed=$(cat /var/ar8327_switch_status |sed -n '4p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '5p'|awk -F : '{print $2}') 
		    elif [ "$n" -eq "2" ]; then
             port=$(cat /var/ar8327_switch_status |sed -n '8p'|awk -F : '{print $2}')
              if [ "$interface" = "lan" ]; then
               port="LAN_Port_2"
              fi			 
		     link=$(cat /var/ar8327_switch_status |sed -n '9p'|awk -F : '{print $2}')
             speed=$(cat /var/ar8327_switch_status |sed -n '10p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '11p'|awk -F : '{print $2}')
		    elif [ "$n" -eq "3" ]; then
             port=$(cat /var/ar8327_switch_status |sed -n '14p'|awk -F : '{print $2}')	
			  if [ "$interface" = "lan" ]; then
               port="LAN_Port_3"
              fi	
		     link=$(cat /var/ar8327_switch_status |sed -n '15p'|awk -F : '{print $2}') 
             speed=$(cat /var/ar8327_switch_status |sed -n '16p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '17p'|awk -F : '{print $2}') 		    
		    else
             port=$(cat /var/ar8327_switch_status |sed -n '20p'|awk -F : '{print $2}')	
              if [ "$interface" = "lan" ]; then
               port="LAN_Port_4"
              fi			 
		     link=$(cat /var/ar8327_switch_status |sed -n '21p'|awk -F : '{print $2}')				   
             speed=$(cat /var/ar8327_switch_status |sed -n '22p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '23p'|awk -F : '{print $2}') 
		    fi 
         	if [ "$link" = " Up" ];then			
			    json -f /var/status_switch set "switch_${interface}.${port}"  \
				  link="$link" speed="$speed" duplex="$duplex"
			else
           		json -f /var/status_switch set "switch_${interface}.${port}"  \
				  link="$link" speed="" duplex=""
            fi				  
	    done	  	
	else
	   
	    [ "$interface" = "lan" -o "$interface" = "wan" ] && cat /var/ar8327_switch_status
	fi	
}
model_v300B() {
	/sbin/switch_queue_sender STATUS $(echo $interface | tr [a-z] [A-Z])
	if [ "$output" = "json" ]; then	   
        for n in 1 2 3 4; do	     
	        if [ "$n" -eq "1" ]; then 
             #port=$(cat /var/ar8327_switch_status |sed -n '"$i"p'|awk -F : '{print $2}')	
		     #link=$(cat /var/ar8327_switch_status |sed -n '"$(($i+1))"p'|awk -F : '{print $2}')
             #speed=$(cat /var/ar8327_switch_status |sed -n '"$(($i+2))"p'|awk -F : '{print $2}')	
             #duplex=$(cat /var/ar8327_switch_status |sed -n '"$(($i+3))"p'|awk -F : '{print $2}') 
		     port=$(cat /var/ar8327_switch_status |sed -n '2p'|awk -F : '{print $2}')
              if [ "$interface" = "lan" ]; then
               port="LAN_Port_1"
              fi		 
		     link=$(cat /var/ar8327_switch_status |sed -n '3p'|awk -F : '{print $2}')
             speed=$(cat /var/ar8327_switch_status |sed -n '4p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '5p'|awk -F : '{print $2}') 
		    elif [ "$n" -eq "2" ]; then
             port=$(cat /var/ar8327_switch_status |sed -n '8p'|awk -F : '{print $2}')
              if [ "$interface" = "lan" ]; then
               port="LAN_Port_2"
              fi			 
		     link=$(cat /var/ar8327_switch_status |sed -n '9p'|awk -F : '{print $2}')
             speed=$(cat /var/ar8327_switch_status |sed -n '10p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '11p'|awk -F : '{print $2}')
		    elif [ "$n" -eq "3" ]; then
             port=$(cat /var/ar8327_switch_status |sed -n '14p'|awk -F : '{print $2}')	
		     link=$(cat /var/ar8327_switch_status |sed -n '15p'|awk -F : '{print $2}') 
             speed=$(cat /var/ar8327_switch_status |sed -n '16p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '17p'|awk -F : '{print $2}') 		    
		    else
             port=$(cat /var/ar8327_switch_status |sed -n '20p'|awk -F : '{print $2}')			     		        
		     link=$(cat /var/ar8327_switch_status |sed -n '21p'|awk -F : '{print $2}')				   
             speed=$(cat /var/ar8327_switch_status |sed -n '22p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '23p'|awk -F : '{print $2}') 
		    fi 
         				
			if [ "$link" = " Up" ];then			
			    json -f /var/status_switch set "switch_${interface}.${port}"  \
				  link="$link" speed="$speed" duplex="$duplex"
			else
           		json -f /var/status_switch set "switch_${interface}.${port}"  \
				  link="$link" speed="" duplex=""
            fi			
	    done	  	
	else
	    
	    [ "$interface" = "lan" -o "$interface" = "wan" ] && cat /var/ar8327_switch_status
	fi	
}
model_atheros_v3900() {    
	/sbin/switch_queue_sender STATUS $(echo $interface | tr [a-z] [A-Z])
		
	if [ "$output" = "json" ]; then
	  SFP_DEC=$(echo $(mmiotool -r 0x28000000)| awk -F ": " '{print $2}'|cut -c 1-3) ##fiber SFP detection
	  if [ "$interface" = "lan" ]; then
	   dec=$((($SFP_DEC&0x4)>>2))	  	   
      else
       dec=$((($SFP_DEC&0x8)>>3))	   
      fi 	   
        for n in 1 2 3 4 5; do
	     
	        if [ "$n" -eq "1" ]; then 
             #port=$(cat /var/ar8327_switch_status |sed -n '"$i"p'|awk -F : '{print $2}')	
		     #link=$(cat /var/ar8327_switch_status |sed -n '"$(($i+1))"p'|awk -F : '{print $2}')
             #speed=$(cat /var/ar8327_switch_status |sed -n '"$(($i+2))"p'|awk -F : '{print $2}')	
             #duplex=$(cat /var/ar8327_switch_status |sed -n '"$(($i+3))"p'|awk -F : '{print $2}') 
		     port=$(cat /var/ar8327_switch_status |sed -n '2p'|awk -F : '{print $2}')
      		  if [ "$interface" = "lan" ]; then
               port="LAN_Port_1"
              fi			 
		     link=$(cat /var/ar8327_switch_status |sed -n '3p'|awk -F : '{print $2}')
             speed=$(cat /var/ar8327_switch_status |sed -n '4p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '5p'|awk -F : '{print $2}') 
		    elif [ "$n" -eq "2" ]; then
             port=$(cat /var/ar8327_switch_status |sed -n '8p'|awk -F : '{print $2}')
              if [ "$interface" = "lan" ]; then
               port="LAN_Port_2"
              fi			 
		     link=$(cat /var/ar8327_switch_status |sed -n '9p'|awk -F : '{print $2}')
             speed=$(cat /var/ar8327_switch_status |sed -n '10p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '11p'|awk -F : '{print $2}')
		    elif [ "$n" -eq "3" ]; then
             port=$(cat /var/ar8327_switch_status |sed -n '14p'|awk -F : '{print $2}')	
			    if [ "$interface" = "lan" ]; then
                 port="LAN_SFP"
                fi	
		        if [ "$interface" = "lan" -a "$dec" -eq "1" ]; then
                 link="Down(SFP module disconnected)"			      
		        else	 
		         link=$(cat /var/ar8327_switch_status |sed -n '15p'|awk -F : '{print $2}')
				  if [ "$interface" = "lan" -a $link = "Down" ];then
				  link="Down(SFP module connected)"
				  fi
				  
		        fi 	 
             speed=$(cat /var/ar8327_switch_status |sed -n '16p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '17p'|awk -F : '{print $2}') 
		    elif [ "$n" -eq "4" ]; then
             port=$(cat /var/ar8327_switch_status |sed -n '20p'|awk -F : '{print $2}')	
		     link=$(cat /var/ar8327_switch_status |sed -n '21p'|awk -F : '{print $2}')
             speed=$(cat /var/ar8327_switch_status |sed -n '22p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '23p'|awk -F : '{print $2}') 
		    else
             port=$(cat /var/ar8327_switch_status |sed -n '26p'|awk -F : '{print $2}')	
		     
		        if [ "$interface" = "wan" -a "$dec" -eq "1" ]; then 
		         link="Down(SFP module disconnected)"			     
		        else
		         link=$(cat /var/ar8327_switch_status |sed -n '27p'|awk -F : '{print $2}')
				   if [ $link = "Down" ];then
				   link="Down(SFP module connected)"
				   fi
                fi	
             speed=$(cat /var/ar8327_switch_status |sed -n '28p'|awk -F : '{print $2}'|tr 'm' 'M')	
             duplex=$(cat /var/ar8327_switch_status |sed -n '29p'|awk -F : '{print $2}') 
		    fi 
         				
			if [ "$link" = " Up" ];then			
			    json -f /var/status_switch set "switch_${interface}.${port}"  \
				  link="$link" speed="$speed" duplex="$duplex"
			else
           		json -f /var/status_switch set "switch_${interface}.${port}"  \
				  link="$link" speed="" duplex=""
            fi				
	    done
	else
		  
	   [ "$interface" = "lan" -o "$interface" = "wan" ] && cat /var/ar8327_switch_status
	     
	fi	
	
}

if [ "$interface" == "" ]; then
	echo wan or lan
	exit 1
fi



if [ "$model" = "Vigor2960" -o "$model" = "Vigor2960F" ];then
    model_v2960
elif [ "$model" = "Vigor300B" ];then
    model_v300B	
elif [ "$model" = "Vigor3900" -a "$switch_model" -eq "1" ];then
     model_atheros_v3900
else
    model_v3900
fi	
