#!/bin/sh
# Copyright (C) 2006 OpenWrt.org

# DEBUG="echo"

find_config() {
	local iftype device iface ifaces ifn
	for ifn in $interfaces; do
		config_get iftype "$ifn" type
		config_get iface "$ifn" ifname
		case "$iftype" in
			bridge)
			         delbr=`uci get bridge.general.del$ifn`
#			         echo "delbr=$delbr" >>/testbr
			         config_get ifaces "$ifn" ifnames ;;
		esac
		config_get device "$ifn" device
		for ifc in $device $iface $ifaces; do
			[ "$ifc" = "$1" ] && {
			     if [ -z "$delbr" ] ; then
#                                echo "returning 0 ifc=$ifc 1=$1" >>/testbr
				echo "$ifn"
				return 0
			     fi
			}
		done
	done

	return 1;
}

scan_interfaces() {
	local cfgfile="$1"
	local mode iftype iface ifname device
	interfaces=
	config_cb() {
		case "$1" in
			interface)
				config_set "$2" auto 1
			;;
		esac
		config_get iftype "$CONFIG_SECTION" TYPE
		case "$iftype" in
			interface)
				config_get proto "$CONFIG_SECTION" proto
				append interfaces "$CONFIG_SECTION"
				config_get iftype "$CONFIG_SECTION" type
				config_get ifname "$CONFIG_SECTION" ifname
				config_set "$CONFIG_SECTION" device "$ifname"
				case "$iftype" in
					bridge)
						config_set "$CONFIG_SECTION" ifnames "$ifname"
						config_set "$CONFIG_SECTION" ifname "$CONFIG_SECTION"
					;;
				esac
				( type "scan_$proto" ) >/dev/null 2>/dev/null && eval "scan_$proto '$CONFIG_SECTION'"
			;;
		esac
	}
	config_load "${cfgfile:-network}"
}

add_vlan() {
	local ifname="$1"
	local config="$2"

	[ "$config" = "usb1" -o "$config" = "usb2" ] && return

	ifconfig "$ifname" >/dev/null 2>/dev/null || {
		config_get physical $config physical
		config_get vlan_id $config vlan_id
		$DEBUG vconfig add "$physical" "$vlan_id"
		$DEBUG json set network.$config vlan_id="$vlan_id"
	}
}

# Create the interface, if necessary.
# Return status 0 indicates that the setup_interface() call should continue
# Return status 1 means that everything is set up already.

prepare_interface() {
	local iface="$1"
	local config="$2"

	# if we're called for the bridge interface itself, don't bother trying
	# to create any interfaces here. The scripts have already done that, otherwise
	# the bridge interface wouldn't exist.
	[ "$iface" = "$config" ] && return 0;

	[ -e "$iface" ] && return 0;

	ifconfig "$iface" 2>/dev/null >/dev/null && {
		# make sure the interface is removed from any existing bridge and brought down
		ifconfig "$iface" down
		unbridge "$iface"
	}

	# Setup VLAN interfaces
	add_vlan "$iface" "$config"
	ifconfig "$iface" 2>/dev/null >/dev/null || return 0

	# Setup bridging
	config_get iftype "$config" type
	case "$iftype" in
		bridge)
			[ -x /usr/sbin/brctl ] && {
				ifconfig "$iface" 0.0.0.0 up 2>/dev/null >/dev/null
				ifconfig "$config" 2>/dev/null >/dev/null && {
					$DEBUG brctl addif "$config" "$iface"
					# Bridge existed already. No further processing necesary
				} || {
					$DEBUG brctl addbr "$config"
					$DEBUG brctl setfd "$config" 0
					$DEBUG brctl addif "$config" "$iface"
					# Creating the bridge here will have triggered a hotplug event, which will
					# result in another setup_interface() call, so we simply stop processing
					# the current event at this point.
				}
				config_get mac "$config" mac
				ifconfig "$config" hw ether "$mac" 2>/dev/null >/dev/null
				return 1
			}
		;;
	esac
	return 0
}

setup_interface() {
	local iface="$1"
	local config="$2"
	local proto
	local macaddr
	local rt_table_id
	local mode

	[ -n "$config" ] || {
		config=$(find_config "$iface")
		[ "$?" = 0 ] || return 1
	}
	proto="${3:-$(config_get "$config" proto)}"

	prepare_interface "$iface" "$config" || return 0

	[ "$iface" = "$config" ] && {
		# need to bring up the bridge and wait a second for
		# it to switch to the 'forwarding' state, otherwise
		# it will lose its routes...
		ifconfig "$iface" up
		sleep 1
	}

	mode=
	config_get physical "$config" physical
	config_get des "$config" description
	if   [ "$physical" = "eth2" -o "$physical" = "usb" ]; then
		physical="wan"
		ifname=wan-$config
	else
		physical="lan"
		ifname=lan-$config
		config_get mode "$config" mode
	fi

	# Interface settings
	config_get default_mac "$config" default_mac
	config_get macaddr "$config" macaddr
	[ "$default_mac" = "disable" -a "$physical" = "wan" ] && /usr/bin/lut_config add "$physical" "cpu" "$macaddr" >/dev/null 2>/dev/null
	[ "$macaddr" = "default" ] && macaddr=""
	[ "$proto" = "3g" ] || $DEBUG ifconfig "$iface" ${macaddr:+hw ether "$macaddr"} up

	config_get proto1 "$config" proto
	if   [ "$proto1" = "$proto" ]; then
		is_server_gw=0

        ### add nat with wan interface, 20100331
        config_get mode "$config" mode
        if [ "$physical" = "wan" ]; then
            if [ "$mode" = "ROUTING" ]; then
                iptables -t mangle -I BLOCKDIRECTNAT 1 -i $ifname -j ACCEPT 2>/dev/null
            else
                iptables -t nat -A nat_post_route -o $ifname -m mset2 --set2 lan_nat_subnet src --set2 exception_subnet_set src -j MASQUERADE
                [ "$proto" = "pptp" ] && iptables -t nat -A nat_post_route -m mset2 --set2 lan_nat_subnet src --set2 exception_subnet_set src  -o $iface -j MASQUERADE
            fi
        fi
        ###

		##### ian.20100521 add iptables TCPMSS rule
		config_get mtu "$config" ${proto}_mtu
		[ "$physical" = "wan" -a -n "$mtu" ] && {
			tcpmss=$(($mtu-40))
			#20101129, modify for excluding vpn
			#$DEBUG /usr/sbin/iptables -t mangle -A WAN_TCPMSS -p tcp --tcp-flags SYN,RST SYN -o $ifname -j TCPMSS --set-mss $tcpmss
			$DEBUG /usr/sbin/iptables -t mangle -A WAN_TCPMSS -p tcp --tcp-flags SYN,RST SYN -o $ifname -m mset ! --set exception_subnet_set dst -m mset ! --set exception_subnet_gre_set dst  -j TCPMSS --set-mss $tcpmss

			#20110113, fix G29771, packet from wan
			$DEBUG /usr/sbin/iptables -t mangle -A TCPMSS_FORWARD -p tcp --tcp-flags SYN,RST SYN -i $ifname -m mset ! --set exception_subnet_set src -m mset ! --set exception_subnet_gre_set src -j TCPMSS --set-mss $tcpmss
		}

		##### ian.20101117 create ipset
		[ "$physical" = "wan" ] && {
			/usr/sbin/ipset -N ipalias_$config iphash 2>/dev/null
			/usr/sbin/ipset -A all_interface  ipalias_$config 2>/dev/null
			/usr/sbin/ipset -N ip_$config iphash 2>/dev/null
		}
		[ "$physical" = "lan" ] && {
			/usr/sbin/ipset -N ip_$config iphash 2>/dev/null
			/usr/sbin/ipset -A all_interface_lan  ip_$config 2>/dev/null
		}
		[ "$proto" = "3g" ] || {
			[ -z "$macaddr" ] && macaddr=`ifconfig "$iface" | head -n 1 | awk '{print $5}'`
		}
		$DEBUG json set network.$config physical=$physical ifname=$ifname proto=$proto${mode:+($mode)} macaddr=$macaddr tcpmss=$tcpmss connection="down" uptime="0" server_gw="" over_ifname="" over_dns="" ipaddr="" netmask="" gateway="" dns="" ip_alias="" 2nd_subnet="" des="$des"
	else
		is_server_gw=1
	fi

	case "$proto" in
		static)
			#tr069
			uci set network.$config.ip_status=enable
			uci set network.$config.ppp_status=disable
			config_get ipaddr "$config" static_ipaddr
			config_get netmask "$config" static_netmask
			[ -z "$ipaddr" -o -z "$netmask" ] && return 1

			$DEBUG ifconfig "$iface" "$ipaddr" netmask "$netmask"

			#config_get bcast "$config" static_broadcast
			#[ -z "$bcast" -o "$bcast" = "0.0.0.0" ] || $DEBUG ifconfig "$iface" broadcast "$bcast"

			config_get gateway "$config" static_gateway
			config_get dns "$config" static_dns
			##### remove old dns record
			sed -i "/#$iface$/d" /tmp/resolv.conf.auto 2> /dev/null

			if   [ "$is_server_gw" = "1" ]; then
				$DEBUG json set network.$config server_gw=$gateway over_ifname=$iface
				[ -z "$dns" ] || {
					for ns in $dns; do
						echo "nameserver $ns #$iface" >> /tmp/resolv.conf.auto
						$DEBUG json set network.$config over_dns=",$ns"
						$DEBUG ip route add $ns via $gateway dev $iface
					done
				}
			else
				$DEBUG json set network.$config ipaddr=$ipaddr netmask=$netmask
				[ "$physical" = "wan" ] &&  {
					$DEBUG /usr/sbin/ipset -A ipalias_$config $ipaddr 
					$DEBUG /usr/sbin/ipset -A ip_$config $ipaddr 
					#/etc/init.d/addr_map restart >/dev/null 2>/dev/null
				}
				[ "$physical" = "lan" ] && $DEBUG /usr/sbin/ipset -A ip_$config $ipaddr
				config_get ip_alias "$config" static_ip_alias

				##### ian.20100324 change to uniform ifname
				$DEBUG /usr/sbin/ip link set $iface down
				$DEBUG /usr/sbin/ip link set $iface name $ifname
				$DEBUG /usr/sbin/ip link set $ifname up

				##### ian.20100521 add iptables TCPMSS rule
				[ -n "$mtu" ] && {
					$DEBUG /usr/sbin/ip link set $ifname mtu $mtu
				}

				rt_table_id=
				[ -z "$gateway" -o "$gateway" = "0.0.0.0" ] || {
					rt_table_id=`get_route_table_id $config`

					$DEBUG iptables -t mangle -A OUTPUT_WAN -s $ipaddr/$netmask -j MARK --set-mark $rt_table_id
					local NETWORK PREFIX
					eval `ipcalc -np "$ipaddr" "$netmask"`
					$DEBUG ip route add $NETWORK/$PREFIX dev $ifname table $rt_table_id
					$DEBUG ip route replace default via "$gateway" dev $ifname table $rt_table_id
					[ "$physical" = "wan" ] && $DEBUG ip rule add pref $((33267+$rt_table_id)) from $ipaddr/$netmask table $rt_table_id
					$DEBUG json set network.$config gateway=$gateway
				}

				##### ian.20100202 add ip alias
				[ -n "$ip_alias" ] && {
					for ip2 in $ip_alias; do
						$DEBUG ip addr add $ip2 dev $ifname brd + 2>/dev/null
						$DEBUG /usr/sbin/ipset -A ipalias_$config ${ip2%/*}
						$DEBUG json set network.$config ip_alias=",$ip2"
						[ -z "$rt_table_id" ] || {
							$DEBUG iptables -t mangle -A OUTPUT_WAN -s $ip2 -j MARK --set-mark $rt_table_id
							echo $ip2 | grep "/" >/dev/null || continue
							local NETWORK PREFIX
							eval `ipcalc -np $ip2`
							$DEBUG ip route add $NETWORK/$PREFIX dev $ifname table $rt_table_id 2>/dev/null
						}
					done
				}

				[ -z "$dns" ] || {
					for ns in $dns; do
						echo "nameserver $ns #$config" >> /tmp/resolv.conf.auto
						$DEBUG json set network.$config dns=",$ns"
					done
				}

				[ "$physical" = "lan" ] && {
					ipset -N lan_${config}_subnet iptreemap
					if   [ "$mode" = "NAT" ]; then
						ipset -A lan_nat_subnet $ipaddr/$netmask
						ipset -A lan_${config}_subnet $ipaddr/$netmask
					elif [ "$mode" = "ROUTING" ]; then
						ipset -A lan_routing_subnet $ipaddr/$netmask
					fi
					
					#T17124:Do not append extra subnet before checking HA status and state
					newver_ha_status=`uci get ucarp_mode.general.status`
					#echo "config.sh:newver_ha_status=$newver_ha_status" >/dev/console
					if [ -z "$newver_ha_status" ] ;then
						ha_status=`uci get ucarp.general.status`
					else
						ha_status="$newver_ha_status"
					fi
					if [ "$ha_status" = "disable" -o -z "$ha_status" ] ;then
						second_subnet=`uci get -d, network.$config.static_2nd_subnet`
						echo $second_subnet | grep , >/dev/null
						do_loop=$?
						i=0
						while true; do
							i=$(($i+1))
							set -- `echo $second_subnet | cut -d, -f $i`
							if   [ "$3" = "NAT" ]; then
								ipset -A lan_nat_subnet $1/$2
								ipset -A lan_${config}_subnet $1/$2
								/usr/sbin/ipset -A ip_$config $1
							elif [ "$3" = "ROUTING" ]; then
								ipset -A lan_routing_subnet $1/$2
								/usr/sbin/ipset -A ip_$config $1
							else [ -z "$3" ]
								break
							fi
							ip addr add $1/$2 dev $ifname brd +
							json set network.$config 2nd_subnet=",$1/$2($3)"
							[ "$do_loop" -eq 0 ] || break
						done
					elif [ "$ha_status" = "enable" ] ;then
						ha_state=`json get ucarp.state`
						echo "config.sh: $config:Found HA Status=Enable" >/dev/console
						if [ "$ha_state" = "master" ] ;then
							#echo "config.sh:Found My HA State=Master, add extra subnet!" >/dev/console
							second_subnet=`uci get -d, network.$config.static_2nd_subnet`
							echo $second_subnet | grep , >/dev/null
							do_loop=$?
							i=0
							while true; do
								i=$(($i+1))
								set -- `echo $second_subnet | cut -d, -f $i`
								if   [ "$3" = "NAT" ]; then
									ipset -A lan_nat_subnet $1/$2
									ipset -A lan_${config}_subnet $1/$2
								elif [ "$3" = "ROUTING" ]; then
									ipset -A lan_routing_subnet $1/$2
								else [ -z "$3" ]
									break
								fi
								ip addr add $1/$2 dev $ifname brd +
								json set network.$config 2nd_subnet=",$1/$2($3)"
								[ "$do_loop" -eq 0 ] || break
							done
						else
							#echo "config.sh:My HA State is not Master or Unknown, do not handle LAN extra subnet now" >/dev/console
							dummy=
						fi
					fi

					iptables -t mangle -I LANROUTE -i $ifname -m mset --set lan_${config}_subnet src --set lan_${config}_subnet dst -j RETURN 2>/dev/null
					iptables -t mangle -I LANROUTE -i $ifname -m mset --set lan_routing_subnet src --set lan_routing_subnet dst -j RETURN 2>/dev/null
				}

				config_get cd_mode $config static_cd_mode
				[ "$physical" = "lan" -o -z "$cd_mode" -o "$cd_mode" = "none" ] && \
					env -i ACTION="ifup" INTERFACE="$config" DEVICE="$ifname" PROTO=static /sbin/hotplug-call "iface" &
			fi
		;;
		dmz)
			config_get mode "$config" dmz_mode
			config_get host_ip_list "$config" dmz_host_ip_list
			if [ "$mode" = "nat" ]; then				
				config_get ipaddr "$config" dmz_ipaddr
				config_get netmask "$config" dmz_netmask
				[ -z "$ipaddr" -o -z "$netmask" ] && return 1

				$DEBUG ifconfig "$iface" "$ipaddr" netmask "$netmask"
			
				#sed -i "/#$iface$/d" /tmp/resolv.conf.auto 2> /dev/null
			
				$DEBUG json set network.$config ipaddr=$ipaddr netmask=$netmask
				#[ "$physical" = "wan" ] &&  {
				#	$DEBUG /usr/sbin/ipset -A ipalias_$config $ipaddr 
				#	$DEBUG /usr/sbin/ipset -A ip_$config $ipaddr 
				#	/etc/init.d/addr_map restart >/dev/null 2>/dev/null
				#}
				#[ "$physical" = "lan" ] && $DEBUG /usr/sbin/ipset -A ip_$config $ipaddr
				#config_get ip_alias "$config" static_ip_alias
			
				$DEBUG /usr/sbin/ip link set $iface down
				$DEBUG /usr/sbin/ip link set $iface name $ifname
				$DEBUG /usr/sbin/ip link set $ifname up

				[ -n "$mtu" ] && {
					$DEBUG /usr/sbin/ip link set $ifname mtu $mtu
				}
			
				config_get cd_mode $config static_cd_mode
				[ "$physical" = "wan" -o -z "$cd_mode" -o "$cd_mode" = "none" ] && \
					env -i ACTION="ifup" INTERFACE="$config" DEVICE="$ifname" PROTO=dmz /sbin/hotplug-call "iface" &
						
			else
				
				#sed -i "/#$iface$/d" /tmp/resolv.conf.auto 2> /dev/null
			
				#[ "$physical" = "wan" ] &&  {
				#	$DEBUG /usr/sbin/ipset -A ipalias_$config $ipaddr 
				#	$DEBUG /usr/sbin/ipset -A ip_$config $ipaddr 
				#	/etc/init.d/addr_map restart >/dev/null 2>/dev/null
				#}
				#[ "$physical" = "lan" ] && $DEBUG /usr/sbin/ipset -A ip_$config $ipaddr
				#config_get ip_alias "$config" static_ip_alias

				$DEBUG /usr/sbin/ip link set $iface down
				$DEBUG /usr/sbin/ip link set $iface name $ifname
				$DEBUG /usr/sbin/ip link set $ifname up
				
				[ -n "$mtu" ] && {
					$DEBUG /usr/sbin/ip link set $ifname mtu $mtu
				}
				
				config_get cd_mode $config static_cd_mode
				[ "$physical" = "wan" -o -z "$cd_mode" -o "$cd_mode" = "none" ] && \
					env -i ACTION="ifup" INTERFACE="$config" DEVICE="$ifname" PROTO=dmz /sbin/hotplug-call "iface" &
				
			fi
		;;
		dhcp)
			#tr069
			uci set network.$config.ip_status=enable
			uci set network.$config.ppp_status=disable	
			pidfile="/var/run/dhcp-$config.pid"
			# prevent udhcpc from starting more than once
			lock "/var/lock/dhcp-$config"
			pid="$(cat "$pidfile" 2>/dev/null)"
			[ -d "/proc/$pid" ] && grep udhcpc "/proc/${pid}/cmdline" >/dev/null 2>/dev/null && {
				lock -u "/var/lock/dhcp-$config"
				return 0
			}

			config_get ipaddr "$config" dhcp_ipaddr
			config_get netmask "$config" dhcp_netmask
			config_get hostname "$config" dhcp_hostname
			#dhcp option 60
			config_get vendor_class_id "$config" dhcp_vendor_class_id
			#dhcp option 61
			config_get client_id "$config" dhcp_client_id
			
			[ "$ipaddr" = "0.0.0.0" ] && unset ipaddr
			[ "$netmask" = "0.0.0.0" ] && unset netmask
			[ -z "$ipaddr" ] || \
				$DEBUG ifconfig "$iface" "$ipaddr" ${netmask:+netmask "$netmask"}

			# don't stay running in background if dhcp is not the main proto on the interface (e.g. when using pptp)
			if   [ "$is_server_gw" = "1" ]; then
				dhcpopts="-n -q"
				echo "$ifname" > /tmp/ifname-$iface
				ifname=$iface
				$DEBUG json set network.$config ifname=$ifname
			else
				##### ian.20100324 change to uniform ifname
				$DEBUG /usr/sbin/ip link set $iface down
				$DEBUG /usr/sbin/ip link set $iface name $ifname
				$DEBUG /usr/sbin/ip link set $ifname up

				##### ian.20100521 add iptables TCPMSS rule
				[ -n "$mtu" ] && {
					$DEBUG /usr/sbin/ip link set $ifname mtu $mtu
				}

				##### ian.20100202 add ip alias
				config_get ip_alias "$config" dhcp_ip_alias
				[ -n "$ip_alias" ] && {
					rt_table_id=`get_route_table_id $config`
					for ip2 in $ip_alias; do
						$DEBUG ip addr add $ip2 dev $ifname brd + 2>/dev/null
						$DEBUG /usr/sbin/ipset -A ipalias_$config ${ip2%/*}
						$DEBUG json set network.$config ip_alias=",$ip2"

						$DEBUG iptables -t mangle -A OUTPUT_WAN -s $ip2 -j MARK --set-mark $rt_table_id
						echo $ip2 >/dev/null | grep "/" || continue
						local NETWORK PREFIX
						eval `ipcalc -np $ip2`
						$DEBUG ip route add $NETWORK/$PREFIX dev $ifname table $rt_table_id 2>/dev/null
					done
				}
			fi
			$DEBUG eval udhcpc -i "$ifname" ${vendor_class_id:+-V $vendor_class_id} ${client_id:+-c $client_id} ${ipaddr:+-r $ipaddr} ${hostname:+-H $hostname} -b -p "$pidfile" ${dhcpopts:- -R &} >/dev/null
			lock -u "/var/lock/dhcp-$config"
		;;
		none)
			return 1
		;;
		*)
			if ( eval "type setup_interface_$proto" ) >/dev/null 2>/dev/null; then
				ucarp_status=`uci get ucarp.general.status`
				ha_role=`uci get ucarp.general.role`
				ucarp_state=`json get ucarp.state`
				[ "$ucarp_status" = "enable" -a "$ha_role" = "backup" -a "$ucarp_state" != "master" ] || {
					/sbin/get_route_table_id $config >/dev/null
					eval "setup_interface_$proto '$iface' '$config' '$proto'" &
				}
			else
				echo "Interface type $proto not supported."
				return 1
			fi
		;;
	esac
}

unbridge() {
	local dev="$1"
	local brdev

	[ -x /usr/sbin/brctl ] || return 0
	brctl show | grep "$dev" >/dev/null && {
		# interface is still part of a bridge, correct that

		for brdev in $(brctl show | awk '$2 ~ /^[0-9].*\./ { print $1 }'); do
			brctl delif "$brdev" "$dev" 2>/dev/null >/dev/null
		done
	}
}
