#!/bin/sh

#####====MAIL/SMS ALERT CODE====#####
#WAN_DIS				1			#
#WAN_CONN				2			#
#VPN_DIS				3			#
#VPN_CONN				4			#
#TEMP					5			#
#####################################

myPath="/tmp/mail_alert/outbox"

if [ ! -x "$myPath" ]; then
	mkdir $myPath -p
	#echo "create folder"
fi

check_MAIL_ALERT_Status () {
	profile_id=$1
	msg_type=$2

	FLAG=$(uci -q get config_notify.$profile_id.wan_dis)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "1" ]; then
		echo 1
		return
	fi

	FLAG=$(uci -q get config_notify.$profile_id.wan_con)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "2" ]; then
		echo 1
		return
	fi

	FLAG=$(uci -q get config_notify.$profile_id.vpn_dis)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "3" ]; then
		echo 1
		return		
	fi

	FLAG=$(uci -q get config_notify.$profile_id.vpn_con)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "4" ]; then
		echo 1
		return
	fi

	FLAG=$(uci -q get config_notify.$profile_id.temper)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "5" ]; then
		echo 1
		return
	fi

	return 0
}

MSG_TYPE=$1
MSG=$2
 
for i in $(seq 1 10)
do
	MAIL_ALERT_PROFILE=$i
	#echo "MAIL_ALERT_PROFILE=$MAIL_ALERT_PROFILE"

	MAIL_ALERT_ENABLE=$(uci -q get config_mail_alert.$i.status)
	#echo "MAIL_ALERT_ENABLE=$MAIL_ALERT_ENABLE"

	if [ "$MAIL_ALERT_ENABLE" != "enable" ]; then
		#echo ">>contiune"
		continue
	fi
	NOTIFY_PROFILE=$(uci -q get config_mail_alert.$i.notify_profile)
	#echo "NOTIFY_PROFILE=$NOTIFY_PROFILE"
	
	NOTIFY_ENABLE=$(check_MAIL_ALERT_Status $NOTIFY_PROFILE $MSG_TYPE)
	#echo "NOTIFY_ENABLE=$NOTIFY_ENABLE"
	
	if [ "$NOTIFY_ENABLE" == "1" ]; then
		MAIL_PROFILE=$(uci -q get config_mail_alert.$i.mail_profile)
		#echo "MAIL_PROFILE=$MAIL_PROFILE"
		#echo "do shell"
		file_time=`date +%Y_%m%d_%H%M%S`
		echo "file_time=$file_time"
		mydir="$myPath/$file_time"
		echo "mydir=$mydir"
		$cat > $mydir

		filetowrite="$MAIL_ALERT_PROFILE##<<##>>##$MSG##<<##>>##$MSG_TYPE"
		echo $filetowrite > $mydir
	fi
done
return 0