#!/bin/sh

profile_id=$1
MSG=$2
MSG_TYPE=$3
#echo "profile_id="$profile_id

MAIL_PROFILE=$(uci -q get config_mail_alert.$profile_id.mail_profile)
NOTIFY_PROFILE=$(uci -q get config_mail_alert.$profile_id.notify_profile)

routername=$(uci get syslogd.syslogd.routername)
date=$(eval date)

GET_MAIL_ALERT_SUBJECT () {
	profile=$1
	msg_type=$2

	FLAG=$(uci -q get config_notify.$profile.wan_dis)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "1" ]; then
		echo "[Mail Alert] from $routername [WAN Disconnect]"
		return
	fi

	FLAG=$(uci -q get config_notify.$profile.wan_con)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "2" ]; then
		echo "[Mail Alert] from $routername [WAN Connect]"
		return
	fi

	FLAG=$(uci -q get config_notify.$profile.vpn_dis)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "3" ]; then
		echo "[Mail Alert] from $routername [VPN Disconnect]"
		return		
	fi

	FLAG=$(uci -q get config_notify.$profile.vpn_con)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "4" ]; then
		echo "[Mail Alert] from $routername [VPN Connect]"
		return
	fi

	FLAG=$(uci -q get config_notify.$profile.temper)
	if [ "$FLAG" == "enable" ] && [ "$msg_type" == "5" ]; then
		echo "[Mail Alert] from $routername [Temper]"
		return
	fi

	return 0
}


status=$(uci -q get config_mail.$MAIL_PROFILE.status)
if [ "$status" = "disable" ]; then
exit
fi

mailto=$(uci -q get config_mail_alert.$profile_id.recip)
if [ "$mailto" = "" ]; then
exit
fi

smtpserver=$(uci -q get config_mail.$MAIL_PROFILE.smtpserver)
if [ "$smtpserver" = "" ]; then
exit
fi 

smtpport=$(uci -q get config_mail.$MAIL_PROFILE.smtpport)
if [ "$smtpport" = "" ]; then
exit
fi 

user_login=$(uci -q get config_mail.$MAIL_PROFILE.user_login)

user_name=$(uci -q get config_mail.$MAIL_PROFILE.user_name)

user_password=$(uci -q get config_mail.$MAIL_PROFILE.user_password)

mailfrom=$(uci -q get config_mail.$MAIL_PROFILE.mailfrom)

res=$(ping $(uci -q get config_mail.$MAIL_PROFILE.smtpserver)  -c 3 -W 1 | grep "0 packets" 2>/dev/null)
if [ "$res" != "" ]; then
exit
fi

rm /etc/msmtprc
#echo account default > /tmp/mail_alert/msmtprc_mailalert
echo host $smtpserver >> /tmp/mail_alert/msmtprc_mailalert
echo port $smtpport >> /tmp/mail_alert/msmtprc_mailalert
if [ "$user_login" == "enable" ];then
	echo auth login >> /tmp/mail_alert/msmtprc_mailalert
	echo user $user_name >> /tmp/mail_alert/msmtprc_mailalert
	echo password $user_password >> /tmp/mail_alert/msmtprc_mailalert
else
	echo auth off >> /tmp/mail_alert/msmtprc_mailalert
fi        
echo auto_from off >> /tmp/mail_alert/msmtprc_mailalert
echo from $mailfrom >> /tmp/mail_alert/msmtprc_mailalert
echo logfile  /var/mail_alert.log >> /tmp/mail_alert/msmtprc_mailalert

echo "set sendmail=\"/usr/bin/msmtp --file=/tmp/mail_alert/msmtprc_mailalert\"" > /tmp/mail_alert/muttrc
echo set use_from=yes >> /tmp/mail_alert/muttrc
echo set from=$mailfrom >> /tmp/mail_alert/muttrc
echo set envelope_from=yes  >> /tmp/mail_alert/muttrc
echo set realname=\"$mailfrom\" >> /tmp/mail_alert/muttrc

subject=$(GET_MAIL_ALERT_SUBJECT $NOTIFY_PROFILE $MSG_TYPE)
echo "subject=$subject"

echo $2 >> /tmp/mail_alert/content
echo $date >> /tmp/mail_alert/content

#for user in ${mailto}; do	
	cat /tmp/mail_alert/content | mutt -F /tmp/mail_alert/muttrc -s "$subject" $mailto >/dev/null 2>&1 &
	if [ $? -eq 0 ]; then
		echo "rm outbox $4"
		rm -f $4
		rm -f /tmp/mail_alert/content
	fi
#done
