#!/bin/sh

. $IPKG_INSTROOT/etc/functions.sh
include /lib/network
WCD_TIMER="/tmp/wcd_lauch_time"
WCD_LAUCH_GAP=10

#prevent web renew button being triggered too frequently
[ ! -f "$WCD_TIMER" ] && {
	touch $WCD_TIMER
	[ -f "$WCD_TIMER" ] && cat /proc/uptime |awk -F"." '{print $1}' > $WCD_TIMER
} || {
	now_time=`cat /proc/uptime |awk -F"." '{print $1}'`
	last_time=`cat $WCD_TIMER`
	[ $(($now_time - $last_time)) -le $WCD_LAUCH_GAP ] && {
		logger "(WebUI)wcd renew button was triggered too frequently, abort opertaion"
		return
	}
}

config_load network

config=$1
action=$2

config_get iface $config ifname
config_get proto $config proto
connection=`json get network.$config.connection`

case "$proto" in
dhcp)
	if [ "$action" = "disconnect" ]; then
		pid=`cat /var/run/dhcp-$config.pid`
		kill -SIGUSR1 $pid
	fi
	;;
pppoe|pptp)
	logger "$config($proto) wcd: action=$action, enter"
	config_get always_on $config "$proto"_always_on
	if [ "$action" = "connect" ]; then
		[ "$always_on" = "enable" -o "$connection" = "up" ] || {
			logger "$config($proto) wcd: action=$action, call setup_interface_$proto with wcd"
			eval "setup_interface_$proto '$iface' '$config' '$proto' 'wcd'" &
		}
	elif [ "$action" = "disconnect" ]; then
		[ "$connection" = "up" ] && {
			pid=`cat /var/run/ppp-$config.pid | head -n 1`
			if [ "$always_on" = "disable" ]; then
				logger "$config($proto) wcd: not always_on, action=$action, kill pid=$pid"
				kill $pid
			elif [ "$always_on" = "enable" ]; then
				logger "$config($proto) wcd: always_on, action=$action, kill -SIGHUP pid=$pid"
				kill -SIGHUP $pid
			fi
		}
	fi
	;;
3g)
	if [ "$action" = "disconnect" ]; then
		[ "$connection" = "up" ] && {
			ifdown $config
		}
	elif [ "$action" = "connect" ]; then
		[ "$connection" = "down" ] && {
			ifup $config
		}
	fi
	
	;;
esac
