#!/bin/sh
ip_url="http://automation.whatismyip.com/n09230945.asp http://checkip.dyndns.com/"
ip_regex="[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}\.[0-9]\{1,3\}"

get_current_ip()
{
	current_ip='';
	
	for addr in $ip_url
	do
		if [ -z "$current_ip" ]
		then
			url_host=$(echo $addr | awk -F '/' '{print $3}') 
			ip_url_ip=$(echo $(nslookup "$url_host" 2>/dev/null) |  grep -o "Name:.*" | grep -o "$ip_regex")
			[ "$ip_url_ip" ] && flush_subnet=${ip_url_ip}/32 || flush_subnet=
			gw_ip=$(json get network.$1.gateway | grep -o "$ip_regex")
			/usr/sbin/flush_route_cache.sh "get_internet_ip.sh#1" all $flush_subnet
			#ip route flush cache
			route add "$ip_url_ip" gw "$gw_ip" dev wan-"$1" 2>/dev/null
			/usr/sbin/flush_route_cache.sh "get_internet_ip.sh#2" all $flush_subnet
			#ip route flush cache
			
			current_ip=$(echo $( wget -O - $addr 2>/dev/null) | grep -o "$ip_regex")
			route del "$ip_url_ip" gw "$gw_ip" dev wan-"$1" 2>/dev/null
			#/usr/sbin/flush_route_cache.sh "get_internet_ip.sh#3"
			#ip route flush cache
		fi

	done
	
	echo "$current_ip"
}

get_current_ip $1

