# 
# Copyright (C) 2006 OpenWrt.org
#
# This is free software, licensed under the GNU General Public License v2.
# See /LICENSE for more information.
#


define KernelPackage/comcerto-nand
  TITLE:=NAND support on Comcerto 50/100/1000 devices
  CATEGORY:=Mindspeed Packages
  DEPENDS:=@TARGET_comcerto1000||TARGET_comcerto100||TARGET_comcerto50
  KCONFIG:=CONFIG_MTD_NAND_COMCERTO
  DEFAULT:=y
  DESCRIPTION:= This package contains a driver to access NAND memories from Mindspeed Comcerto100 devices.
  URL:=http://www.mindspeed.com
  MAINTAINER:=Mindspeed Technologies
  AUTOLOAD:=$(call AutoLoad,60,nand_ecc nand_ids nand comcerto-nand)
endef

define KernelPackage/comcerto-nand/2.6
  FILES:= \
  	  $(LINUX_DIR)/drivers/mtd/nand/nand_ecc.$(LINUX_KMOD_SUFFIX) \
  	  $(LINUX_DIR)/drivers/mtd/nand/nand_ids.$(LINUX_KMOD_SUFFIX) \
	  $(LINUX_DIR)/drivers/mtd/nand/nand.$(LINUX_KMOD_SUFFIX) \
	  $(LINUX_DIR)/drivers/mtd/nand/comcerto-nand.$(LINUX_KMOD_SUFFIX)
endef
$(eval $(call KernelPackage,comcerto-nand))
