#!/bin/sh

status=$(uci get mail_alert.config.status)
if [ "$status" = "disable" ];then
exit
fi 
mailto=$(uci get mail_alert.config.mailto)
if [ "$mailto" = "" ];then
exit
fi 
smtpserver=$(uci get mail_alert.config.smtpserver)
if [ "$smtpserver" = "" ];then
exit
fi 

#res=$(ping $(uci get mail_alert.config.smtpserver)  -c 3 -W 1 | grep "0 packets" 2>/dev/null)
#if [ "$res" != "" ];then
#exit
#fi

if [ "$1" = "vpn_send" ]; then
	[ -f /tmp/vpn_mailalert ] || exit
fi

if [ "$1" = "vpn" ]; then
	vpn_mailalert_cnt=$(cat /tmp/vpn_mailalert | wc -l)
	[ $vpn_mailalert_cnt -le 10 ] && exit
fi

routername=$(uci get syslogd.syslogd.routername)
mailto_u=$(uci get mail_alert.config.mailto)

case $1 in
	vpn|vpn_send)
		subject="VPN Alert from Vigor Router : $routername"
		mv /tmp/vpn_mailalert /tmp/vpn_mailalert_send
		for user in ${mailto_u}; do	
			cat /tmp/vpn_mailalert_send | mutt -F /etc/config/muttrc -s "$subject" $user 2>/dev/null
			if [ $? -eq 0 ]; then
				rm /tmp/vpn_mailalert  2>/dev/null
			fi
		done
		logger -p local1.info "Send VPN mail alert"
		;;
	*)
		subject="Test e-mail from Vigor Router : $routername"
		printf "$date  This is a test mail from Vigor Router : $routername."  > /tmp/testmail
		for user in ${mailto_u}; do	
			cat /tmp/testmail | mutt -F /etc/config/muttrc -s "$subject" $user 2>/dev/null &
		done
		;;
esac
