#!/bin/sh /etc/rc.common
##### backup-polling_HS.sh
#This script is only running on HA config role: secondary
#It polls primary to update its own's config in order to sync with primary config

CHECK_INTERVAL=30
TFTP_PORT=6901
config_load ucarp

[ -f "/var/run/ucarp/backup-polling_HS.pid" ] && echo $$ >/var/run/ucarp/backup-polling_HS.pid

do_backup_tar_gz_dec()
{
	rm -rf /etc/persistence/config /etc/persistence/checksum /etc/persistence/data
	tar -xz -f /tmp/ucarp/backup.tar.gz -C /
}
config_sync_error()
{
	/etc/init.d/ucarp_mode stop
}

bulk_config_sync()
{
	########## Backup some item of my original configs
	## Backup original ucarp_mode config
	my_status=`uci get ucarp_mode.general.status`
	my_config_role=`uci get ucarp_mode.general.config_role`
	my_preempt_mode=`uci get ucarp_mode.general.preempt_mode`
	my_HS_secondary_id=`uci get ucarp_mode.general.HS_secondary_id`
	my_delay_intv=`uci get ucarp_mode.general.delay_intv`
	my_manual_status=`uci get ucarp_mode.general.manual_status`
	my_config_primary_ip=`uci get ucarp_mode.general.config_primary_ip`
	my_manual_threshold=`uci get ucarp_mode.general.manual_threshold`
	my_lan_port_detect=`uci get ucarp_mode.general.lan_port_detect`
	## Backup original ucarp config
	tar -cz -f /tmp/ucarp/ucarp.tar.gz /etc/persistence/config/ucarp 2> /dev/null >/dev/null
	## Backup original LANs' IP and MAC
	my_eth0_mac=`cat /sys/class/net/eth0/address`
	my_lans=`uci filter network physical eth0`
	for lan in $my_lans ;do
		my_lan_ip=`uci get network.$lan.static_ipaddr`
		json set ucarp.$lan static_ip="$my_lan_ip"
	done
	
	########## Get entire config from primary
	while true; do
		tftp -g -l /tmp/ucarp/master.tar.gz -r master.tar.gz $config_primary_ip $TFTP_PORT
		tftp_ret=$?
		if [ "$tftp_ret" = "0" ]; then
			echo "(HA)bulk_config_sync: got config from primary:$config_primary_ip" >/dev/console
			break
		else
			echo "(HA)bulk_config_sync: fail to get config from primary:$config_primary_ip, try again..." >/dev/console
			sleep 5
		fi
	done
	tar -cz -f /tmp/ucarp/backup.tar.gz /etc/persistence/config /etc/persistence/checksum /etc/persistence/data
	[ "$?" = 0 ] && {
		echo "(HA)bulk_config_sync: backup my original config done" >/dev/console
		rm -rf /etc/persistence/config /etc/persistence/checksum /etc/persistence/data
	}
	tar -xz -f /tmp/ucarp/master.tar.gz -C / || {
		echo "(HA)bulk_config_sync(ERROR): fail to extract primary config! restore my original config and stop HA" >/dev/console
		do_backup_tar_gz_dec
		uci set ucarp_mode.general.status="disable"
		config_sync_fail=1
		uci commit ucarp_mode
		return
	}
	echo "(HA)bulk_config_sync: extract primary config done" >/dev/console
	
	########## Initialize config sync file:/etc/ucarp/revison
	echo "(HA)bulk_config_sync: create md5sum of primary config" >/dev/console
	md5sum /tmp/ucarp/master.tar.gz > /etc/ucarp/revision
	echo "(HA)bulk_config_sync: initialize revision control file" >/dev/console
	head -n 2 /tmp/ucarp/revision | tail -n 1 >> /etc/ucarp/revision    
	echo "0" >> /etc/ucarp/revision
	
	rm -f /tmp/.uci/
	
	#### Restore some of my original configs
	echo "(HA)bulk_config_sync: rollback some configs" >/dev/console
	## rollback my ucarp_mode config
	uci set ucarp_mode.general.status=$my_status
	uci set ucarp_mode.general.config_role=$my_config_role
	uci set ucarp_mode.general.HS_secondary_id=$my_HS_secondary_id
	uci set ucarp_mode.general.preempt_mode=$my_preempt_mode
	uci set ucarp_mode.general.delay_intv=$my_delay_intv
	uci set ucarp_mode.general.manual_status=$my_manual_status
	uci set ucarp_mode.general.config_primary_ip=$my_config_primary_ip
	uci set ucarp_mode.general.manual_threshold=$my_manual_threshold
	uci set ucarp_mode.general.lan_port_detect=$my_lan_port_detect
	## rollback ucarp config (pip_list from master is not used right now, but we may need it for further enhancement)
	rm -rf /etc/persistence/config/ucarp
	tar -xz -f /tmp/ucarp/ucarp.tar.gz -C /
	## rollback LANs IP and MAC
	new_lans=`uci filter network physical eth0`
	if [ -n "$new_lans" ] ;then
		for new_lan in $new_lans ;do
			my_lan_ip=`json get ucarp.$new_lan.static_ip`
			if [ -n "$my_lan_ip" ] ;then
				#if my old lan is matched with new lan, rollback ip,mac
				uci set network.$new_lan.static_ipaddr="$my_lan_ip"
				uci set network.$new_lan.macaddr="$my_eth0_mac"
			else
				#if new lan is not found with my old lan, it's probably a HA pre-set error:(primary and secondary lans not matched)
				#In this case, I do not have old ip,mac to overwrite it,
				#so I should disable this ummatched lan profile to prevent IP conflict
				echo "(HA)bulk_config_sync: Found a Unmatched LAN profile:$new_lan, mark it disable!" >/dev/console
				uci set network.$new_lan.status=disable
			fi
		done
	fi
	uci commit network
	uci commit ucarp
	uci commit ucarp_mode
	sleep 3
	sync
	echo "(HA)bulk_config_sync: config sync done, reboot!" >/dev/console
	logger -p 160.5 "High Availability: bulk config synchronization finished, reboot!"
	reboot
}

check_all_vip_existed() {
	config_get lan $1 lan
	config_get vip $1 vip
	ifname=lan-$lan
	arping -f -c 1 -w 2 -i $ifname $vip >/dev/null 2>/dev/null
	if [ "$?" != "0" ] ;then
		echo "check_all_vip_existed($$): does not detect vip($vip)!" >/dev/console
		vip_is_existed=0
	fi
}

config_primary_ip=`uci get ucarp_mode.general.config_primary_ip`
my_config_role=`uci get ucarp_mode.general.config_role`
preempt_mode=`uci get ucarp_mode.general.preempt_mode`
manual_status=`uci get ucarp_mode.general.manual_status`
manual_threshold=`uci get ucarp_mode.general.manual_threshold`
manual_threshold=$(($manual_threshold * 60))

start_time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
echo "backup-polling_HS($$): Start" >/dev/console

while true; do
	if [ "$my_config_role" = "primary" ] ;then
		if [ "$manual_status" = "enable" ] ;then
			echo "backup-polling_HS: I am the original config owner, exit" >/dev/console
			break
		else
			sleep 10
		fi
	else
		tftp -g -l /tmp/ucarp/revision -r revision $config_primary_ip $TFTP_PORT
		tftp_ret=$?
		if [ "$tftp_ret" = "0" ]; then
			#First: check primary's base config is changed or not; If primary has ever restarted HA, the checksum is remade
			config_sync_fail=0
			if [ -f "/etc/ucarp/revision" ]; then
				### Description
				##/tmp/ucarp/revision:for primary, it save its config and revision here; for secondary, it get config and revision from primary then store them here
				##/etc/ucarp/revision:for primary, no this file; for secondary, it uses the file to check/update revision in order to sync with primary
				new_md5=`head -n 2 /tmp/ucarp/revision`
				old_md5=`head -n 2 /etc/ucarp/revision`
				[ "$new_md5" = "$old_md5" ] || {
					echo "backup-polling_HS: primary config checksum has changed! do config sync" >/dev/console
					bulk_config_sync
					[ "$config_sync_fail" = 1 ] && {
						config_sync_error
						exit 1
					}
				}
			else
				echo "(HA)backup-polling: do bulk config sync" >/dev/console
				logger -p 160.5 "High Availability: Start bulk config synchronization"
				bulk_config_sync
				[ "$config_sync_fail" = 1 ] && {
					config_sync_error
					exit 1
				}
			fi
			#Second: if base config is not changed, check if new revision patch is generated or not
			master_rev=`tail -n 1 /tmp/ucarp/revision`
			backup_rev=`tail -n 1 /etc/ucarp/revision`
			while [ $backup_rev -lt $master_rev ]; do
				backup_rev=$(($backup_rev+1))
				tftp -g -l /tmp/ucarp/$backup_rev.tar.gz -r $backup_rev.tar.gz $config_primary_ip $TFTP_PORT || break
			done
			/etc/ucarp/backup-sync.sh &
			sleep $CHECK_INTERVAL
		else
			#echo "backup-polling_HS($$): can not get revision file from primary router:$config_primary_ip, try again after 10 secs" >/dev/console
			sleep 10
		fi
	fi
	#echo "backup-polling_HS($$): preempt_mode=$preempt_mode, manual_status=$manual_status" >/dev/console
	[ "$preempt_mode" = "manual" -a "$manual_status" = "disable" ] && {
		check_time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		DIFF=$(($check_time - $start_time))
		#echo "backup-polling_HS($$): check_time=$check_time, start_time=$start_time" >/dev/console
		echo "backup-polling_HS($$): timer=$DIFF, manual_threshold=$manual_threshold" >/dev/console
		if [ $DIFF -ge $manual_threshold ] ;then
			vip_is_existed=1
			config_foreach check_all_vip_existed
			if [ "$vip_is_existed" = "0" ] ;then
				#At least one of VIP is not found after threshold,
				#we should set our manual_status to "active to rejoin the preemption.
				#This is to prevent a case where entire system are all in deactive state, and no service provider
				echo "backup-polling_HS($$): one-time preemption case: VIP is not found after threshold, set my preemption flag to active, then restart" >/dev/console
				uci set ucarp_mode.general.manual_status=enable
				uci commit ucarp_mode
				exit
			else
				#VIP are all found after threshold, stay our manual_status in "deactive". upgrade start time for next threshold check
				start_time=$check_time
				echo "backup-polling_HS($$): VIPs detected, reset timer" >/dev/console
			fi
		fi
	}
done
