#!/bin/sh

pidof backup-sync.sh | grep " " > /dev/null && {
    ##### another backup-sync.sh is running, abort.
    return 1
}

master_rev=`tail -n 1 /tmp/ucarp/revision`
backup_rev=`tail -n 1 /etc/ucarp/revision`
[ -z "$master_rev" -o -z "$backup_rev" ] && return 1

while [ "$backup_rev" -lt "$master_rev" ]; do
    backup_rev=$(($backup_rev+1))
    #Extract uci changes record into /tmp/.uci/
	tar -xz -f /tmp/ucarp/$backup_rev.tar.gz -C / || return 1
	######## Do not update following items:
	#1.Any update to LAN
	all_lan=`uci filter network physical eth0`
	for lan in $all_lan ;do
		eval sed -i '/\\.$lan\\./d' /tmp/.uci/network
	done
	
	#2.Any update to HA LAN VLAN
	ha_lans=`json get ucarp.general.ha_lan`
	#vlan_member=
	lan_vlanid=
	for ha_lan in $ha_lans ;do
		lan_vlanid=`uci get network.$ha_lan.vlan_id`" $lan_vlanid" 
		#vlan_member=`uci get vlan_lan.$lan_vlanid.member`" $vlan_member"
	done
	#3.Any update to VLAN of HA LAN
	for vlan_id in $lan_vlanid ;do
		eval sed -i '/\\.$vlan_id\\./d' /tmp/.uci/vlan_lan
		#echo "vlan id:$vlan_id is removed from update revision" >/dev/console
	done
	
	#4.Any update to HA function
	rm -f /tmp/.uci/ucarp
	rm -f /tmp/.uci/ucarp_mode
	
	#ok, apply the rest patch
	config_apply
	#update revision control info
	sed -i '3,$d' /etc/ucarp/revision
	echo "$backup_rev" >> /etc/ucarp/revision
	echo "backup-sync: Handle revision index=$backup_rev done" >/dev/console
done
