#!/bin/sh
ifname=$1
vip=$2
ha_profile=$3
GLOBAL_LOCK="/tmp/ucarp/ha-down_AS_lock"

#spin-lock to wait ha-up_AS.sh completed
enter_time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
while true; do
	if [ -f /tmp/ucarp/ha_up_lock_AS_${ha_profile} ] ;then
		echo "ha-down_AS($ha_profile): Found ha_up_lock_AS_$ha_profile, wait..." >/dev/console
		BREAK_LOCK_INTV=30
		nowtime=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		DIFF=$(($nowtime - $enter_time))
		if [ $DIFF -le $BREAK_LOCK_INTV ] ;then
			sleep 5
			continue
		else
			echo "ha-down_AS($ha_profile): over $BREAK_LOCK_INTV secs, Break ha_up_lock_AS" >/dev/console
			rm -f /tmp/ucarp/ha_up_lock_AS_${ha_profile} 2>/dev/null
		fi
	else
		break
	fi
done

#create my lock
[ -f /tmp/ucarp/ha_down_lock_AS_$ha_profile ] && return
touch /tmp/ucarp/ha_down_lock_AS_$ha_profile
#echo "ha-down_AS($ha_profile): create my script lock" >/dev/console

iface=`uci get ucarp.$ha_profile.lan`
#Remove VIP on this HA LAN
mask=`uci get network.$iface.static_netmask`
/usr/sbin/ip addr del $vip/$mask dev $ifname 2> /dev/null >/dev/null
#remove VIP from Ipset:ip_lanX for user management dst bypassing
ipset -D ip_$iface $vip

##### update state to backup
json set ucarp.${ha_profile} state=backup
uci set ucarp.${ha_profile}.ha_profile_status=Backup

##### Do not stop wan_port_polling_AS, because maybe other master state are using it

##### stop master-polling_AS
master_poll_PID=`cat /var/run/ucarp/${ha_profile}_ASmaster.pid`
kill -9 $master_poll_PID 2>/dev/null
rm -f /var/run/ucarp/${ha_profile}_ASmaster.pid
echo "ha-down_AS($ha_profile): stop master-polling_AS process" >/dev/console

##### G38957: Disable the HA LAN's DHCP Service
json set ucarp.$iface dhcp_state=down
echo "ha-down_AS($ha_profile): disable $iface dhcp service" >/dev/console
/etc/init.d/dhcpd apply

#Send garp of the HA LAN's primary IP
macaddr=`uci get network.$iface.macaddr`
static_ipaddr=`uci get network.$iface.static_ipaddr`
arping -b -c 1 -i lan-$iface -S $macaddr $static_ipaddr > /dev/null

#release script lock
rm -f /tmp/ucarp/ha_down_lock_AS_$ha_profile
#echo "ha-down_AS($ha_profile): script done, remove my script lock" >/dev/console
