#!/bin/sh
#ifname=$1
#vip=$2
ha_profile=$3

GLOBAL_LOCK="/tmp/ucarp/ha-up_HS_lock"

enter_time=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
while true; do
	#spin if any ha-down lock is found
	lock=`ls /tmp/ucarp/ha_down_lock_HS_*` 2>/dev/null >/dev/console
	if [ "$?" = "0" ] ;then
		echo "ha-up_HS($ha_profile): Found ha_down_lock_HS:$lock, wait..." >/dev/console
		BREAK_LOCK_INTV=30
		nowtime=$(cat /proc/uptime | awk 'FS="[.]+" {print $1}')
		DIFF=$(($nowtime - $enter_time))
		if [ $DIFF -le $BREAK_LOCK_INTV ] ;then
			sleep 5
			continue
		else
			echo "ha-up_HS($ha_profile): has been over $BREAK_LOCK_INTV secs, break all ha_down_lock_HS:$lock" >/dev/console
			for k in $lock ;do
				rm -f $k
			done
		fi
	else
		break
	fi
done
######################## Private Works ########################
#create my lock
[ -f /tmp/ucarp/ha_up_lock_HS_$ha_profile ] && return
touch /tmp/ucarp/ha_up_lock_HS_$ha_profile
#echo "ha-up_HS($ha_profile): create my script lock" >/dev/console

######################## Global Works ########################
lock $GLOBAL_LOCK
if [ -f "/var/run/ucarp/HSmaster.pid" ] ;then
	echo "ha-up_HS($ha_profile): master-polling_HS is already running, abort" >/dev/console
else
	touch "/var/run/ucarp/HSmaster.pid"
	echo "ha-up_HS($ha_profile): I am the superior, now I become Master" >/dev/console
	##### update state to master for ifup script
	json set ucarp state=master
	##### stop backup-polling_HS
	killall backup-polling_HS.sh
	rm -f /var/run/ucarp/backup-polling_HS.pid
	echo "ha-up_HS($ha_profile): stop backup-polling_HS" >/dev/console
	##### start master-polling_HS
	/etc/ucarp/master-polling_HS.sh &
	echo "ha-up_HS($ha_profile): start master-polling_HS" >/dev/console
	##### Deactive manual preemption mode
	#If preemption is manual, deactive preemption status when it is going to be master
	#get HA parameters
	preempt_mode=`uci get ucarp_mode.general.preempt_mode`
	if [ "$preempt_mode" = "manual" ] ;then
		echo "ha-up_HS($ha_profile): one-time promotion is used, reset global preemption flag [manual preemption status]" >/dev/console
		uci set ucarp_mode.general.manual_status=disable
		uci commit ucarp_mode
	fi
fi
lock -u $GLOBAL_LOCK

#release script lock
rm -f /tmp/ucarp/ha_up_lock_HS_$ha_profile
#echo "ha-up_HS($ha_profile): script done, remove my script lock" >/dev/console
