#!/bin/sh /etc/rc.common

last_all_wans=""
[ -f "/var/run/ucarp/ha_poll_wanport_AS.pid" ] && echo $$ >/var/run/ucarp/ha_poll_wanport_AS.pid

while true; do
	################################### G40237: If all WAN switch ports are down, stop ucarp sending CARP ad
	################### Query status of WAN switch ports
	detect_wan_result="down"
	enabled_WANs=`json -f /var/cd_status get global.interfaces`
	if [ -n "$enabled_WANs" ] ;then
		for detect_wan in $enabled_WANs ;do
			wan_port_down=`json -f /var/cd_status get interface.$detect_wan.port_down`
			if [ "$wan_port_down" = 0 ] ;then
				detect_wan_result="up"
			fi
		done
		################### Handle detect WANs case
		if [ "$detect_wan_result" = "up" ] ;then
			if [ -z "$last_all_wans" -o "$last_all_wans" = "down" ] ;then
				last_all_wans=up
				json set ucarp.general all_wan_status=up
			fi
		elif [ "$detect_wan_result" = "down" ] ;then
			if [ -z "$last_all_wans" -o "$last_all_wans" = "up" ] ;then
				last_all_wans=down
				json set ucarp.general all_wan_status=down
			fi
		fi
		sleep 10
	else
		sleep 30
	fi
done