#!/bin/sh /etc/rc.common
### HA function is only deployed on Vigor3900
#This script is used to polling one special event:
#G40237: If all WAN switch ports are down, stop send CARP
#Mechanism for multi-HA LAN environment(Active-Standby method)

last_all_wans=""
NO_WAN_IS_ENABLED=0
HA_profile=$2
[ -f "/var/run/ucarp/${HA_profile}_ASmaster.pid" ] && echo $$ >/var/run/ucarp/${HA_profile}_ASmaster.pid
vip=`uci get ucarp.$HA_profile.vip`
lan=`uci get ucarp.$HA_profile.lan`

restore_CARP_ad()
{
	[ -f /var/run/ucarp/$1.pid ] && {
		ucarp_PID=`cat /var/run/ucarp/$1.pid`
		[ -z "$ucarp_PID" ] || kill -SIGUSR2 $ucarp_PID 2>/dev/null
	}
}
attach_vip()
{
	#Attach VIP to LAN
	ifname=lan-$lan
	lan_mask=`uci get network.$lan.static_netmask`
	macaddr=`uci get network.$lan.macaddr`
	/usr/sbin/ip addr add $vip/$lan_mask dev $ifname brd + 2> /dev/null > /dev/null
	[ "$?" = 0 ] && echo "master-polling_AS($HA_profile): Attach VIP($vip) to $ifname" >/dev/console
	#Add VIP into ipset:ip_lanX for user management dst bypassing
	ipset -A ip_$lan $vip
	#send garp of VIP
	arping -b -c 1 -i $ifname -S $macaddr $vip > /dev/null
}
stop_CARP_ad() {
	[ -f /var/run/ucarp/$1.pid ] && {
		ucarp_PID=`cat /var/run/ucarp/$1.pid`
		[ -z "$ucarp_PID" ] || kill -SIGUSR1 $ucarp_PID 2>/dev/null	
	}
}
remove_vip()
{
	#Remove VIP from LAN
	ifname=lan-$lan
	lan_mask=`uci get network.$lan.static_netmask`
	/usr/sbin/ip addr del $vip/$lan_mask dev $ifname 2> /dev/null >/dev/null
	[ "$?" = 0 ] && echo "master-polling_AS($HA_profile): Remove VIP($vip) from $ifname" >/dev/console
	#remove VIP from ipset:ip_lanX for user management dst bypassing
	ipset -D ip_$lan $vip
}

set_status_to_master() {
	uci set ucarp.$HA_profile.ha_profile_status=Master
}
set_to_mal_master_WAN(){
	uci set ucarp.$HA_profile.ha_profile_status=WAN_Failed
}


while true; do
	################ G40237: If all WAN switch ports are down, stop ucarp sending CARP ad
	enabled_WANs=`json -f /var/cd_status get global.interfaces`
	if [ -n "$enabled_WANs" ] ;then
		NO_WAN_IS_ENABLED=0
		all_wan_status=`json get ucarp.general.all_wan_status`
		if [ "$all_wan_status" = "up" ] ;then
			if [ -z "$last_all_wans" -o "$last_all_wans" = "down" ] ;then
				echo "master-polling_AS($HA_profile): one of enabled WAN/USB's switch port is up, start to send AD" >/dev/console
				last_all_wans=up
				restore_CARP_ad $HA_profile
				attach_vip
				##### Enable LAN DHCP Service
				json set ucarp.$lan dhcp_state=up
				echo "master-polling_AS($HA_profile): enable $lan dhcp service" >/dev/console
				/etc/init.d/dhcpd apply
				set_status_to_master
			fi
		elif [ "$all_wan_status" = "down" ] ;then
			if [ -z "$last_all_wans" -o "$last_all_wans" = "up" ] ;then
				echo "master-polling_AS($HA_profile): all enabled WAN/USB switch ports are down, stop sending AD" >/dev/console
				last_all_wans=down
				stop_CARP_ad $HA_profile
				remove_vip
				json set ucarp.$lan dhcp_state=down
				echo "master-polling_AS($HA_profile): disable $lan dhcp service" >/dev/console
				/etc/init.d/dhcpd apply
				set_to_mal_master_WAN
			fi
		fi
		sleep 10
	else
		if [ "$NO_WAN_IS_ENABLED" = "0" ] ;then
			NO_WAN_IS_ENABLED=1
			echo "master-polling_AS($HA_profile):Event: No WAN is enabled, start up master procedure one time" >/dev/console
			restore_CARP_ad $HA_profile
			attach_vip
			##### Enable LAN DHCP Service
			json set ucarp.$lan dhcp_state=up
			echo "master-polling_AS($HA_profile): enable $lan dhcp service" >/dev/console
			/etc/init.d/dhcpd apply
			sleep 10
		fi
	fi
done
