#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "asterisk"

! empty "$FORM_new_conf" && {
        SAVED=1
validate <<EOF
hostname|FORM_name|@TR<<Conf Name>>|required|$FORM_name
int|FORM_number|@TR<<Conf Number>>|required|$FORM_number
EOF
        equal "$?" 0 && {
        confid=`uci get asterisk.general.confcount`
	confid=`expr $confid + 1`
	uci_add asterisk asterisk conf$confid
	uci_set asterisk conf$confid name "$FORM_name"
	uci_set asterisk conf$confid number "$FORM_number"
	uci_set asterisk conf$confid wb "$FORM_wb"
	uci_set asterisk general confcount "$confid"
	config_set conf$confid name "$FORM_name"
	config_set conf$confid number "$FORM_number"
	config_set conf$confid wb "$FORM_wb"
	}
}

! empty "$FORM_display_conf" && {
	confid=$FORM_display_conf
	config_get FORM_name conf$confid name
	config_get FORM_number conf$confid number
	config_get FORM_wb conf$confid wb
}

! empty "$FORM_save_conf" && {
validate <<EOF
hostname|FORM_name|@TR<<Conf Name>>|required|$FORM_name
int|FORM_number|@TR<<Conf Number>>|required|$FORM_number
EOF
	equal "$?" 0 && {
	uci_set asterisk conf$FORM_confid name "$FORM_name"
	uci_set asterisk conf$FORM_confid number "$FORM_number"
	uci_set asterisk conf$FORM_confid wb "$FORM_wb"
	config_set conf$FORM_confid name "$FORM_name"
	config_set conf$FORM_confid number "$FORM_number"
	config_set conf$FORM_confid wb "$FORM_wb"
	}
}

! empty "$FORM_delete" && {
	confcount=`uci get asterisk.general.confcount`
	confid=$FORM_delete
	uci_remove asterisk conf$confid
	while [ $confid -le $confcount ]
	do
	uci_rename asterisk conf`expr $confid + 1` conf$confid
	confid=`expr $confid + 1`
	done
	uci_set asterisk general confcount `expr $confcount - 1`
}

#####################################################################
header "Telephony" "Conferencing" "@TR<<Conferencing>>" ''
#####################################################################
count=`uci get asterisk.general.confcount`

echo "<div class=\"settings\">"
echo "<th colspan=\"11\"><h3><strong>" List of Conference Numbers: "</strong></h3></th>"
echo "<div class=\"settings-content-inner\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>Serial No.</th><th>Conference Name</th><th>Conference Number</th><th>Wide-band Conference</th><th style=\"text-align: center;\">Actions</th></tr>"
i=1
while [ $i -le $count ]
do
config_get name conf$i name
config_get number conf$i number
config_get wb conf$i wb
[ -n "$wb" ] && wb="Enabled" || wb="Disabled"
echo "<tr class=\"tr_bg\"><td>$i</td><td>$name</td><td>$number</td><td>$wb</td>"
echo "<td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_conf=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>  <a href=\"$SCRIPT_NAME?delete=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
i=`expr $i + 1`
done
echo "</tbody></table></div><div class=\"clearfix\">&nbsp;</div></div>"

display_form <<EOF
start_form
formtag_begin|new_conf_no|$SCRIPT_NAME
submit|new_conf_no| @TR<< Add New >>
formtag_end
end_form
EOF

! empty "$FORM_new_conf_no" && {

display_form <<EOF
start_form|@TR<<New Conference Number>>
formtag_begin|new_conf|$SCRIPT_NAME
field|@TR<<Conf Name>>|name
text|name|$FORM_name
field|@TR<<Conf Number>>|number
text|number|$FORM_number
field|Wide Band
checkbox|wb|$FORM_wb|enable
field||spacer1
string|<br />
submit|new_conf|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_conf" && {

display_form <<EOF
start_form|@TR<<Edit Conference $FORM_display_conf>>
formtag_begin|save_conf|$SCRIPT_NAME
field|@TR<<Conf Serial No>>
text|confid|$FORM_display_conf|||readonly
field|@TR<<Conf Name>>|name
text|name|$FORM_name
field|@TR<<Conf Number>>|number
text|number|$FORM_number
field|Wide Band
checkbox|wb|$FORM_wb|enable
field||spacer1
string|<br />
submit|save_conf|@TR<<Save>>
reset||@TR<<Reset>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

footer ?>

<!--
##WEBIF:name:Telephony:500:Conferencing
-->
