#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "firewall"

! empty "$FORM_clear" && {
FORM_name=""
FORM_protocol=""
FORM_port=""
}

! empty "$FORM_new_service" && {
        SAVED=1
case "$FORM_protocol" in
	tcp|udp) REQ="required";;
	*) REQ="";;
esac
validate <<EOF
hostname|FORM_name|@TR<<Service Name>>|required|$FORM_name
string|FORM_protocol|@TR<<Protocol>>|required|$FORM_protocol
int|FORM_port|@TR<<Port>>|$REQ min=1 max=65535|$FORM_port
EOF
        equal "$?" 0 && {
        serviceid=`uci get firewall.general.service_count`
        serviceid=`expr $serviceid + 1`
	uci_add firewall firewall service$serviceid
	uci_set firewall service$serviceid name "$FORM_name"
	uci_set firewall service$serviceid protocol "$FORM_protocol"
	case "$FORM_protocol" in
		tcp|udp) uci_set firewall service$serviceid port "$FORM_port";;
		*) uci_set firewall service$serviceid port "";;
	esac
	uci_set firewall general service_count "$serviceid"
	}
}

! empty "$FORM_display_service" && {
	serviceid=$FORM_display_service
	FORM_name=${name:-$(uci get firewall.service$serviceid.name)}
	FORM_protocol=${protocol:-$(uci get firewall.service$serviceid.protocol)}
	FORM_port=${port:-$(uci get firewall.service$serviceid.port)}
}

! empty "$FORM_save_service" && {
case "$FORM_protocol" in
	tcp|udp) REQ="required";;
	*) REQ="";;
esac
validate <<EOF
hostname|FORM_name|@TR<<Service Name>>|required|$FORM_name
string|FORM_protocol|@TR<<Protocol>>|required|$FORM_protocol
int|FORM_port|@TR<<Port>>|$REQ min=1 max=65535|$FORM_port
EOF
	equal "$?" 0 && {
	uci_set firewall service$FORM_serviceid name "$FORM_name"
	uci_set firewall service$FORM_serviceid protocol "$FORM_protocol"
	case "$FORM_protocol" in
		tcp|udp) uci_set firewall service$serviceid port "$FORM_port";;
		*) uci_set firewall service$serviceid port "";;
	esac
	}
}

! empty "$FORM_delete" && {
	servicecount=`uci get firewall.general.service_count`
	serviceid=$FORM_delete
	uci_remove firewall service$serviceid
	while [ $serviceid -le $servicecount ]
	do
	uci_rename firewall service`expr $serviceid + 1` service$serviceid
	serviceid=`expr $serviceid + 1`
	done
	uci_set firewall general service_count `expr $servicecount - 1`
}

#####################################################################
header "Firewall" "Services" "@TR<<Services>>" ' onload="modechange()" '
#####################################################################
cat <<EOF
<script type="text/javascript" src="/webif.js "></script>
<script type="text/javascript">
<!--
function modechange()
{
	var v;
	v = (isset('protocol', 'tcp') || isset('protocol', 'udp'));
	set_visible('port', v);
}
-->
</script>
EOF

wan=`uci get bridge.general.wan`
equal $wan 1 && {
display_form << EOF
string|<h3>WAN is part of bridge.</h3>
EOF
}

! equal $wan 1 && {

count=`uci get firewall.general.service_count`

echo "<div class=\"settings\">"
echo "<th colspan=\"11\"><h3><strong>" List of Services: "</strong></h3></th>"
echo "<div class=\"settings-content-inner\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>Serial No.</th><th>Service Name</th><th>Protocol</th><th>Port Number</th><th style=\"text-align: center;\">Actions</th></tr>"
i=1
while [ $i -le $count ]
do
name=`uci get firewall.service$i.name`
proto=`uci get firewall.service$i.protocol`
port=`uci get firewall.service$i.port`
echo "<tr class=\"tr_bg\"><td>$i</td><td>$name</td><td>$proto</td><td>$port</td>"
echo "<td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?display_service=$i\"><img alt=\"@TR<<edit>>\" src=\"/images/edit.gif\" title=\"@TR<<edit>>\" /></a>"
echo " "
echo "<a href=\"$SCRIPT_NAME?delete=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a>"
echo "</td></tr>"
i=`expr $i + 1`
done
echo "</tbody></table></div><div class=\"clearfix\">&nbsp;</div></div><br>"

empty "$FORM_display_service" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<New Service>>
formtag_begin|new_service|$SCRIPT_NAME
field|@TR<<Service Name>>|name
text|name|$FORM_name
field|@TR<<Protocol>>
select|protocol|$FORM_protocol
option|tcp|@TR<<TCP>>
option|udp|@TR<<UDP>>
option|icmp|@TR<<ICMP>>
field|@TR<<Port>>|port|hidden
text|port|$FORM_port
field||spacer1
string|<br />
submit|new_service|@TR<<Add>>
submit|clear|@TR<<Clear>>
formtag_end
end_form
EOF
}

! empty "$FORM_display_service" && {
display_form <<EOF
onchange|modechange
start_form|@TR<<Edit Service $FORM_display_service>>
formtag_begin|save_service|$SCRIPT_NAME
field|@TR<<Serial No>>
text|serviceid|$FORM_display_service|||readonly
field|@TR<<Service Name>>|name
text|name|$FORM_name
field|@TR<<Protocol>>
select|protocol|$FORM_protocol
option|tcp|@TR<<TCP>>
option|udp|@TR<<UDP>>
option|icmp|@TR<<ICMP>>
field|@TR<<Port>>|port|hidden
text|port|$FORM_port
field||spacer1
string|<br />
submit|save_service|@TR<<Save>>
reset||@TR<<Reset>>
formtag_end
end_form
EOF
}

}

footer ?>

<!--
##WEBIF:name:Firewall:200:Services
-->
