#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load "firewall"

! empty "$FORM_new_url" && {
        SAVED=1
validate <<EOF
string|FORM_url|@TR<<URL>>|required|$FORM_url
EOF
        equal "$?" 0 && {
        urlid=`uci get firewall.general.url_count`
        urlid=`expr $urlid + 1`
	uci_add firewall firewall url$urlid
	uci_set firewall url$urlid type "$FORM_type"
	uci_set firewall url$urlid url "$FORM_url"
	uci_set firewall general url_count "$urlid"
	}
}

! empty "$FORM_delete" && {
	urlcount=`uci get firewall.general.url_count`
	urlid=$FORM_delete
	uci_remove firewall url$urlid
	while [ $urlid -le $urlcount ]
	do
	uci_rename firewall url`expr $urlid + 1` url$urlid
	urlid=`expr $urlid + 1`
	done
	uci_set firewall general url_count `expr $urlcount - 1`
}

#####################################################################
header "Security" "URL-Filter" "@TR<<URL Filter>>" ''
#####################################################################

wan=`uci get bridge.general.wan`
equal $wan 1 && {
display_form << EOF
string|<h3>WAN is part of bridge.</h3>
EOF
}

! equal $wan 1 && {

count=`uci get firewall.general.url_count`
echo "<th colspan=\"11\"><h3>" Trusted URLs: "</h3></th>"
echo "<div class=\"settings\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>URL</th><th style=\"text-align: center;\">Action</th></tr>"
i=1
while [ $i -le $count ]
do
url=`uci get firewall.url$i.url`
type=`uci get firewall.url$i.type`
if [ "$type" = "trusted" ]; then
echo "<tr><td>$url</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?delete=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
fi
i=`expr $i + 1`
done
echo "</tbody></table><div class=\"clearfix\">&nbsp;</div></div><br>"

echo "<th colspan=\"11\"><h3>" Blocked URLs: "</h3></th>"
echo "<div class=\"settings\">"
echo "<table style=\"width: 96%; text-align: left; font-size: 0.8em;\" border=\"0\" cellpadding=\"3\" cellspacing=\"3\" align=\"center\"><tbody>"
echo "<tr class=\"odd\"><th>URL</th><th style=\"text-align: center;\">Action</th></tr>"
i=1
while [ $i -le $count ]
do
url=`uci get firewall.url$i.url`
type=`uci get firewall.url$i.type`
if [ "$type" = "blocked" ]; then
echo "<tr><td>$url</td><td style=\"text-align: center;\"><a href=\"$SCRIPT_NAME?delete=$i\"><img alt=\"@TR<<delete>>\" src=\"/images/x.gif\" title=\"@TR<<delete>>\" /></a></td></tr>"
fi
i=`expr $i + 1`
done
echo "</tbody></table><div class=\"clearfix\">&nbsp;</div></div><br>"

display_form <<EOF
start_form|@TR<<New URL>>
formtag_begin|new_url|$SCRIPT_NAME
field|@TR<<Type>>
select|type|$FORM_type
option|trusted|@TR<<Trusted>>
option|blocked|@TR<<Blocked>>
field|@TR<<URL>>|url
text|url|$FORM_url
field||spacer1
string|<br />
submit|new_url|@TR<<Add>>
reset||@TR<<Clear>>
formtag_end
end_form
EOF

}

footer ?>

<!--
##WEBIF:name:xSecurity:400:URL-Filter
-->
