#!/usr/bin/webif-page
<?
. /usr/lib/webif/webif.sh
uci_load network
uci_load webif
uci_load wireless


if empty "$FORM_save_advance"; then
FORM_fr_threshold=${fr_threshold:-$(uci get wireless.advance.fr_threshold)}
FORM_rts_threshold=${rts_threshold:-$(uci get wireless.advance.rts_threshold)}
else 
SAVED=1
validate <<EOF
int|FORM_fr_threshold|@TR<<Fragmentation Threshold>>|min=256 max=2346|$FORM_fr_threshold
int|FORM_rts_threshold|@TR<<RTS Threshold>>|min=0 max=2347|$FORM_rts_threshold
EOF
equal "$?" 0 && {
uci set wireless.advance.fr_threshold=$FORM_fr_threshold
uci set wireless.advance.rts_threshold=$FORM_rts_threshold
}
fi

! empty "$FORM_show_ap" && {
	i=$FORM_show_ap
	FORM_ssid=${ssid:-$(uci get wireless.iface$i.ssid)}
	FORM_hidden=${hidden:-$(uci get wireless.iface$i.hidden)}
}

! empty "$FORM_save_ap" && {
i=$FORM_iface_id
SAVED=1
validate <<EOF
hostname|FORM_ssid|@TR<<ESSID>>|required|$FORM_ssid
EOF
equal "$?" 0 && {
uci set wireless.iface$i.ssid=$FORM_ssid
uci set wireless.iface$i.hidden=$FORM_hidden
}
}

! empty "$FORM_enable_ap" && {
uci set wireless.iface$FORM_enable_ap.disabled="0"
}

! empty "$FORM_disable_ap" && {
uci set wireless.iface$FORM_disable_ap.disabled="1"
}

#####################################################################
# modechange script
#
header "Network" "Wireless-advance" "@TR<<Wireless Advance Configuration>>" 'onload="modechange()"' 

display_form <<EOF
start_form
formtag_begin|save_advance|$SCRIPT_NAME
field|@TR<<Fragmentation Threshold>>|fr_threshold
text|fr_threshold|$FORM_fr_threshold
field|@TR<<RTS Threshold>>|rts_threshold
text|rts_threshold|$FORM_rts_threshold
field||spacer1
string|<br />
submit|save_advance|@TR<<Save>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF

type=`uci get wireless.general.type`
cardtype=`uci get wireless.$type.type`
if [ "$cardtype" != "metalink" ]; then
#display_form <<EOF
#start_form|@TR<<Virtual Access Points>>
#end_form
#EOF
echo "<div class=\"settings\">"
echo "<h3><strong>Virtual Access Points:</strong></h3>"
echo "<table style=\"width: 70%; text-align: left;\" align=\"center\"><tr class=\"odd\"><th>Interface ID</th><th>ESSID</th><th>Action</th></tr>"
for i in 1 2 3; do
device=`uci get wireless.iface$i.device`
ssid=`uci get wireless.iface$i.ssid`
iface=`uci get wireless.iface$i.iface`
disabled=`uci get wireless.iface$i.disabled`

if [ "$disabled" = "0" ]; then
echo "<tr style=\"color: #114488; font-weight: bold;\"><td>$iface</td><td>$ssid</td><td><a href=\"$SCRIPT_NAME?show_ap=$i\">@TR<<edit>></a>/<a href=\"$SCRIPT_NAME?disable_ap=$i\">@TR<<Disable>></a></td></tr>"
else
echo "<tr  class=\"tr_bg\" align=\"center\"><td>$iface</td><td>$ssid</td><td><a href=\"$SCRIPT_NAME?enable_ap=$i\">@TR<<<img alt=\"@TR<<enable>>\" src=\"/images/enable.gif\" title=\"@TR<<enable>>\" /></a></td></tr>"
fi
done
echo "</table><br></div>"
fi

! empty "$FORM_show_ap" && {

display_form <<EOF
start_form|@TR<<Configure Virtual Access point $FORM_show_ap >>
formtag_begin|save_ap|$SCRIPT_NAME
field|@TR<<Interface ID>>
text|iface_id|$FORM_show_ap|||readonly
field|@TR<<ESSID>>|ssid
text|ssid|$FORM_ssid
field|@TR<<ESSID Broadcast>>|broadcast
select|broadcast|$FORM_hidden
option|1|@TR<<Show>>
option|0|@TR<<Hide>>
field||spacer1
string|<br />
submit|save_ap|@TR<<Save>>
submit||@TR<<Cancel>>
formtag_end
end_form
EOF
}

footer ?>
<!--
##WEBIF:name:xNetwork:350:Wireless-advance
-->
