#!/usr/bin/webif-page
<?
#
#
. /usr/lib/webif/webif.sh

uci_load network
uci_load asterisk
uci_load wireless
uci_load bridge

config_get wan_proto wan proto
wan_ifname="undefined"
[ "$wan_proto" = "dhcp" -o "$wan_proto" = "static" ] && wan_ifname="eth0"
[ "$wan_proto" = "pppoe" ] && wan_ifname="ppp0"
wan_config=$(ifconfig -a 2>&1 | grep -A 8 "$wan_ifname[[:space:]]")
[ -n "$wan_config" ] && {
#  wan_ifname="ppp0"
#  wan_config="inet addr:1.1.1.1  P-t-P:1.1.1.2  Mask:255.255.255.255"
  [ "$wan_ifname" = "eth0" ] && {
    wan_ip_addr=$(echo "$wan_config" | grep "inet addr" | cut -d: -f 2 | sed s/Bcast//g)
    wan_gateway=$(ip route show 0.0.0.0/0  | cut -d\  -f3)
  }
  [ "$wan_ifname" = "ppp0" ] && {
    wan_ip_addr=$(echo "$wan_config" | grep "inet addr" | cut -d: -f 2 | sed s/P-t-P//g)
    wan_gateway=$(echo "$wan_config" | grep "inet addr" | cut -d: -f 3 | sed s/Mask//g)
#    wan_gateway=$(ip route show 0.0.0.0/0  | cut -d\  -f3)
  }
  wan_netmask=$(echo "$wan_config" | grep "Mask" | cut -d'M' -f 2 | cut -d':' -f 2)
  wan_mac_addr=$(echo "$wan_config" | grep "HWaddr" | cut -d'H' -f 2 | cut -d' ' -f 2)
  wan_connected=$(ethtool eth0 | awk ' /Link detected/ { print $3}')
} 
nat_enable=`uci get nat.general.nat`
config_get bridge_status general wan
wan_bridged="No"
[ "$bridge_status" = "1" ] && wan_bridged="Yes"
dns_servers=$(awk ' /nameserver/ {print $2}' /etc/ppp/resolv.conf 2> /dev/null)
dns_servers1=$(awk ' /nameserver/ {print $2}' /etc/resolv.conf 2> /dev/null | sed s/127.0.0.1//g)
dns_servers="$dns_servers $dns_servers1"
i=0
dns_srv=""
for temp in $dns_servers; do
  if [ $i != 0 ] ; then
    dns_srv="$dns_srv<b>,</b> $temp"
  else
    dns_srv="$temp" 
  fi 
  i=`expr $i + 1` 
done
                  

lan_config=$(ifconfig -a 2>&1 | grep -A 8 "$CONFIG_lan_ifname[[:space:]]")
[ -n "$lan_config" ] && {
  lan_ip_addr=$(echo "$lan_config" | grep "inet addr" | cut -d: -f 2 | sed s/Bcast//g)
  lan_netmask=$(echo "$lan_config" | grep "Mask" | cut -d'M' -f 2 | cut -d':' -f 2)
  lan_mac_addr=$(echo "$lan_config" | grep "HWaddr" | cut -d'H' -f 2 | cut -d' ' -f 2)
} 
config_get bridge_status general lan
lan_bridged="No"
lan_dhcp_server_status="Disabled"
[ "$bridge_status" = "1" ] && lan_bridged="Yes"
[ "$bridge_status" = "0" ] && {
  dhcp_server_config=$(ps ax | grep eth2)
  [ -n "$dhcp_server_config" ] && lan_dhcp_server_status="Enabled"
}

config_get wifi_found general found
[ "$wifi_found" -gt 0 ] && {
  config_get wifi_type general type
  wifi_ifname=$wifi_type
  [ "$wifi_type" = "wifi0" ] && wifi_ifname="ath0"
  wifi_config=$(ifconfig $wifi_ifname 2>&1 | grep -A 8 "$wifi_ifname[[:space:]]")
  [ -n "$wifi_config" ] && {
    wifi_ip_addr=$(echo "$wifi_config" | grep "inet addr" | cut -d: -f 2 | sed s/Bcast//g)
    wifi_netmask=$(echo "$wifi_config" | grep "Mask" | cut -d'M' -f 2 | cut -d':' -f 2)
    wifi_mac_addr=$(echo "$wifi_config" | grep "HWaddr" | cut -d'H' -f 2 | cut -d' ' -f 2)
  }
  config_get wifi_card_type $wifi_type type
  wifi_bridged="No"
  wifi_dhcp_server_status="Disabled"
  config_get bridge_status general wifi
  [ "$bridge_status" = "1" ] && wifi_bridged="Yes"
  [ "$bridge_status" = "0" ] && {
    dhcp_server_config=$(ps ax | grep $wifi_ifname)
    [ -n "$dhcp_server_config" ] && wifi_dhcp_server_status="Enabled"
  }
}

config_get pot1_number analog1 number
config_get pot2_number analog2 number
config_get pot3_number analog3 number
config_get pot4_number analog4 number

header "Status" "Connectivity" "@TR<<system_status_details#Connectivity>>" ' ' " "
?>
<div id="status_wrap">
<div class="status_block">
	<div class="settings">
		 <a href="network-wan.sh"><h3><strong>WAN:</strong></h3></a>
			  <div class="status_wan">
					<table width="96%" summary="Settings">
					  <tr>
						<td width="40%" class="odd">MAC Address</td>
						<td width="60%"  class="tr_bg"><? echo -n ${wan_mac_addr} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">IP Address</span><a href="network-wan.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${wan_ip_addr} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Netmask</span><a href="network-wan.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${wan_netmask} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Gateway</span><a href="network-wan.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${wan_gateway} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Connection Type</span><a href="network-wan.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${wan_proto} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Connected</span><a href="network-wan.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${wan_connected} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">NAT Enabled</span><a href="network-nat.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${nat_enable} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">DNS Servers</span><a href="network-wan.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${dns_srv} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Bridged</span><a href="network-bridge.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${wan_bridged} ?></td>
					  </tr>
					</table>
			  </div>
		  <div class="clearfix">&nbsp;</div>
	</div>
</div>

<div class="status_block">
	<div class="settings">
		 <a href="network-lan.sh"><h3><strong>LAN:</strong></h3></a>
			  <div class="status_lan">
					<table width="96%" summary="Settings">
					  <tr>
						<td width="40%" class="odd">MAC Address</td>
						<td width="60%" class="tr_bg"><? echo -n ${lan_mac_addr} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">IP Address</span><a href="network-lan.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${lan_ip_addr} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Netmask</span><a href="network-lan.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${lan_netmask} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">DHCP Server</span><a href="network-dhcpiface.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${lan_dhcp_server_status} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Bridged</span><a href="network-bridge.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${lan_bridged} ?></td>
					  </tr>
					</table>
			  </div>
		  <div class="clearfix">&nbsp;</div>
	</div>
</div>
<div class="status_block">
	<div class="settings">
		 <a href="network-wlan.sh"><a href="network-wlan.sh"><h3><strong>Wifi:</strong></h3></a>
			  <div class="status_wifi">
					<table width="96%" summary="Settings">
					  <tr>
						<td width="40%" class="odd">MAC Address</td>
						<td width="60%" class="tr_bg"><? echo -n ${wifi_mac_addr} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">IP Address</span><a href="network-wlan.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${wifi_ip_addr} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Netmask</span><a href="network-wlan.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${wifi_netmask} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">DHCP Server</span><a href="network-dhcpiface.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${wifi_dhcp_server_status} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd">Card Type</td>
						<td width="60%" class="tr_bg"><? echo -n ${wifi_card_type} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Bridged</span><a href="network-bridge.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${wifi_bridged} ?></td>
					  </tr>
					</table>
			  </div>
		  <div class="clearfix">&nbsp;</div>
	</div>
</div>

<div class="status_block">
	<div class="settings">
		 <a href="asterisk-extension.sh"><h3><strong>Voice:</strong></h3></a>
			  <div class="status_voice">
					<table width="96%" summary="Settings">
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Pots1</span><a href="asterisk-extension.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${pot1_number} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Pots2</span><a href="asterisk-extension.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${pot2_number} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Pots3</span><a href="asterisk-extension.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${pot3_number} ?></td>
					  </tr>
					  <tr>
						<td width="40%" class="odd"><span class="odd_status">Pots4</span><a href="asterisk-extension.sh"><img src="../../images/configure_new.gif" width="12px" height="13px" alt="configure" title="configure" /></a></td>
						<td width="60%" class="tr_bg"><? echo -n ${pot4_number} ?></td>
					  </tr>
					</table>
			  </div>
		  <div class="clearfix">&nbsp;</div>
	</div>
</div>
</div>
<? footer ?>
<!--
##WEBIF:name:Status:100:Connectivity
-->
