#!/bin/sh

show_table() {
	config_get physical $1 physical
	[ "$physical" == "eth0" ] || return

	config_get status $1 status
	[ "$status" == "enable" ] || return
	
	[ -e /tmp/dhcp6s/table_$1 ] && cat /tmp/dhcp6s/table_$1 |grep "#1##" |sed -e "s/^.*##/$1 /"
}

echo "DHCP6s Table"
echo -e "iface  IPv6 Address                             Start Time           End Time             DUID"
. /etc/functions.sh
config_load network
config_foreach show_table
[ -e /tmp/dhcp6s/dhcp6s_table ] && cat /tmp/dhcp6s/dhcp6s_table |grep "#1##" |sed -e "s/^.*##/undef/"
