#! /bin/sh
# A little script I whipped up to make it easy to
# patch source trees and have sane error handling
# -Erik
#
# (c) 2002 Erik Andersen <andersen@codepoet.org>

# Set directories from arguments, or use defaults.

curdir=$(pwd)
workdir=$(dirname ${1})
srcdir=$(basename ${1})
origdir=$(basename ${2})
preparedfile=${3}
destdir=${4}
destfile=${destdir}/zzz-draytek-$(basename ${curdir}).patch

mkdir -p ${destdir}
cd ${workdir}
if [ -e ${destfile} ]; then
    diff -urN --exclude=.svn --strip-trailing-cr ${origdir} ${srcdir} > ${destfile}.new
	count=$(diff ${destfile} ${destfile}.new | wc -l)
	if [ ${count} -eq 0 ]; then
		rm -f ${destfile}.new
	else
		rm -f ${destfile}
		mv ${destfile}.new ${destfile}
		rm -f ${preparedfile}
	fi
	cd ${curdir}
else
	diff -urN --exclude=.svn --strip-trailing-cr ${origdir} ${srcdir} > ${destfile}
	if [ ! -s ${destfile} ]; then
		rm -f ${preparedfile}
	fi
	cd ${curdir}
fi
if [ ! -s ${destfile} ]; then
	rm -f ${destfile}
fi


