#include <sys/ioctl.h>
#include <arpa/inet.h>
#include "../../../autoconf.h"
#ifdef CONFIG_DEFAULTS_KERNEL_2_6_21
#include <linux/types.h>
#include <linux/socket.h>
#include <linux/if.h>
#endif
#include <linux/wireless.h>
#include <linux/if_ether.h>
#include <linux/if_arp.h>

#include <string.h>

struct arpMsg {
	/* Ethernet header */
	uint8_t  h_dest[6];     /* 00 destination ether addr */
	uint8_t  h_source[6];   /* 06 source ether addr */
	uint16_t h_proto;       /* 0c packet type ID field */

	/* ARP packet */
	uint16_t htype;         /* 0e hardware type (must be ARPHRD_ETHER) */
	uint16_t ptype;         /* 10 protocol type (must be ETH_P_IP) */
	uint8_t  hlen;          /* 12 hardware address length (must be 6) */
	uint8_t  plen;          /* 13 protocol address length (must be 4) */
	uint16_t operation;     /* 14 ARP opcode */
	uint8_t  sHaddr[6];     /* 16 sender's hardware address */
	uint8_t  sInaddr[4];    /* 1c sender's IP address */
	uint8_t  tHaddr[6];     /* 20 target's hardware address */
	uint8_t  tInaddr[4];    /* 26 target's IP address */
	uint8_t  pad[18];       /* 2a pad for min. ethernet payload (60 bytes) */
} PACKED;

#define RTPRIV_IOCTL_XMIT_DATA_PKT	    (SIOCIWFIRSTPRIV + 0x1D)

extern int apcli_sta_sock;

extern int apcli_sta_sock_ioctl(int cmd, void* arg);

int arp_req(char* if_name, unsigned char* if_mac, unsigned int requestedip, unsigned int serverip)
{
    struct iwreq iwr;
    struct arpMsg arp;
    int res = 0;

	strncpy(iwr.ifr_name, if_name, IFNAMSIZ);
	iwr.u.data.pointer = (void*) &arp;
    iwr.u.data.length = sizeof(struct arpMsg);

    /* send arp request */
	memset(&arp, 0, sizeof(arp));
	memset(arp.h_dest, 0xff, 6);            /* MAC DA */
	memcpy(arp.h_source, if_mac, 6);        /* MAC SA */
	arp.h_proto = htons(ETH_P_ARP);         /* protocol type (Ethernet) */
	arp.htype = htons(ARPHRD_ETHER);        /* hardware type */
	arp.ptype = htons(ETH_P_IP);            /* protocol type (ARP message) */
	arp.hlen = 6;                           /* hardware address length */
	arp.plen = 4;                           /* protocol address length */
	arp.operation = htons(ARPOP_REQUEST);   /* ARP op code */
	memcpy(arp.sHaddr, if_mac, 6);          /* source hardware address */
	memcpy(arp.sInaddr, &requestedip, 4);   /* source IP address */
	/* tHaddr is zero-fiiled */             /* target hardware address */
	memcpy(arp.tInaddr, &serverip, 4);      /* target IP address */

    res = apcli_sta_sock_ioctl(RTPRIV_IOCTL_XMIT_DATA_PKT, (void *)&iwr);

    return res;
}

