#!/bin/sh

wanmode=`nvram_get 2860 wanConnectionMode`
ACTION=$1
PRODUCT=$2
#set USB LED
/sbin/usb_led_ctrl.sh
case "$ACTION" in
	add)
		#set USB device mode switch first
		/bin/draytek_hsdpa ${PRODUCT}
		if [ "$wanmode" = "3G" ]; then
			DEV3G=$(nvram_get 2860 wan_dev)
			if [ "$DEV3G" != "" ]; then
				TEST=$(comgt -d $DEV3G -s /etc_ro/ppp/3g/getstrength.gcom | grep "Can't open device")
			else
				TEST=$(comgt | grep "Unable to locate default")
			fi
	
			if [ "$TEST" != "" ]; then
				echo "3G device not exist........."
				exit 1
			fi
			INUSE=$(nvram_get 2860 wan_3gdev)
			if [ "$INUSE" == "" ]; then
				echo "USB 3G $PRODUCT connected!!!!"
				echo "SUCCESS!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
				/sbin/internet.sh
				nvram_set 2860 wan_3gdev ${PRODUCT}
			fi
	
		fi
		;;
	del)
		#clean USB product
		
		# remove Sony Ericson MD300 so setup configuration back to default
		if [ ${PRODUCT} == "fce/d0cf/0" ]; then
			nvram_set 2860 wan_dev "/dev/ttyUSB0"
			#uci -q set network.3gwan.device=/dev/ttyUSB0
			nvram_set 2860 wan_init_string2 "ATE0V1X1&D2&C1S0=0"
			#uci -q set network.3gwan.init_string2='ATE0V1X1&D2&C1S0=0'
			uci commit network
		fi
		
		# removed device is 3g device
		INUSE=$(nvram_get 2860 wan_3gdev)
		[ ${PRODUCT} == "$INUSE" ] && {
			echo "USB 3G device $PRODUCT removed!!!!"
			killall pppd
			nvram_set 2860 wan_3gdev ""
			exit 1
		}
		
		#wait a little time to make sure that device is disconnect
		sleep 2
		
		#unknown 3G device case. 
		if [ "$wanmode" = "3G" ] && [ "$INUSE" != "" ]; then
			DEV=$(nvram_get 2860 wan_dev)
	  		if [ "$DEV" != "" ]; then
				TEST=$(comgt -d "$DEV" -s /etc_ro/ppp/3g/getstrength.gcom | grep "Can't open device")
			else
				TEST=$(comgt | grep "Unable to locate default")
			fi
	
			if [ "$TEST" != "" ]; then
				echo "USB 3G device $PRODUCT removed!!!!"
				killall pppd
				nvram_set 2860 wan_3gdev ""
			fi
		fi
		
esac