/*
 * Copyright (c) 2013 Qualcomm Atheros, Inc.
 * All Rights Reserved.
 * Qualcomm Atheros Confidential and Proprietary.
 */

//==============================================================================
// Target register table macros and structure definitions
//
// Author(s): ="Atheros"
//==============================================================================

#ifndef HOST_REG_TABLE_H_
#define HOST_REG_TABLE_H_

#include "targaddrs.h"
/*** WARNING : Add to the end of the TABLE! do not change the order ****/
typedef struct hostdef_s {
    A_UINT32 d_INT_STATUS_ENABLE_ERROR_LSB;
    A_UINT32 d_INT_STATUS_ENABLE_ERROR_MASK;
    A_UINT32 d_INT_STATUS_ENABLE_CPU_LSB;
    A_UINT32 d_INT_STATUS_ENABLE_CPU_MASK;
    A_UINT32 d_INT_STATUS_ENABLE_COUNTER_LSB;
    A_UINT32 d_INT_STATUS_ENABLE_COUNTER_MASK;
    A_UINT32 d_INT_STATUS_ENABLE_MBOX_DATA_LSB;
    A_UINT32 d_INT_STATUS_ENABLE_MBOX_DATA_MASK;
    A_UINT32 d_ERROR_STATUS_ENABLE_RX_UNDERFLOW_LSB;
    A_UINT32 d_ERROR_STATUS_ENABLE_RX_UNDERFLOW_MASK;
    A_UINT32 d_ERROR_STATUS_ENABLE_TX_OVERFLOW_LSB;
    A_UINT32 d_ERROR_STATUS_ENABLE_TX_OVERFLOW_MASK;
    A_UINT32 d_COUNTER_INT_STATUS_ENABLE_BIT_LSB;
    A_UINT32 d_COUNTER_INT_STATUS_ENABLE_BIT_MASK;
    A_UINT32 d_INT_STATUS_ENABLE_ADDRESS;                  
    A_UINT32 d_CPU_INT_STATUS_ENABLE_BIT_LSB;
    A_UINT32 d_CPU_INT_STATUS_ENABLE_BIT_MASK;
    A_UINT32 d_HOST_INT_STATUS_ADDRESS;
    A_UINT32 d_CPU_INT_STATUS_ADDRESS;
    A_UINT32 d_ERROR_INT_STATUS_ADDRESS;
    A_UINT32 d_ERROR_INT_STATUS_WAKEUP_MASK;
    A_UINT32 d_ERROR_INT_STATUS_WAKEUP_LSB;
    A_UINT32 d_ERROR_INT_STATUS_RX_UNDERFLOW_MASK;
    A_UINT32 d_ERROR_INT_STATUS_RX_UNDERFLOW_LSB;
    A_UINT32 d_ERROR_INT_STATUS_TX_OVERFLOW_MASK;
    A_UINT32 d_ERROR_INT_STATUS_TX_OVERFLOW_LSB;
    A_UINT32 d_COUNT_DEC_ADDRESS;
    A_UINT32 d_HOST_INT_STATUS_CPU_MASK; 
    A_UINT32 d_HOST_INT_STATUS_CPU_LSB;
    A_UINT32 d_HOST_INT_STATUS_ERROR_MASK;
    A_UINT32 d_HOST_INT_STATUS_ERROR_LSB;
    A_UINT32 d_HOST_INT_STATUS_COUNTER_MASK;
    A_UINT32 d_HOST_INT_STATUS_COUNTER_LSB;
    A_UINT32 d_RX_LOOKAHEAD_VALID_ADDRESS;
    A_UINT32 d_WINDOW_DATA_ADDRESS;
    A_UINT32 d_WINDOW_READ_ADDR_ADDRESS;
    A_UINT32 d_WINDOW_WRITE_ADDR_ADDRESS;
    A_UINT32 d_SOC_GLOBAL_RESET_ADDRESS;
    A_UINT32 d_RTC_STATE_ADDRESS;
    A_UINT32 d_RTC_STATE_COLD_RESET_MASK;
    A_UINT32 d_PCIE_LOCAL_BASE_ADDRESS;
    A_UINT32 d_PCIE_SOC_WAKE_RESET;
    A_UINT32 d_PCIE_SOC_WAKE_ADDRESS;
    A_UINT32 d_PCIE_SOC_WAKE_V_MASK;
    A_UINT32 d_RTC_STATE_V_MASK;
    A_UINT32 d_RTC_STATE_V_LSB;
    A_UINT32 d_FW_IND_EVENT_PENDING;
    A_UINT32 d_FW_IND_INITIALIZED;
    A_UINT32 d_RTC_STATE_V_ON;
#if defined(SDIO_3_0)
    A_UINT32 d_HOST_INT_STATUS_MBOX_DATA_MASK;
    A_UINT32 d_HOST_INT_STATUS_MBOX_DATA_LSB;
#endif
} HOST_REGISTER_TABLE;

#if defined(MY_HOST_DEF) /* { */
#if defined(ATHR_WIN_DEF)
#define ATH_REG_TABLE_DIRECT_ASSIGN
#endif

#if !defined(PCIE_LOCAL_BASE_ADDRESS)
#define PCIE_LOCAL_BASE_ADDRESS 0
#define PCIE_SOC_WAKE_RESET 0
#define PCIE_SOC_WAKE_ADDRESS 0
#define PCIE_SOC_WAKE_V_MASK 0
#define RTC_STATE_ADDRESS 0
#define RTC_STATE_COLD_RESET_MASK 0
#define RTC_STATE_V_MASK 0
#define RTC_STATE_V_LSB 0
#define RTC_STATE_V_ON 0
#define SOC_GLOBAL_RESET_ADDRESS 0
#endif

#if !defined(FW_IND_EVENT_PENDING)
#define FW_IND_EVENT_PENDING 0
#define FW_IND_INITIALIZED 0
#endif


#ifdef ATH_REG_TABLE_DIRECT_ASSIGN

static struct hostdef_s my_host_def = {
    INT_STATUS_ENABLE_ERROR_LSB,
    INT_STATUS_ENABLE_ERROR_MASK,
    INT_STATUS_ENABLE_CPU_LSB,
    INT_STATUS_ENABLE_CPU_MASK,
    INT_STATUS_ENABLE_COUNTER_LSB,
    INT_STATUS_ENABLE_COUNTER_MASK,
    INT_STATUS_ENABLE_MBOX_DATA_LSB,
    INT_STATUS_ENABLE_MBOX_DATA_MASK,
    ERROR_STATUS_ENABLE_RX_UNDERFLOW_LSB,
    ERROR_STATUS_ENABLE_RX_UNDERFLOW_MASK,
    ERROR_STATUS_ENABLE_TX_OVERFLOW_LSB,
    ERROR_STATUS_ENABLE_TX_OVERFLOW_MASK,
    COUNTER_INT_STATUS_ENABLE_BIT_LSB,
    COUNTER_INT_STATUS_ENABLE_BIT_MASK,
    INT_STATUS_ENABLE_ADDRESS, 
    CPU_INT_STATUS_ENABLE_BIT_LSB,
    CPU_INT_STATUS_ENABLE_BIT_MASK,
    HOST_INT_STATUS_ADDRESS,
    CPU_INT_STATUS_ADDRESS,
    ERROR_INT_STATUS_ADDRESS,
    ERROR_INT_STATUS_WAKEUP_MASK,
    ERROR_INT_STATUS_WAKEUP_LSB,
    ERROR_INT_STATUS_RX_UNDERFLOW_MASK,
    ERROR_INT_STATUS_RX_UNDERFLOW_LSB,
    ERROR_INT_STATUS_TX_OVERFLOW_MASK,
    ERROR_INT_STATUS_TX_OVERFLOW_LSB,
    COUNT_DEC_ADDRESS,
    HOST_INT_STATUS_CPU_MASK, 
    HOST_INT_STATUS_CPU_LSB,
    HOST_INT_STATUS_ERROR_MASK,
    HOST_INT_STATUS_ERROR_LSB,
    HOST_INT_STATUS_COUNTER_MASK,
    HOST_INT_STATUS_COUNTER_LSB,
    RX_LOOKAHEAD_VALID_ADDRESS,
    WINDOW_DATA_ADDRESS,
    WINDOW_READ_ADDR_ADDRESS,
    WINDOW_WRITE_ADDR_ADDRESS,
    SOC_GLOBAL_RESET_ADDRESS,
    RTC_STATE_ADDRESS,
    RTC_STATE_COLD_RESET_MASK,
    PCIE_LOCAL_BASE_ADDRESS,
    PCIE_SOC_WAKE_RESET,
    PCIE_SOC_WAKE_ADDRESS,
    PCIE_SOC_WAKE_V_MASK,
    RTC_STATE_V_MASK,
    RTC_STATE_V_LSB,
    FW_IND_EVENT_PENDING,
    FW_IND_INITIALIZED,
    RTC_STATE_V_ON,
#if defined(SDIO_3_0)
    HOST_INT_STATUS_MBOX_DATA_MASK,
    HOST_INT_STATUS_MBOX_DATA_LSB,
#endif
};

#else

static struct hostdef_s my_host_def = {
    .d_INT_STATUS_ENABLE_ERROR_LSB = INT_STATUS_ENABLE_ERROR_LSB,
    .d_INT_STATUS_ENABLE_ERROR_MASK = INT_STATUS_ENABLE_ERROR_MASK,
    .d_INT_STATUS_ENABLE_CPU_LSB = INT_STATUS_ENABLE_CPU_LSB,
    .d_INT_STATUS_ENABLE_CPU_MASK = INT_STATUS_ENABLE_CPU_MASK,
    .d_INT_STATUS_ENABLE_COUNTER_LSB = INT_STATUS_ENABLE_COUNTER_LSB,
    .d_INT_STATUS_ENABLE_COUNTER_MASK = INT_STATUS_ENABLE_COUNTER_MASK,
    .d_INT_STATUS_ENABLE_MBOX_DATA_LSB = INT_STATUS_ENABLE_MBOX_DATA_LSB,
    .d_INT_STATUS_ENABLE_MBOX_DATA_MASK = INT_STATUS_ENABLE_MBOX_DATA_MASK,
    .d_ERROR_STATUS_ENABLE_RX_UNDERFLOW_LSB = ERROR_STATUS_ENABLE_RX_UNDERFLOW_LSB,
    .d_ERROR_STATUS_ENABLE_RX_UNDERFLOW_MASK = ERROR_STATUS_ENABLE_RX_UNDERFLOW_MASK,
    .d_ERROR_STATUS_ENABLE_TX_OVERFLOW_LSB = ERROR_STATUS_ENABLE_TX_OVERFLOW_LSB,
    .d_ERROR_STATUS_ENABLE_TX_OVERFLOW_MASK = ERROR_STATUS_ENABLE_TX_OVERFLOW_MASK,
    .d_COUNTER_INT_STATUS_ENABLE_BIT_LSB = COUNTER_INT_STATUS_ENABLE_BIT_LSB,
    .d_COUNTER_INT_STATUS_ENABLE_BIT_MASK = COUNTER_INT_STATUS_ENABLE_BIT_MASK,
    .d_INT_STATUS_ENABLE_ADDRESS = INT_STATUS_ENABLE_ADDRESS,             
    .d_CPU_INT_STATUS_ENABLE_BIT_LSB = CPU_INT_STATUS_ENABLE_BIT_LSB,
    .d_CPU_INT_STATUS_ENABLE_BIT_MASK = CPU_INT_STATUS_ENABLE_BIT_MASK,
    .d_HOST_INT_STATUS_ADDRESS = HOST_INT_STATUS_ADDRESS,          
    .d_CPU_INT_STATUS_ADDRESS = CPU_INT_STATUS_ADDRESS,
    .d_ERROR_INT_STATUS_ADDRESS = ERROR_INT_STATUS_ADDRESS,
    .d_ERROR_INT_STATUS_WAKEUP_MASK = ERROR_INT_STATUS_WAKEUP_MASK,
    .d_ERROR_INT_STATUS_WAKEUP_LSB = ERROR_INT_STATUS_WAKEUP_LSB,
    .d_ERROR_INT_STATUS_RX_UNDERFLOW_MASK = ERROR_INT_STATUS_RX_UNDERFLOW_MASK,
    .d_ERROR_INT_STATUS_RX_UNDERFLOW_LSB = ERROR_INT_STATUS_RX_UNDERFLOW_LSB,
    .d_ERROR_INT_STATUS_TX_OVERFLOW_MASK = ERROR_INT_STATUS_TX_OVERFLOW_MASK,
    .d_ERROR_INT_STATUS_TX_OVERFLOW_LSB = ERROR_INT_STATUS_TX_OVERFLOW_LSB,
    .d_COUNT_DEC_ADDRESS = COUNT_DEC_ADDRESS,
    .d_HOST_INT_STATUS_CPU_MASK = HOST_INT_STATUS_CPU_MASK, 
    .d_HOST_INT_STATUS_CPU_LSB = HOST_INT_STATUS_CPU_LSB,
    .d_HOST_INT_STATUS_ERROR_MASK = HOST_INT_STATUS_ERROR_MASK,
    .d_HOST_INT_STATUS_ERROR_LSB = HOST_INT_STATUS_ERROR_LSB,
    .d_HOST_INT_STATUS_COUNTER_MASK = HOST_INT_STATUS_COUNTER_MASK,
    .d_HOST_INT_STATUS_COUNTER_LSB = HOST_INT_STATUS_COUNTER_LSB,
    .d_RX_LOOKAHEAD_VALID_ADDRESS = RX_LOOKAHEAD_VALID_ADDRESS,
    .d_WINDOW_DATA_ADDRESS = WINDOW_DATA_ADDRESS,
    .d_WINDOW_READ_ADDR_ADDRESS = WINDOW_READ_ADDR_ADDRESS,
    .d_WINDOW_WRITE_ADDR_ADDRESS = WINDOW_WRITE_ADDR_ADDRESS,
    .d_SOC_GLOBAL_RESET_ADDRESS = SOC_GLOBAL_RESET_ADDRESS,
    .d_RTC_STATE_ADDRESS = RTC_STATE_ADDRESS,
    .d_RTC_STATE_COLD_RESET_MASK = RTC_STATE_COLD_RESET_MASK,
    .d_PCIE_LOCAL_BASE_ADDRESS = PCIE_LOCAL_BASE_ADDRESS,
    .d_PCIE_SOC_WAKE_RESET = PCIE_SOC_WAKE_RESET,
    .d_PCIE_SOC_WAKE_ADDRESS = PCIE_SOC_WAKE_ADDRESS,
    .d_PCIE_SOC_WAKE_V_MASK = PCIE_SOC_WAKE_V_MASK,
    .d_RTC_STATE_V_MASK = RTC_STATE_V_MASK,
    .d_RTC_STATE_V_LSB = RTC_STATE_V_LSB,
    .d_FW_IND_EVENT_PENDING = FW_IND_EVENT_PENDING,
    .d_FW_IND_INITIALIZED = FW_IND_INITIALIZED,
    .d_RTC_STATE_V_ON = RTC_STATE_V_ON,
#if defined(SDIO_3_0)
    .d_HOST_INT_STATUS_MBOX_DATA_MASK = HOST_INT_STATUS_MBOX_DATA_MASK,
    .d_HOST_INT_STATUS_MBOX_DATA_LSB = HOST_INT_STATUS_MBOX_DATA_LSB,
#endif
};

#endif

struct hostdef_s *MY_HOST_DEF = &my_host_def;

#else /* } { */

#define INT_STATUS_ENABLE_ERROR_LSB              (ath_hostdef->d_INT_STATUS_ENABLE_ERROR_LSB)
#define INT_STATUS_ENABLE_ERROR_MASK             (ath_hostdef->d_INT_STATUS_ENABLE_ERROR_MASK)
#define INT_STATUS_ENABLE_CPU_LSB                (ath_hostdef->d_INT_STATUS_ENABLE_CPU_LSB)
#define INT_STATUS_ENABLE_CPU_MASK               (ath_hostdef->d_INT_STATUS_ENABLE_CPU_MASK)
#define INT_STATUS_ENABLE_COUNTER_LSB            (ath_hostdef->d_INT_STATUS_ENABLE_COUNTER_LSB)
#define INT_STATUS_ENABLE_COUNTER_MASK           (ath_hostdef->d_INT_STATUS_ENABLE_COUNTER_MASK)
#define INT_STATUS_ENABLE_MBOX_DATA_LSB          (ath_hostdef->d_INT_STATUS_ENABLE_MBOX_DATA_LSB)
#define INT_STATUS_ENABLE_MBOX_DATA_MASK         (ath_hostdef->d_INT_STATUS_ENABLE_MBOX_DATA_MASK)
#define ERROR_STATUS_ENABLE_RX_UNDERFLOW_LSB     (ath_hostdef->d_ERROR_STATUS_ENABLE_RX_UNDERFLOW_LSB)
#define ERROR_STATUS_ENABLE_RX_UNDERFLOW_MASK    (ath_hostdef->d_ERROR_STATUS_ENABLE_RX_UNDERFLOW_MASK)
#define ERROR_STATUS_ENABLE_TX_OVERFLOW_LSB      (ath_hostdef->d_ERROR_STATUS_ENABLE_TX_OVERFLOW_LSB)
#define ERROR_STATUS_ENABLE_TX_OVERFLOW_MASK     (ath_hostdef->d_ERROR_STATUS_ENABLE_TX_OVERFLOW_MASK)
#define COUNTER_INT_STATUS_ENABLE_BIT_LSB        (ath_hostdef->d_COUNTER_INT_STATUS_ENABLE_BIT_LSB)
#define COUNTER_INT_STATUS_ENABLE_BIT_MASK       (ath_hostdef->d_COUNTER_INT_STATUS_ENABLE_BIT_MASK)
#define INT_STATUS_ENABLE_ADDRESS                (ath_hostdef->d_INT_STATUS_ENABLE_ADDRESS)                    
#define CPU_INT_STATUS_ENABLE_BIT_LSB            (ath_hostdef->d_CPU_INT_STATUS_ENABLE_BIT_LSB)
#define CPU_INT_STATUS_ENABLE_BIT_MASK           (ath_hostdef->d_CPU_INT_STATUS_ENABLE_BIT_MASK)
#define HOST_INT_STATUS_ADDRESS                  (ath_hostdef->d_HOST_INT_STATUS_ADDRESS)
#define CPU_INT_STATUS_ADDRESS                   (ath_hostdef->d_CPU_INT_STATUS_ADDRESS)
#define ERROR_INT_STATUS_ADDRESS                 (ath_hostdef->d_ERROR_INT_STATUS_ADDRESS)
#define ERROR_INT_STATUS_WAKEUP_MASK             (ath_hostdef->d_ERROR_INT_STATUS_WAKEUP_MASK)
#define ERROR_INT_STATUS_WAKEUP_LSB              (ath_hostdef->d_ERROR_INT_STATUS_WAKEUP_LSB)
#define ERROR_INT_STATUS_RX_UNDERFLOW_MASK       (ath_hostdef->d_ERROR_INT_STATUS_RX_UNDERFLOW_MASK)
#define ERROR_INT_STATUS_RX_UNDERFLOW_LSB        (ath_hostdef->d_ERROR_INT_STATUS_RX_UNDERFLOW_LSB)
#define ERROR_INT_STATUS_TX_OVERFLOW_MASK        (ath_hostdef->d_ERROR_INT_STATUS_TX_OVERFLOW_MASK)
#define ERROR_INT_STATUS_TX_OVERFLOW_LSB         (ath_hostdef->d_ERROR_INT_STATUS_TX_OVERFLOW_LSB)
#define COUNT_DEC_ADDRESS                        (ath_hostdef->d_COUNT_DEC_ADDRESS)
#define HOST_INT_STATUS_CPU_MASK                 (ath_hostdef->d_HOST_INT_STATUS_CPU_MASK) 
#define HOST_INT_STATUS_CPU_LSB                  (ath_hostdef->d_HOST_INT_STATUS_CPU_LSB)
#define HOST_INT_STATUS_ERROR_MASK               (ath_hostdef->d_HOST_INT_STATUS_ERROR_MASK)
#define HOST_INT_STATUS_ERROR_LSB                (ath_hostdef->d_HOST_INT_STATUS_ERROR_LSB)
#define HOST_INT_STATUS_COUNTER_MASK             (ath_hostdef->d_HOST_INT_STATUS_COUNTER_MASK)
#define HOST_INT_STATUS_COUNTER_LSB              (ath_hostdef->d_HOST_INT_STATUS_COUNTER_LSB)
#define RX_LOOKAHEAD_VALID_ADDRESS               (ath_hostdef->d_RX_LOOKAHEAD_VALID_ADDRESS)
#define WINDOW_DATA_ADDRESS                      (ath_hostdef->d_WINDOW_DATA_ADDRESS)
#define WINDOW_READ_ADDR_ADDRESS                 (ath_hostdef->d_WINDOW_READ_ADDR_ADDRESS)
#define WINDOW_WRITE_ADDR_ADDRESS                (ath_hostdef->d_WINDOW_WRITE_ADDR_ADDRESS)
#define SOC_GLOBAL_RESET_ADDRESS                 (ath_hostdef->d_SOC_GLOBAL_RESET_ADDRESS)
#define RTC_STATE_ADDRESS                        (ath_hostdef->d_RTC_STATE_ADDRESS)
#define RTC_STATE_COLD_RESET_MASK                (ath_hostdef->d_RTC_STATE_COLD_RESET_MASK)
#define PCIE_LOCAL_BASE_ADDRESS                  (ath_hostdef->d_PCIE_LOCAL_BASE_ADDRESS)
#define PCIE_SOC_WAKE_RESET                      (ath_hostdef->d_PCIE_SOC_WAKE_RESET)
#define PCIE_SOC_WAKE_ADDRESS                    (ath_hostdef->d_PCIE_SOC_WAKE_ADDRESS)
#define PCIE_SOC_WAKE_V_MASK                     (ath_hostdef->d_PCIE_SOC_WAKE_V_MASK)
#define RTC_STATE_V_MASK                         (ath_hostdef->d_RTC_STATE_V_MASK)
#define RTC_STATE_V_LSB                          (ath_hostdef->d_RTC_STATE_V_LSB)
#define FW_IND_EVENT_PENDING                     (ath_hostdef->d_FW_IND_EVENT_PENDING)
#define FW_IND_INITIALIZED                       (ath_hostdef->d_FW_IND_INITIALIZED)
#define RTC_STATE_V_ON                           (ath_hostdef->d_RTC_STATE_V_ON)
#if defined(SDIO_3_0)
#define HOST_INT_STATUS_MBOX_DATA_MASK           (ath_hostdef->d_HOST_INT_STATUS_MBOX_DATA_MASK)
#define HOST_INT_STATUS_MBOX_DATA_LSB            (ath_hostdef->d_HOST_INT_STATUS_MBOX_DATA_LSB)
#endif

/* SET/GET macros */
#define INT_STATUS_ENABLE_ERROR_SET(x) (((x) << INT_STATUS_ENABLE_ERROR_LSB) & INT_STATUS_ENABLE_ERROR_MASK)
#define INT_STATUS_ENABLE_CPU_SET(x) (((x) << INT_STATUS_ENABLE_CPU_LSB) & INT_STATUS_ENABLE_CPU_MASK)
#define INT_STATUS_ENABLE_COUNTER_SET(x) (((x) << INT_STATUS_ENABLE_COUNTER_LSB) & INT_STATUS_ENABLE_COUNTER_MASK)
#define INT_STATUS_ENABLE_MBOX_DATA_SET(x) (((x) << INT_STATUS_ENABLE_MBOX_DATA_LSB) & INT_STATUS_ENABLE_MBOX_DATA_MASK)
#define CPU_INT_STATUS_ENABLE_BIT_SET(x) (((x) << CPU_INT_STATUS_ENABLE_BIT_LSB) & CPU_INT_STATUS_ENABLE_BIT_MASK)
#define ERROR_STATUS_ENABLE_RX_UNDERFLOW_SET(x) (((x) << ERROR_STATUS_ENABLE_RX_UNDERFLOW_LSB) & ERROR_STATUS_ENABLE_RX_UNDERFLOW_MASK)
#define ERROR_STATUS_ENABLE_TX_OVERFLOW_SET(x) (((x) << ERROR_STATUS_ENABLE_TX_OVERFLOW_LSB) & ERROR_STATUS_ENABLE_TX_OVERFLOW_MASK)
#define COUNTER_INT_STATUS_ENABLE_BIT_SET(x) (((x) << COUNTER_INT_STATUS_ENABLE_BIT_LSB) & COUNTER_INT_STATUS_ENABLE_BIT_MASK)
#define ERROR_INT_STATUS_WAKEUP_GET(x) (((x) & ERROR_INT_STATUS_WAKEUP_MASK) >> ERROR_INT_STATUS_WAKEUP_LSB)
#define ERROR_INT_STATUS_RX_UNDERFLOW_GET(x) (((x) & ERROR_INT_STATUS_RX_UNDERFLOW_MASK) >> ERROR_INT_STATUS_RX_UNDERFLOW_LSB)
#define ERROR_INT_STATUS_TX_OVERFLOW_GET(x) (((x) & ERROR_INT_STATUS_TX_OVERFLOW_MASK) >> ERROR_INT_STATUS_TX_OVERFLOW_LSB)
#define HOST_INT_STATUS_CPU_GET(x) (((x) & HOST_INT_STATUS_CPU_MASK) >> HOST_INT_STATUS_CPU_LSB)
#define HOST_INT_STATUS_ERROR_GET(x) (((x) & HOST_INT_STATUS_ERROR_MASK) >> HOST_INT_STATUS_ERROR_LSB)
#define HOST_INT_STATUS_COUNTER_GET(x) (((x) & HOST_INT_STATUS_COUNTER_MASK) >> HOST_INT_STATUS_COUNTER_LSB)
#define RTC_STATE_V_GET(x) (((x) & RTC_STATE_V_MASK) >> RTC_STATE_V_LSB)
#if defined(SDIO_3_0)
#define HOST_INT_STATUS_MBOX_DATA_GET(x) (((x) & HOST_INT_STATUS_MBOX_DATA_MASK) >> HOST_INT_STATUS_MBOX_DATA_LSB)
#endif

extern struct hostdef_s *ath_hostdef;

#endif /* } */

#endif /*HOST_REG_TABLE_H_*/


