#!/usr/bin/perl
# translate TX Power Limit Matrix declarations to header files
#print $#ARGV;

# Slurp all the input
undef $/;
# Create an array of unsigned chars from input
#@flist = <STDIN>;
@flist = split(/ /, substr(<STDIN>,0,length(<STDIN>)-1));
@sorted = sort { $a <=> $b } @flist;
@sorted = sort { length($a) <=> length($b) } @flist;

$i = 1;
@rID; # regDomain
while ($i<=$#sorted) {
   my @str;
   @str = split(/_/, $sorted[$i]);
   $rID[$i]=$str[$#str];
   $i++;
}
$max_rID = $rID[$#rID];
print "// =========================================\n";
print "// TXPWR.h is auto-generated by tplmt2h.pl.\n";
print "// =========================================\n\n";
print "#ifndef _$sorted[0]_H\n#define _$sorted[0]_H\n";
print "#define $sorted[0]_MAX $max_rID\n";
foreach my $fname (@sorted)
{
   print "#include \"data_$fname.c\"\n";
}

print "unsigned char *data_$sorted[0]_array\[\]={\n";
$i = 0;
$j = 1;
while ($i <= $max_rID ) {
   if($i == $rID[$j]) {
      print "\tdata_$sorted[$j],\n";
      $j++;
   } 
   else {
      print "\tNULL,\n";
   }
   $i++;
}
print "};\n";

print "unsigned char *data_$sorted[0]_array_end\[\]={\n";
$i = 0;
$j = 1;
while ($i <= $max_rID ) {
   if($i == $rID[$j]) {
      print "\tdata_$sorted[$j]+sizeof(data_$sorted[$j]),\n";
      $j++;
   }
   else {
      print "\tNULL,\n";
   }
   $i++;
}
print "};\n";
print "#endif";

