<html>
<head>
<title>Temperature Sensor Setting</title>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1">
<meta http-equiv="Pragma" content="no-cache">
<meta http-equiv="Expires" content="-1">
<link rel="stylesheet" href="/style/normal_ws.css" type="text/css">
<script type="text/javascript" src="/lang/b28n.js"></script>
<script type="text/javascript" src="/dtree/tool.js"></script>
<script language="JavaScript" type="text/javascript">
Butterlate.setTextDomain("admin");

var arrTemperinfo = new Array();
var unit_init;
var f;

function initTranslation()
{
	var e = document.getElementById("temperTitle");
	e.innerHTML = _("parent application")+" >> "+_("temper sensor setting");
	e = document.getElementById("tab2");
	e.innerHTML = _("temper sensor settings");
	e = document.getElementById("tab1");
	e.innerHTML = _("temper chart");
	e = document.getElementById("TemerpSensorEn");
	e.innerHTML = _("enable temper sensor");
	e = document.getElementById("tempertitle_display");
	e.innerHTML = _("display temper settings");
	e = document.getElementById("temper_Calibration");
	e.innerHTML = _("temper calibration");
	e = document.getElementById("temper_Unit");
	e.innerHTML = _("temper unit");
	e = document.getElementById("temperunitC");
	e.innerHTML = _("temper celsius");
	e = document.getElementById("temperunitF");
	e.innerHTML = _("temper fahrenheit");
	e = document.getElementById("tempertitle_alarm");
	e.innerHTML = _("temper alarm settings");
//	e = document.getElementById("SyslogAlarmEn");
//	e.innerHTML = _("temper sys alarm enable");
	e = document.getElementById("temperUpperlmt");
	e.innerHTML = _("temper upper limit");
	e = document.getElementById("temperLowerlmt");
	e.innerHTML = _("temper lower limit");
}
function initValue()
{
	f=document.tempergen_form;
	var use_temper = '<% getCfgGeneral(1, "use_temper"); %>';
	if(use_temper == '')
		use_temper = '1,0.00,0,1,0,0.00,0.00';
	arrTemperinfo = use_temper.split(",");
	setVle2Elmt(f.chkTemperSenEn, 1, 0);
    setVle2Elmt(f.rdiTemperUnit[0], arrTemperinfo[2], 0);
    unit_init	= arrTemperinfo[2];
    setVle2Elmt(f.chkAlarmEnb, arrTemperinfo[3], 0);
	setVle2Elmt(f.chkAlertEnb, arrTemperinfo[4], 0);
	setVle2Elmt(f.txtTemperCal, arrTemperinfo[1], 0);
	setVle2Elmt(f.txtAlarmTos, arrTemperinfo[5], 0);
	setVle2Elmt(f.txtAlarmHYST, arrTemperinfo[6], 0);
    onChgUnit();
	initTranslation();
}
function onChgUnit()
{
	var unit = getVleFromElmt(f.rdiTemperUnit[0], 0);
	var lowerlimit = getVleFromElmt(f.txtAlarmHYST, 0);
	var upperlimit = getVleFromElmt(f.txtAlarmTos, 0);
	var iCal = getVleFromElmt(f.txtTemperCal, 0);
	if (unit == 0) {
		showElmtByClass(document,"span","iUnitC");
		hideElmtByClass(document,"span","iUnitF");
	} else {
		showElmtByClass(document,"span","iUnitF");
		hideElmtByClass(document,"span","iUnitC");
	}
	if (unit_init != unit) {
		unit_init = unit;
		if (unit == 0) {//F to C
			var l_tmp = (lowerlimit-32)*5.0/9.0;
			var u_tmp = (upperlimit-32)*5.0/9.0;
			var iCal_tmp = iCal*5.0/9.0;
		} else {//C to F
			var l_tmp = (9.0/5.0 * lowerlimit + 32.0);
			var u_tmp = (9.0/5.0 * upperlimit + 32.0);
			var iCal_tmp = 9.0/5.0 * iCal;

		}
		setVle2Elmt( f.txtAlarmTos, toDecimal(u_tmp),  0);
		setVle2Elmt( f.txtAlarmHYST, toDecimal(l_tmp),  0);
		setVle2Elmt( f.txtTemperCal, toDecimal(iCal_tmp),  0);
	}
}
function onChgAccMod(tab)
{
	if(tab == 1){
		document.location = "tempergenset.asp";
	}else if(tab == 2){
		document.location = "tempergraphic.asp";
	}
}
function toDecimal(x)
{
    var f = parseFloat(x);
    if (isNaN(f)) {
        return;
    }
    f = Math.round(x*100)/100;
    return f;
}
function temper_apply()
{
	var unit = getVleFromElmt(f.rdiTemperUnit[0], 0);
	var llimit = getVleFromElmt(f.txtAlarmHYST, 0);
	var ulimit = getVleFromElmt(f.txtAlarmTos, 0);
	var iCal = getVleFromElmt(f.txtTemperCal, 0);
	if (unit == 1) {
		var llimit = (llimit-32)*5.0/9.0;
		var ulimit = (ulimit-32)*5.0/9.0;
	}
	if (unit == 0){
		if (isNaN(iCal) || (parseInt(iCal) < -10) || (parseInt(iCal) > 10)) {
			alert(_("temper calibration range"));
			return false;
		}
	}else{
		if (isNaN(iCal) || (parseInt(iCal) < -40) || (parseInt(iCal) > 40)) {
			alert(_("temper calibration range"));
			return false;
		}
	}
	if (isNaN(llimit) || isNaN(ulimit) 	|| (parseInt(llimit) < -40) || (parseInt(ulimit) > 120)) {
		alert(_("temper limit range"));
		return false;
	}
	if( parseInt(ulimit) < parseInt(llimit) ){
		alert(_("temper limit comparation"));
		return false;
	}
	document.tempergen_form.submit();
}
</script>
</head>

<body onload="initValue()">
<table class="body">
<tr><td>
<h1 id="temperTitle">Temperature Sensor Setting</h1>
<hr size="1" />
<br />

<form name="tempergen_form" method="post" action="/goform/tempersensor_set">
<table width="700" cellspacing="0" cellpadding="2" border="0" align="center">
<tr>
  <td id="tab1" class="offtab" onclick="onChgAccMod(2)">Temperature Sensor Graph</td>
  <td id="tab2" class="ontab" onclick="onChgAccMod(1)">Temperature Sensor Settings</td>
  <td width="40%" class="tabpadding"></td>
</tr>
</table>

<table width="100%" cellspacing="2" cellpadding="2" border="0" align="center" class="config">
	<tr>
		<td>
			<table align="center" width="100%" border="0" cellspacing="0" cellpadding="0">
				<tr style="display:none">
					<td>
						<input type=checkbox value="1" id="chkTemperSenEn" name=chkTemperSenEn><label class="title" id="TemerpSensorEn">Enable Temperature Sensor</label>
					</td>
				</tr>
				<tr>
					<td class="title" id="tempertitle_display">Display Settings</td>
				</tr>
				<tr>
					<td id="temper_Calibration" width=40% style="text-indent: 2em">Calibration Offset</td>
					<td><input type=text name=txtTemperCal size=6><span class="iUnitC" style="display:none">&deg;C<font color=red>(-10 C ~ +10 C)</font></span><span class="iUnitF" style="display:none">&deg;F<font color=red>(-40 F ~ +40 F)</font></span></td>
				</tr>
				<tr>
					<td id="temper_Unit" width=40% style="text-indent: 2em">Temperature Unit</td>
					<td>
						<input type=radio name="rdiTemperUnit" value="0" onclick="onChgUnit()"><label id="temperunitC">Celsius</label>&nbsp;
						<input type=radio name="rdiTemperUnit" value="1" onclick="onChgUnit()"><label id="temperunitF">Fahrenheit</label>
					</td>
				</tr>
				<tr>
					<td class="title" id="tempertitle_alarm">Alarm Settings</td>
				</tr>
				<tr>
					<td colspan=9 style="text-indent: 2em">Enable:
						<input type=checkbox value="1" id="chkAlarmEnb" name=chkAlarmEnb> Syslog Alarm
						<input type=checkbox value="1" id="chkAlertEnb" name=chkAlertEnb> Mail Alert
					</td>
				</tr>
				<tr>
					<td id="temperUpperlmt" width=40% style="text-indent: 2em">High Alarm</td>
					<td><input type=text name="txtAlarmTos"><span class="iUnitC" style="display:none">&deg;C</span><span class="iUnitF" style="display:none">&deg;F</span></td>
				</tr>
				<br>
				<tr>
					<td id="temperLowerlmt" width=40% style="text-indent: 2em">Low Alarm</td>
					<td><input type=text name="txtAlarmHYST"><span class="iUnitC" style="display:none">&deg;C</span><span class="iUnitF" style="display:none">&deg;F</span></td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<br />
<table cellpadding="2" cellspacing="1" width="100%">
  <tr align="center"><td>
    <input type="button" value="OK" class="btnw" id="temperApply" onclick="temper_apply()" />
  </td></tr>
</table>
</form>

</td></tr>
</table>

</body>
</html>
