#######################################################################
#
# $Id: rules.mak,v 1.49.6.2.2.4 2006/07/06 16:42:57 aland Exp $
#
#  Each module should have a few common defines at the TOP of the
# Makefile, and the 'include ../rules.mak'
#
# e.g.
#
############################
# TARGET = rlm_foo
# SRCS   = rlm_foo.c other.c
#
# include ../rules.mak
#
# RLM_CFLAGS = my_cflags
# RLM_LDLAGS = my_ldflags
############################
#
# and everything will be automagically built
#
#######################################################################

include $(RLM_DIR)../../../Make.inc

.PHONY: all build-module clean distclean install reconfig

all: build-module

#######################################################################
#
#  definitions for new dependencies on suffixes
#
#######################################################################
.SUFFIXES: .lo .o .la .a

#######################################################################
#
# define libtool objects for the libraries,
# along with a number of other useful definitions.
#
#######################################################################
top_builddir	= $(ROOTDIR)/user/freeradius-1.1.6
LT_OBJS		+= $(SRCS:.c=.o)
LT_OBJS		+= $(SRCS:.cpp=.o)
CFLAGS		+= -I$(top_builddir)/src/include -I$(top_builddir)/src/libltdl

#######################################################################
#
# Ensure that the modules get re-built if the server header files
# change.
#
#######################################################################
SERVER_HEADERS	= $(top_builddir)/src/include/radius.h  \
		  $(top_builddir)/src/include/radiusd.h \
		  $(top_builddir)/src/include/modules.h

$(LT_OBJS): $(SERVER_HEADERS)

#######################################################################
#
# define new rules
#
#######################################################################
%.o: %.c
	$(CC) -D_LIBRADIUS -I../include $(CFLAGS) $(CPPFLAGS)$(RLM_CFLAGS) -c $<

%.o: %.cpp
	$(CXX) -D_LIBRADIUS -I../include $(CFLAGS) $(CPPFLAGS)$(RLM_CFLAGS) -c $<

ifneq ($(TARGET),)
#######################################################################
#
# Define a number of new targets
#
#######################################################################

#
#  If the module is in the list of static modules, then the "dynamic"
#  library is built statically, so that the '.la' file contains the
#  libraries that the module depends on.
#
#  Yes, this is a horrible hack.
#
ifeq ($(findstring $(TARGET),$(STATIC_MODULES)),)
LINK_MODE = -export-dynamic
else
LINK_MODE = -static
endif

#
#  Also, if we're NOT using shared libraries, then force the
#  link mode to static.
#
ifneq ($(USE_SHARED_LIBS),yes)
LINK_MODE = -static
endif

#######################################################################
#
#  Generic targets so we can sweep through all modules
# without knowing what their names are.
#
#  These rules also allow us to copy the '.a' or '.la' up
# a level, to the 'src/modules' directory, for general consumption.
#
#######################################################################

build-module: $(TARGET).la 
	@[ "x$(RLM_SUBDIRS)" = "x" ] || $(MAKE) $(MFLAGS) WHAT_TO_MAKE=all common
#	@[ -d .libs ] && cp .libs/* $(top_builddir)/src/modules/lib
#	@cp $< $(top_builddir)/src/modules/lib

$(TARGET).la: 
	$(CC) -c $(SRCS) -D_DRAYOS -I $(top_builddir)/src/include $(RLM_CFLAGS) $(CFLAGS) -o $@; \
	if [ -d $(ROOTDIR)/user/freeradius-1.1.6/src/dray_lib ]; then \
		if [ -f ./libeap/libeap.la ]; then \
			$(CC) -shared -o $(TARGET).so $(TARGET).la ./libeap/libeap.la; \
		else \
			$(CC) -shared -o $(TARGET).so $(TARGET).la; \
		fi; \
		cp $(TARGET).so $(ROOTDIR)/user/freeradius-1.1.6/src/dray_lib/$(TARGET).so; \
	fi;
#	$(LDFLAGS) $(RLM_LDFLAGS) -o $@
#	$^ $(top_builddir)/src/lib/libradius.la \
#	$(RLM_LIBS) $(LIBS)
#	$(CC) -D_LIBRADIUS -I../include $(CFLAGS) -c $< \ 
#######################################################################
#
#  It's a dummy target: don't build it
#
#######################################################################
else
build-module:

# if $(TARGET) == ""
endif

#######################################################################
#
#  clean and install rules
#
#######################################################################
clean:
	@rm -f *.a *.o *.lo *.la *.so *~
	@rm -rf .libs _libs
	@rm -f config.cache config.log config.status $(RLM_UTILS)
	@[ "x$(RLM_SUBDIRS)" = "x" ] || $(MAKE) $(MFLAGS) WHAT_TO_MAKE=clean common

distclean: clean
	@rm -f config.h config.mak
	@test -f Makefile.in && rm -f Makefile

reconfig:
	@if [ -f configure.in ]; then \
		[ "x$(AUTOCONF)" != "x" ] && $(AUTOCONF) -I $(top_builddir); \
	fi
	@if [ -f config.h.in ]; then \
		[ "x$(AUTOHEADER)" != "x" ] && $(AUTOHEADER); \
	fi
		

#
#  Do any module-specific installation.
#
#  If there isn't a TARGET defined, then don't do anything.
#  Otherwise, install the libraries into $(libdir)
#
install:
	@[ "x$(RLM_INSTALL)" = "x" ] || $(MAKE) $(MFLAGS) $(RLM_INSTALL)
	if [ "x$(TARGET)" != "x" ]; then \
	    $(LIBTOOL) --mode=install $(INSTALL) -c \
		$(TARGET).la $(R)$(libdir)/$(TARGET).la || exit $$?; \
	    rm -f $(R)$(libdir)/$(TARGET)-$(RADIUSD_VERSION).la; \
	    ln -s $(TARGET).la $(R)$(libdir)/$(TARGET)-$(RADIUSD_VERSION).la || exit $$?; \
	fi
