#!/bin/sh

if [ $# -lt 1 ]; then echo "Usage: $0 iface";  exit 1 ; fi

CONFIG_ROOT_DIR="/var/rtl8192c"
CONFIG_DIR=$CONFIG_ROOT_DIR/$1

#./script/default_setting.sh $1

SCRIPT_DIR=`cat $CONFIG_ROOT_DIR/wifi_script_dir`
BIN_DIR=`cat $CONFIG_ROOT_DIR/wifi_bin_dir`

if [ -f $BIN_DIR/iwpriv ]; then
	echo "iwpriv path is " $BIN_DIR/iwpriv
else
	echo "ERROR : Can't find iwpriv path. Path=" $BIN_DIR/iwpriv
	exit 1
fi

export SCRIPT_DIR
export BIN_DIR

### WDS related mib start
iwpriv $1 set_mib wds_enable=1
iwpriv $1 set_mib wds_pure=0
iwpriv $1 set_mib wds_priority=1
iwpriv $1 set_mib wds_num=0
iwpriv $1 set_mib wds_encrypt=0  ## 0:none 1:wep40 2:tkip 4:aes 5:wep104
iwpriv $1 set_mib wds_wepkey=3132333435  ## must translate ASCII to HEX
iwpriv $1 set_mib wds_passphrase=12345678
iwpriv $1 set_mib wds_add=00017301FE10,0  ## peer mac address, rate
### WDS related mib end

./script/init.sh  ## use enctyption shell in /root/script, like wpa2-aes.sh, ...

#IP_ADDR=`cat $CONFIG_DIR/ip_addr`
#ifconfig $1 $IP_ADDR

echo 1 > /proc/sys/net/ipv6/conf/$1-wds0/disable_ipv6
brctl addif br0 $1-wds0
ifconfig $1-wds0 up
