#!/bin/sh

source ./header.sh

USERNAME=$1
VALID_DAYS=$2
WAPIDIR=$WAPIDIR_DATA_DIR
AUTO_CERT_BACKDIR=$WAPIDIR/newcerts


OUTPUT_FILE=$3

X509_CERT_DIR=$WAPIDIR/certs

#patch for wapi
#because "openssl ecparam -genkey ... " may generate wrong private key sometimes
NORM_PRIV_KEY_SIZE=195
#Retry times is $MAX_TRY_NUM-1
MAX_TRY_NUM=2
#end patch


StoreWapi_Path=$WAPI_BIN_DIR/storeWapiFiles
Openssl_Path=$WAPI_BIN_DIR/openssl
ReadFile_Path=$WAPI_BIN_DIR/readFileSize

if [ -f $StoreWapi_Path ] ; then
	echo "toreWapi Path=$StoreWapi_Path"
else
	echo "Can't find Program-$StoreWapi_Path"
	exit 1
fi

if [ -f $Openssl_Path ] ; then
	echo "toreWapi Path=$Openssl_Path"
else
	echo "Can't find Program-$Openssl_Path"
	exit 1
fi


if [ -f $ReadFile_Path ] ; then
	echo "toreWapi Path=$ReadFile_Path"
else
	echo "Can't find Program-$ReadFile_Path"
	exit 1
fi

if [ "$USERNAME" = "" ] || [ "$VALID_DAYS" = "" ] || [ "$OUTPUT_FILE" = ""  ] ; then
	echo "usage: genUserCert.sh <username> <validDays> <cert filename>"
	exit 1
fi

if [ -d $AUTO_CERT_BACKDIR ]; then
	echo "CERTIFICATE folder path is" $AUTO_CERT_BACKDIR
else
	mkdir $AUTO_CERT_BACKDIR
fi

if [ -d $X509_CERT_DIR ]; then
	echo "X509_CERT_DIR folder path is" $X509_CERT_DIR
else
	mkdir $X509_CERT_DIR
fi




#echo "Begin to generate user cert ... "
#echo "USERNAME=$USERNAME"

#To clear temporary files first
#To avoid this situation: 
# consume that: 1)input 1 -> output 2, 2)input 2 -> output 3
# if 1) run error, but temporary file 2 exist, then 2) still can run.
rm -f $WAPIDIR/priv.key 2>/dev/null
rm -f $WAPIDIR/user.key 2>/dev/null
rm -f $WAPIDIR/user.csr 2>/dev/null
rm -f $WAPIDIR/$OUTPUT_FILE 2>/dev/null

#generate user private key
$Openssl_Path ecparam -genkey -name prime192v1 -out $WAPIDIR/priv.key -noout

#patch for wapi
#because "openssl ecparam -genkey ... " may generate wrong private key sometimes
num=1
while [ $num -lt $MAX_TRY_NUM ];
do 
#    echo "num=$num"
    $ReadFile_Path -in $WAPIDIR/priv.key -out $WAPIDIR/privKeySize
    PRIV_KEY_SIZE=`cat $WAPIDIR/privKeySize`
#    echo "priv_key_size=$PRIV_KEY_SIZE"

    if [ "$PRIV_KEY_SIZE" != "$NORM_PRIV_KEY_SIZE" ]; then
	echo "Warning: generate wrong private key. Try again!"
	#Retry to generate user private key
	$Openssl_Path ecparam -genkey -name prime192v1 -out $WAPIDIR/priv.key -noout
	num=`expr $num + 1`
    else
#	echo "Size of private key file generated is ok."
	num=$MAX_TRY_NUM
    fi
done
#end patch

cp $WAPIDIR/priv.key $WAPIDIR/user.key

#generate user cert request
$Openssl_Path req -new -key $WAPIDIR/user.key -subj "/OU=realsil/CN=$USERNAME" -out $WAPIDIR/user.csr

#bak current user cert serial
#cp $WAPIDIR/serial $WAPIDIR/serial.old

#generate user cert, during which serial automatically back into serial.old and update into the next one
#and openssl automatically back new certs at AUTO_CERT_BACKDIR/<serial>.pem
if [ -f "$WAPIDIR/user.csr" ]; then
	$Openssl_Path ca -days $VALID_DAYS -batch -keyfile $WAPIDIR/CA.key -cert $WAPIDIR/CA.cert -in $WAPIDIR/user.csr -out $WAPIDIR/$OUTPUT_FILE 2>/dev/null
else
	echo "Generate user cert error!"
	exit 1
fi

#To remove char format from user.cert, reserve PEM format only
$Openssl_Path x509 -inform PEM -in $WAPIDIR/$OUTPUT_FILE -outform PEM -out $WAPIDIR/tmp.cert
cp $WAPIDIR/tmp.cert $WAPIDIR/$OUTPUT_FILE
rm -f $WAPIDIR/tmp.cert

#Add user private key into user.cert
cat $WAPIDIR/user.key >> $WAPIDIR/$OUTPUT_FILE

#backup current user.cert into certs/<serial.old>.cert
SERIAL=`cat $WAPIDIR/serial.old`
cp $WAPIDIR/$OUTPUT_FILE $WAPIDIR/certs/$SERIAL.cert

#To remove openssl auto backup usercert
rm -f $AUTO_CERT_BACKDIR/$SERIAL.pem

echo "Generate user cert $SERIAL.cert"

#Store new generate user cert into flash
$StoreWapi_Path -oneUser

