#!/bin/sh
#
# script file to start network
#
# Usage: init.sh {gw | ap} {all | bridge | wan}
#



if [ -f /var/rtl8192c/wifi_script_dir ]; then
       	echo "wifi_script_dir path is /var/rtl8192c/wifi_script_dir"
       	SCRIPT_DIR=`cat /var/rtl8192c/wifi_script_dir`
else
       	echo $0 " ERROR : Can't find /var/rtl8192c/wifi_script_dir"
       	exit 1
fi

if [ -d $SCRIPT_DIR ]; then
        echo "SCRIPT_DIR path is" $SCRIPT_DIR
#        cd $SCRIPT_DIR
else
        echo $0 " ERROR : Can't find SCRIPT_DIR path. Path=" $SCRIPT_DIR
        exit 1
fi

source $SCRIPT_DIR/header.sh

#if [ -f $WEBS_PATH ]; then
#       	echo "WEBS_PATH path is " $WEBS_PATH
#else
#       	echo $0 " ERROR : Can't find $WEBS_PATH"
#       	exit 1
#fi

if [ -f $IWCONTROL_PATH ]; then
       	echo "IWCONTROL_PATH path is " $IWCONTROL_PATH
else
       	echo $0 " ERROR : Can't find $IWCONTROL_PATH"
       	exit 1
fi




WLAN_PREFIX=wlan
VIRTUAL_WLAN_PREFIX=$WLAN_PREFIX-va
VXD_WLAN_PREFIX=$WLAN_PREFIX-vxd


GET_DIR=var/rtl8192c/wlan0
GET_VALUE=
WLAN_INTERFACE=
NUM_INTERFACE=
VIRTUAL_NUM_INTERFACE=
VIRTUAL_WLAN_INTERFACE=

TOTAL_INTERFACE=


# Query number of wlan interface
rtl_query_wlan_if() {
	NUM=0
	VIRTUAL_NUM=0
	VIRTUAL_WLAN_PREFIX=
	V_DATA=
	V_LINE=
	V_NAME=
	HAS_WLAN=0

	DATA=`ifconfig | grep $WLAN_PREFIX`
	LINE=`echo $DATA | grep $WLAN_PREFIX$NUM`
	NAME=`echo $LINE | cut -b -5`
	if [ -n "$NAME" ]; then
		HAS_WLAN=1
	fi
	while [ -n "$NAME" ] 
	do
		WLAN_INTERFACE="$WLAN_INTERFACE $WLAN_PREFIX$NUM"
		TOTAL_INTERFACE="$TOTAL_INTERFACE $WLAN_PREFIX$NUM"

		VIRTUAL_WLAN_PREFIX="$WLAN_PREFIX$NUM-va"
		V_DATA=`ifconfig | grep $VIRTUAL_WLAN_PREFIX`
		V_LINE=`echo $V_DATA | grep $VIRTUAL_WLAN_PREFIX$VIRTUAL_NUM`
		V_NAME=`echo $V_LINE | cut -b -9`
		while [ -n "$V_NAME" ] 
		do
			VIRTUAL_WLAN_INTERFACE="$VIRTUAL_WLAN_INTERFACE $VIRTUAL_WLAN_PREFIX$VIRTUAL_NUM"
			TOTAL_INTERFACE="$TOTAL_INTERFACE $VIRTUAL_WLAN_PREFIX$VIRTUAL_NUM"
			VIRTUAL_NUM=`expr $VIRTUAL_NUM + 1`
			V_LINE=`echo $V_DATA | grep $VIRTUAL_WLAN_PREFIX$VIRTUAL_NUM`
			V_NAME=`echo $V_LINE | cut -b -9`
		done
		

		VXD_INTERFACE="$WLAN_PREFIX$NUM-vxd"
		V_DATA1=`ifconfig | grep $VXD_INTERFACE`
		if [ -n "$V_DATA1" ]; then
			VIRTUAL_WLAN_INTERFACE="$VIRTUAL_WLAN_INTERFACE $VXD_INTERFACE"
		fi
		
		NUM=`expr $NUM + 1`
		LINE=`echo $DATA | grep $WLAN_PREFIX$NUM`
		NAME=`echo $LINE | cut -b -5`
	done
	NUM_INTERFACE=$NUM
	VIRTUAL_NUM_INTERFACE=$VIRTUAL_NUM
}


# Generate WPS PIN number
rtl_generate_wps_pin() {
	GET_VALUE=`cat /$GET_DIR/wsc_pin`
	if [ "$GET_VALUE" = "00000000" ]; then
		flash gen-pin wlan0
		flash gen-pin wlan0-vxd
	fi
}

#	echo NUM_INTERFACE=$NUM_INTERFACE
#	echo VIRTUAL_NUM_INTERFACE=$VIRTUAL_NUM_INTERFACE
#	echo WLAN_INTERFACE=$WLAN_INTERFACE
#	echo VIRTUAL_WLAN_INTERFA=$VIRTUAL_WLAN_INTERFACE
#	echo TOTAL_INTERFACE=$TOTAL_INTERFACE

rtl_init() {

	echo "Init.sh start....."
#	killall webs 2>/dev/null
#	$WEBS_PATH -x

	rtl_query_wlan_if

	killall iwcontrol 2>/dev/null
	
#	RUN_INTERFACE=VIRTUAL_WLAN_INTERFA
#	RUN_INTERFACE=$WLAN_INTERFACE
	RUN_INTERFACE=$TOTAL_INTERFACE
	
	for INTF in $RUN_INTERFACE ; do

		CONFIG_DIR=$CONFIG_ROOT_DIR/$INTF
		WPA_AUTH=`cat $CONFIG_DIR/wpa_auth`
		WSC_DISABLE=`cat $CONFIG_DIR/wsc_disabled`

		###################### Close daemon #################################
		case $WPA_AUTH in
			1)
				#echo "$SCRIPT_DIR/radius_server.sh close $INTF";
				cd  $SCRIPT_DIR
				./radius_server.sh close $INTF;;
			2)
				case $WSC_DISABLE in
							1)
								echo "WPS is disable";;
							0)
								cd  $SCRIPT_DIR/wps_tools;
								./web_wps_setting.sh $INTF close;;
							*)
								echo "ERROR : unknow $CONFIG_DIR/wsc_disabled type" $WSC_DISABLE
								exit 1;;
				esac;;
			*)
				echo "ERROR : unknow wpa_auth type" $wpa_auth;
				exit 1;;
		esac
		##################################################################
		
		cd  $SCRIPT_DIR
		ifconfig $INTF down
		./web_wifi_read.sh $INTF
		ifconfig $INTF up

		###################### Re-start daemon #################################
		case $WPA_AUTH in
			1)
				echo "wpa_auth is radius server";
				rs_ip=`cat $CONFIG_DIR/rs_ip`
				rs_password=`cat $CONFIG_DIR/rs_password`
				rs_port=`cat $CONFIG_DIR/rs_port`
				rs_interafce=`cat $CONFIG_DIR/rs_interafce`
				cd  $SCRIPT_DIR
				./radius_server.sh open $INTF $rs_ip $rs_interafce $rs_password $rs_port;
				$IWCONTROL_PATH $INTF
				;;
			2)
				echo "wpa_auth is WPA-PSK";
				case $WSC_DISABLE in
							1)
								echo "WPS disable";;
							0)
								echo "WPS enable";
								cd  $SCRIPT_DIR/wps_tools;
								./web_wps_setting.sh $INTF open;;
							*)
								echo "ERROR : unknow $CONFIG_DIR/wsc_disabled type" $WSC_DISABLE
								exit 1;;
				esac;;
			*)
				echo "ERROR : unknow wpa_auth type" $wpa_auth;
				exit 1;;
		esac
		##################################################################
		
	done
	$IWCONTROL_PATH $RUN_INTERFACE
}

##################### Check Path ################################
if [ -f $WEBS_PATH ]; then
       	echo "iwcontrol path is" $WEBS_PATH
else
       	echo $0 " ERROR : Can't find iwcontrol path. Path=" $WEBS_PATH
       	exit 1
fi

if [ -f $IWCONTROL_PATH ]; then
       	echo "iwcontrol path is" $IWCONTROL_PATH
else
       	echo $0 " ERROR : Can't find iwcontrol path. Path=" $IWCONTROL_PATH
       	exit 1
fi
#################################################################


rtl_init
