#!/bin/sh

source ./header.sh

SERIAL=$1
WAPIDIR=$WAPIDIR_DATA_DIR
USER_CERT_DIR=$WAPIDIR/certs
#USER_CERT_DIR=$WAPIDIR
OPENSSL_CONF=$WAPI_BIN_DIR/openssl.cnf
Openssl_Path=$WAPI_BIN_DIR/openssl
StoreWapi_Path=$WAPI_BIN_DIR/storeWapiFiles


if [ -f $Openssl_Path ] ; then
	echo "Openssl_Path Path=$Openssl_Path"
else
	echo "Can't find Program-$Openssl_Path"
	exit 1
fi

if [ -f $OPENSSL_CONF ] ; then
	echo "OPENSSL_CONF Path=$OPENSSL_CONF"
else
	echo "Can't find configure file-$OPENSSL_CONF"
	exit 1
fi

if [ "$SERIAL" = "" ]; then
	echo "usage: revokeUserCert.sh <serial> [option]"
	echo "description: serial must be a string of hex integer"
	echo "option: if use it, do not update ca crl and user certs into flash"
	exit 1
fi

if [ -f $StoreWapi_Path ] ; then
	echo "StoreWapi_Path Path=$StoreWapi_Path"
else
	echo "Can't find daemon $StoreWapi_Path"
	exit 1
fi

USER_CERT=$SERIAL.cert

#echo "Begin to revoke $USER_CERT user cert ... "

#To revoke user cert of which user cert name is <serial>.cert
$Openssl_Path ca -keyfile $WAPIDIR/CA.key -cert $WAPIDIR/CA.cert -revoke $USER_CERT_DIR/$USER_CERT

#To remove bak of user cert which is revoked
rm -f $USER_CERT_DIR/$USER_CERT 2>/dev/null

echo "Revoke user cert: $USER_CERT OK!"

if [ "$2" != 'option' ]; then
#	echo "update ca crl and user certs into flash"
	#To update ca crl
	$Openssl_Path ca -gencrl -config $OPENSSL_CONF -crldays 365 -crlexts crl_ext -out $WAPIDIR/CA.crl

	#Update ca crl into flash
	$StoreWapi_Path -caCrl

	#Update all user certs into flash
	$StoreWapi_Path -allUser
##else
#	echo "Not update ca crl and user certs into flash"
fi

