#include "wapiFiles.h"

/*
#define TEST_CA_CERT		(WIFI_WAPI_TMP_DIR "/test_ca.cert")
#define TEST_CA_PRIV_KEY	(WIFI_WAPI_TMP_DIR "/test_ca_priv.key")
#define TEST_CA_CRL		(WIFI_WAPI_TMP_DIR "/test_ca.crl")
#define TEST_USER_CERT		(WIFI_WAPI_TMP_DIR "/test_user.cert")
#define TEST_USER_CERT_DIR	(WIFI_WAPI_TMP_DIR "/certs")
#define TEST_CERTS_DATABASE	(WIFI_WAPI_TMP_DIR "/test_index.txt")
#define TEST_AP_CERT		(WIFI_WAPI_TMP_DIR "/test_ap.cert")

#define TEST_SERIAL		(WIFI_WAPI_TMP_DIR "/serial")
#define TEST_CRLNUMBER		(WIFI_WAPI_TMP_DIR "/crlnumber")
*/
#define TEST_CA_CERT CA_CERT
#define TEST_CA_PUB_KEY CA_PUB_KEY
#define TEST_CA_PRIV_KEY CA_PRIV_KEY
#define TEST_CA_CRL CA_CRL
#define TEST_USER_CERT USER_CERT
#define TEST_USER_CERT_DIR USER_CERT_DIR
#define TEST_CERTS_DATABASE CERTS_DATABASE
#define TEST_AP_CERT AP_CERT
#define TEST_CA4AP_CERT CA4AP_CERT

#define TEST_SERIAL NEXT_SERIAL
#define TEST_CRLNUMBER NEXT_CRLNUMBER

/*
*   function description: load next user cert serial  and next ca crl number from wapi area header at flash into destination file dstSerialFile and dstCrlnumFile
*
*   paramters:
*   dstSerialFile (output): load serial from flash into this file
*   dstCrlnumberFile (output): load crlnumber from flash into this file
*
*   return 0: success; return -1: failed
*/
static int loadWapiAreaHeader(const char * dstSerialFile, const char * dstCrlnumFile)
{
	int fh;
	int ret, toRet;
	unsigned long offset;
	WAPI_AREA_HEADER_T wapiAreaHeader;
	char tmpBuf[50];

	//To initial
	fh=-1;
	
	if((dstSerialFile==NULL)||(dstCrlnumFile==NULL))
	{
		ERR_PRINT("Error: dstSerialFile or dstCrlnumFile is null.\n");//Added for test
		toRet=FAILED;
		goto err;
	}
	
	fh = open(FLASH_DEVICE_NAME1, O_RDONLY); 

	if ( fh == -1 ) 
	{
		ERR_PRINT("%s %d open %s error.\n",__FUNCTION__ , __LINE__, FLASH_DEVICE_NAME1);//Added for test
		toRet=FAILED;
		goto err;
	}

	//Initial
	memset(&wapiAreaHeader, 0, sizeof(wapiAreaHeader));

	offset=WAPI_AREA_BASE;
	lseek(fh,offset,SEEK_SET);
	ret=read(fh,(void *)&wapiAreaHeader,sizeof(wapiAreaHeader));
//	DEBUG("%s(%d),ret=%d,wapiAreaHeader.fileNum=0x%x, nextSerial=0x%x, nextCrlNumber=0x%x\n",__FUNCTION__,__LINE__,ret,wapiAreaHeader.fileNum, wapiAreaHeader.nextSerial, wapiAreaHeader.nextCrlNumber);//Added for test

	if ( memcmp(wapiAreaHeader.signature, WAPI_SIGNATURE, SIG_LEN)) {
		ERR_PRINT("WAPI_SIGNATURE error\n");
		toRet=FAILED;
		goto err;
	}

	memset(tmpBuf, 0, sizeof(tmpBuf));
	sprintf(tmpBuf, "echo \"%8X\" > %s", wapiAreaHeader.nextSerial, dstSerialFile);
	system(tmpBuf);

	memset(tmpBuf, 0, sizeof(tmpBuf));
	sprintf(tmpBuf, "echo \"%8X\" > %s", wapiAreaHeader.nextCrlNumber, dstCrlnumFile);
	system(tmpBuf);
	
	toRet=SUCCESS;

err:	
	if(fh!=-1)
		close(fh);

	return toRet;
}

/*
*  function description: load file from srcAddr to dstFile
* parameters:
* dstFile (input) : destination filename
* srcAddr (input) : source file address at flash
* return 0: success, -1: failed
*/
static int loadFile(const char * dstFile, const unsigned long srcAddr)
{
	int fh, fd;
	int ret, toRet;
	int readSize, lenLeft, bufSize;
	unsigned long offset;
	WAPI_FILE_HEADER_T wapiFileHeader;

	unsigned char buffer[1300];
	char tmpBuf[USER_CERT_DIR_MAX_LEN+FILE_NAME_MAX_LEN];

	char rwFlag;// 0: indicate first time; 1: indicate not first time

	//To initial
	fh=-1;
	fd=-1;
	
	offset=srcAddr;

	DEBUG("%s(%d), dstFile=%s offset=0x%x\n",__FUNCTION__,__LINE__,dstFile,offset);//Added for test

#if defined(WAPI_8196)
	if((offset >= MTD1_SIZE)||(offset< MTD1_SIZE -WAPI_SIZE))
	{
		ERR_PRINT("Error: srcAddr is out of wapi area %s - %s\n",(MTD1_SIZE -WAPI_SIZE), MTD1_SIZE);//Added for test
		toRet=FAILED;
		goto err;
	}
#endif

	fh = open(FLASH_DEVICE_NAME1, O_RDONLY); 

	if ( fh == -1 ) 
	{
		ERR_PRINT("%s %d open %s error.\n",__FUNCTION__ , __LINE__, FLASH_DEVICE_NAME1);//Added for test
		toRet=FAILED;
		goto err;
	}

	//To initial
	memset(&wapiFileHeader, 0, sizeof(wapiFileHeader));
	
	//To read flash
	lseek(fh,offset,SEEK_SET);//Point to the start of first wapi file
	ret=read(fh,(void *)&wapiFileHeader,sizeof(wapiFileHeader));
//	DEBUG("%s(%d),ret=%d, fileType=0x%x, fileSerial=0x%x, fileLen=0x%x\n",__FUNCTION__,__LINE__,ret,wapiFileHeader.fileType, wapiFileHeader.fileSerial, wapiFileHeader.fileLen);//Added for test
	if((ret==FAILED)||(ret< sizeof(wapiFileHeader)))
	{
		ERR_PRINT("%s(%d),error: read flash failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	if((wapiFileHeader.fileType!=TYPE_CA_CERT)&&(wapiFileHeader.fileType!=TYPE_CA_PRIV_KEY)&&(wapiFileHeader.fileType!=TYPE_CA_CRL)
		&&(wapiFileHeader.fileType!=TYPE_USER_CERT)&&(wapiFileHeader.fileType!=TYPE_CERTS_DATABASE)
		&&(wapiFileHeader.fileType!=TYPE_AP_CERT)&&(wapiFileHeader.fileType!=TYPE_CA4AP_CERT))
	{
		ERR_PRINT("%s(%d),unknow file type.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	lenLeft=(int)wapiFileHeader.fileLen;
	if(lenLeft<=0)
	{
		ERR_PRINT("%s(%d),file length <= 0.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	
	rwFlag=0;
	bufSize=sizeof(buffer);
	while(lenLeft>0)
	{
		if(lenLeft>bufSize)
		{
			readSize=read(fh,(void *)&buffer,bufSize);
		}
		else
		{
			readSize=read(fh,(void *)&buffer,lenLeft);
		}
		//DEBUG("%s(%d),readSize=%d\n",__FUNCTION__,__LINE__,readSize);//Added for test
		if(readSize==FAILED)
		{
			ERR_PRINT("%s(%d),error: read flash failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		if(rwFlag==0)
		{
			if((dstFile==NULL)&&(wapiFileHeader.fileType==TYPE_USER_CERT))
			{
				//use default dest file: <serial>.cert
				//only for user certs loading
				sprintf(tmpBuf, "%s/%8X.cert", TEST_USER_CERT_DIR, wapiFileHeader.fileSerial);
				//DEBUG("%s(%d),tmpBuf=%s\n",__FUNCTION__,__LINE__,tmpBuf);//Added for test
				fd=open(tmpBuf, O_WRONLY | O_CREAT | O_TRUNC);
			}
			else
			{
				if(dstFile==NULL)
				{
					ERR_PRINT("Error: dstFile is null and this is not user cert.\n");//Added for test
					toRet=FAILED;
					goto err;
				}
				fd=open(dstFile, O_WRONLY | O_CREAT | O_TRUNC);
			}
			
			if ( fd == -1 ) 
			{
				ERR_PRINT("open %s error.\n", dstFile);//Added for test
				toRet=FAILED;
				goto err;
			}
		}

		ret=write(fd, (void *)buffer, readSize);
		//DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
		if((ret==FAILED)||(ret< readSize))
		{
			ERR_PRINT("%s(%d),error: write file failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		lenLeft-=readSize;
		rwFlag=1;
	}

	toRet=SUCCESS;

err:
	if(fd!=-1)
		close(fd);
	
	if(fh!=-1)
		close(fh);
	
	return toRet;
}

int main(int argc, char **argv)
{
	int ret, i;
	int toRet;
	unsigned long offset, userCertNumber;
	char tmpBuf[100];
	
//	DEBUG("%s(%d)\n",__FUNCTION__,__LINE__);//Added for test

	system("mkdir " WIFI_WAPI_CERT_DIR "/certs 2>/dev/null");//Added for test
	system("rm -f " WIFI_WAPI_CERT_DIR "/certs/* 2>/dev/null");//Added for test

	//load serial file and crlnumber file
	ret=loadWapiAreaHeader(TEST_SERIAL, TEST_CRLNUMBER);
//	DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
	if(ret==FAILED)
	{
		toRet=FAILED;
		ERR_PRINT("Warning: %s(%d), load serial file and crlnumber file failed.\n",__FUNCTION__,__LINE__);//Added for test
		goto err;
	}
	
	//load ca cert
	offset=CA_CERT_BASE;
	DEBUG("~~~%s(%d),ret=%d~~~\n",__FUNCTION__,__LINE__,ret);//Added for test
	ret=loadFile(TEST_CA_CERT, offset);
	if(ret==FAILED)
	{
		toRet=FAILED;
		ERR_PRINT("Warning: %s(%d), load ca cert failed.\n",__FUNCTION__,__LINE__);//Added for test
		goto err;
	}
#if defined(WAPI_8196)
	else
	{
		//To copy to /web/as.cer for WAPI web UI
		sprintf(tmpBuf, "cp -f %s /web/as.cer", TEST_CA_CERT);
		system(tmpBuf);
	}
#endif

	if(isFileExist(TEST_CA_CERT)==1)
	{
		//To generate ca public key from ca cert
		sprintf(tmpBuf, OPENSSL_DIR"/openssl x509 -in %s -pubkey -noout > %s", TEST_CA_CERT, TEST_CA_PUB_KEY);
		system(tmpBuf);
	}

	//load ca private key
	offset=CA_PRIV_KEY_BASE;
	ret=loadFile(TEST_CA_PRIV_KEY, offset);
	DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
	if(ret==FAILED)
	{
		toRet=FAILED;
		ERR_PRINT("Warning: %s(%d), load ca private key failed.\n",__FUNCTION__,__LINE__);//Added for test
		goto err;
	}

	//load ca crl
	offset=CA_CRL_BASE;
	ret=loadFile(TEST_CA_CRL, offset);
	DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
	if(ret==FAILED)
	{
		toRet=FAILED;
		ERR_PRINT("Warning: %s(%d), load ca crl failed.\n",__FUNCTION__,__LINE__);//Added for test
		goto err;
	}

	//load user certs
	ret=getUserCertNum(&userCertNumber);
	DEBUG("%s(%d),ret=%d, userCertNumber=%d\n",__FUNCTION__,__LINE__,ret, userCertNumber);//Added for test
	if(ret==FAILED)
	{
		toRet=FAILED;
		//goto err;
		ERR_PRINT("Warning: %s(%d), getUserCertNum failed.\n",__FUNCTION__,__LINE__);//Added for test
	}
	else
	{
		offset=USER_CERT_BASE;
		for(i=0; i<userCertNumber; i++)
		{
			//To load all user certs
			if(i!=0)
				offset+=USER_CERT_MAXSIZE;
			
			ret=loadFile(NULL, offset);
//			DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
			if(ret==FAILED)
			{
				toRet=FAILED;
				//goto err;
				ERR_PRINT("Warning: %s(%d), load user certs failed from 0x%x.\n",__FUNCTION__,__LINE__, offset);//Added for test
				break;
			}
		}
	}

	//load user certs database: index.txt
	offset=USER_CERT_DATABASE_BASE;
	ret=loadFile(TEST_CERTS_DATABASE, offset);
	DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
	if(ret==FAILED)
	{
		toRet=FAILED;
		ERR_PRINT("Warning: %s(%d), load user certs database failed.\n",__FUNCTION__,__LINE__);//Added for test
		goto err;
	}

	//load ap cert
	offset=AP_CERT_BASE;
	ret=loadFile(TEST_AP_CERT, offset);
	DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
	if(ret==FAILED)
	{
		toRet=FAILED;
		ERR_PRINT("Warning: %s(%d), load ap cert failed.\n",__FUNCTION__,__LINE__);//Added for test
		goto err;
	}

#if defined(WAPI_8196)
	//load ca cert for ap
	offset=CA4AP_CERT_BASE;
	ret=loadFile(TEST_CA4AP_CERT, offset);
	DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
	if(ret==FAILED)
	{
		toRet=FAILED;
		ERR_PRINT("Warning: %s(%d), load ca cert for ap failed.\n",__FUNCTION__,__LINE__);//Added for test
		goto err;
	}
#endif

	//patch for certs verify initial
	//sprintf(tmpBuf,"openssl verify -CAfile %s %s", CA_CERT, CA_CERT);
	//system(tmpBuf);
	system("echo \"unique_subject = yes\" > " WIFI_WAPI_CERT_DIR "/index.txt.attr");
	
	toRet=SUCCESS;
//	DEBUG("%s(%d),test OK!\n",__FUNCTION__,__LINE__);//Added for test
	
err:
//	DEBUG("%s(%d),toRet=%d\n",__FUNCTION__,__LINE__,toRet);//Added for test
	return toRet;
}

