#include <stdio.h>
#include <sys/time.h>
#include <signal.h>
#include <dirent.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <linux/types.h>
#include <linux/socket.h>
#include <linux/if.h>
#include <linux/wireless.h>

#include "wapi.h"
#include "wapitest.h"

#define SERV_PORT 3810

//extern char Buf[APP2DRV_BUF_LEN];
//extern int fd;

//static char Buf[APP2DRV_BUF_LEN];
static int fd;
static int sockfd;
static struct sockaddr_in servaddr;


/************************ SOCKET SUBROUTINES *************************/



/*------------------------------------------------------------------*/

/*

 * Open a socket.

 * Depending on the protocol present, open the right socket. The socket

 * will allow us to talk to the driver.

 */

int

sockets_open(void)

{

        int ipx_sock = -1;              /* IPX socket                   */

        int ax25_sock = -1;             /* AX.25 socket                 */

        int inet_sock = -1;             /* INET socket                  */

        int ddp_sock = -1;              /* Appletalk DDP socket         */



        /*

         * Now pick any (exisiting) useful socket family for generic queries

	 * Note : don't open all the socket, only returns when one matches,

	 * all protocols might not be valid.

	 * Workaround by Jim Kaba <jkaba@sarnoff.com>

	 * Note : in 99% of the case, we will just open the inet_sock.

	 * The remaining 1% case are not fully correct...

         */

        inet_sock=socket(AF_INET, SOCK_DGRAM, 0);

        if(inet_sock!=-1)

                return inet_sock;

        ipx_sock=socket(AF_IPX, SOCK_DGRAM, 0);

        if(ipx_sock!=-1)

                return ipx_sock;

        ax25_sock=socket(AF_AX25, SOCK_DGRAM, 0);

        if(ax25_sock!=-1)

                return ax25_sock;

        ddp_sock=socket(AF_APPLETALK, SOCK_DGRAM, 0);

        /*

         * If this is -1 we have no known network layers and its time to jump.

         */

        return ddp_sock;

}

/*demo for using the ioctl
  *read a event
  *write a event
  */
int get_fd()
{
	int skfd = -1;	/* generic raw socket desc */
	/* Create a channel to the NET kernel */
	if((skfd = sockets_open()) < 0)
	{
		perror("socket");
		exit(-1);
	}
	return skfd;
}

int requestIndication(
	int                    skfd,
	char *                 ifname,
	char *		       out,
	int  *		       outlen)
{

	struct iwreq          wrq;
	DOT11_REQUEST	      * req;



  	/* Get wireless name */
	memset(wrq.ifr_name, 0, sizeof wrq.ifr_name);
 	strncpy(wrq.ifr_name, ifname, IFNAMSIZ);

	req = (DOT11_REQUEST *)malloc(MAXDATALEN);
	wrq.u.data.pointer = (caddr_t)req;
	req->EventId = DOT11_EVENT_WAPI_READ_QUEUE;
	wrq.u.data.length = sizeof(DOT11_REQUEST);

	//DEBUG("\n[RequestIndication] : Start\n");
  	if(ioctl(skfd, SIOCGIWIND, &wrq) < 0)
	{
   	// If no wireless name : no wireless extensions
		free(req);
		strerror(errno);
    		return(-1);
	}
  	else{
		memcpy(out, wrq.u.data.pointer, wrq.u.data.length);
		*outlen = wrq.u.data.length;
	}
	free(req);
	return 1;
}


int requestInit(
	int                    skfd,
	char *                 ifname,
	char *		       out,
	int  *		       outlen)
{

	struct iwreq          wrq;
	DOT11_REQUEST	      * req;



  	/* Get wireless name */
	memset(wrq.ifr_name, 0, sizeof wrq.ifr_name);
  	strncpy(wrq.ifr_name, ifname, IFNAMSIZ);

	req = (DOT11_REQUEST *)malloc(MAXDATALEN);
	wrq.u.data.pointer = (caddr_t)req;
	req->EventId = DOT11_EVENT_WAPI_INIT_QUEUE;
	wrq.u.data.length = sizeof(DOT11_REQUEST);

	//DEBUG("\n[RequestIndication] : Start\n");
  	if(ioctl(skfd, SIOCGIWIND, &wrq) < 0)
	{
   	// If no wireless name : no wireless extensions
		free(req);
		strerror(errno);
    		return(-1);
	}
 	else{
		//iw_message(MESS_DBG_IWCONTROL, "[RequestIndication]"," : Return\n");
		//iw_ctldump("RequestIndication", wrq.u.data.pointer, wrq.u.data.length, "receive message from driver");
		//memcpy(out, wrq.u.data.pointer, wrq.u.data.length);
		//*outlen = wrq.u.data.length;
		//write(1, "RequestIndication<1>\n", sizeof("RequestIndication<1>\n"));

	}
	free(req);
	return 1;
}
int requestWrite(
	int                    skfd,
	char *                 ifname,
	char *		       buf,
	int  		       buflen)
{
	int retVal = 0;
	struct iwreq wrq;
	strncpy(wrq.ifr_name,ifname, IFNAMSIZ);
	wrq.u.data.pointer = (caddr_t)buf;
	wrq.u.data.length = buflen;
	 if(ioctl(skfd, SIOCGIWIND, &wrq) < 0)
        // If no wireless name : no wireless extensions
                retVal = -1;
        else
                retVal = 0;

	return retVal;
}
int RegisterPID(
	int                    skfd,
	char *                 ifname)
{
	struct iwreq          wrq;
	pid_t                 pid;

  	/* Get wireless name */
	memset(wrq.ifr_name, 0, sizeof wrq.ifr_name);
  	strncpy(wrq.ifr_name, ifname, IFNAMSIZ);

	pid = getpid();
	wrq.u.data.pointer = (caddr_t)&pid;
	wrq.u.data.length = sizeof(pid_t);

  	if(ioctl(skfd, SIOCSWAPIPID, &wrq) < 0)
	{
    	// If no wireless name : no wireless extensions
		strerror(errno);
		return(-1);
	}
	return 1;
}
int dumptest(MY_TESTp ptest)
{
	DEBUG("dump test event:\n");
	DEBUG("Event ID: %d\n",ptest->eventID);
	DEBUG("More Event: %d\n",ptest->moreEvent);
	DEBUG("sequence: %d\n",ptest->seq);
	return 0;
}

int dumpParamsTest(COMM_PARAMSp pParams)
{
	DEBUG("dump test event:\n");
	DEBUG("Event ID: %d\n",pParams->eventID);
	DEBUG("More Event: %d\n",pParams->moreData);
	DEBUG("type: %d\n",pParams->type);
	DEBUG("ptr: %p\n",pParams->ptr);
	return 0;
}

void ProcessEvent(int sig_no)
{
	u_long	ulMoreEvent;
	int i;

	for(i=0;i<wlanInterfaceNum;i++)
	{
		do{
			DEBUG("%s(%d)iAS Clientj wlanInterface[%d]=%s\n", __FUNCTION__,__LINE__,i,wlanInterface[i]);
			ulMoreEvent=RequestEvent2(wlanInterface[i]);
		} while(ulMoreEvent);
	}
}

//For wapi: communication between driver and application
int RequestEvent2(char* ifname)
{
	int ret, toRet, retVal;
	COMM_PARAMSp pParams;
	COMM_PARAMSp pParams2Drv;
	int len, tmpLen, tmpLen2;
	int useOptionalSeg=0;

	//Note: These pointer need to malloc memory when use them
	//char Buf[APP2DRV_BUF_LEN];	//Buffer for communication: driver to application
	//char Buf2Drv[APP2DRV_BUF_LEN];	//Buffer for communication: application to driver
	char * Buf=NULL;	//Buffer for communication: driver to application
	char * Buf2Drv=NULL; //Buffer for communication: application to driver
	char * tmpBuffer=NULL;
	
	char path[MAX_PATH];
	char cmdline[MAX_PATH];

	WAPI_VERIFY_ACTIVATE_Tp pWapiVerifyActivate=NULL;

	WAPI_PKT_Tp pSndWaiPkt=NULL;
	WAPI_PKT_Tp pRevWapiPkt=NULL;
	//WAPI_ACCESS_VERIFY_RES_Tp pAccessVerifyRes=NULL;

	WAPI_ACCESS_VERIFY_REQ_Tp pAccessVerifyReq=NULL;
	//end of note

	//To initial
	retVal=0;

	//To malloc memory
	Buf=(char *)malloc(APP2DRV_BUF_LEN);
	if(Buf==NULL)
	{
		ERR_PRINT("%s(%d), malloc failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}

	Buf2Drv=(char *)malloc(APP2DRV_BUF_LEN);
	if(Buf2Drv==NULL)
	{
		ERR_PRINT("%s(%d), malloc failed.\n",__FUNCTION__,__LINE__);//Added for test
		toRet=FAILED;
		goto err;
	}
	
	/*read*/
#if 1
	requestIndication(fd,ifname,Buf,&len);
	if(len < sizeof(COMM_PARAMS))
	{
		DEBUG("[%s][%d]: [0x%x][0x%x][0x%x][0x%x], go out here[1].\n", ifname, len, Buf[0], Buf[1], Buf[2], Buf[3]);//Added for test
		toRet=FAILED;
		goto err;
	}

	DEBUG("iAS Clientjwapi application receive from wapi driver:len=%d\n",len);//Added for test
#endif
	
	pParams= (COMM_PARAMSp)Buf;
//	dumpParamsTest(pParams);//Added for test

	//DEBUG("%s(%d),pParams->ptr=%p\n",__FUNCTION__,__LINE__,pParams->ptr);//Added for test 

	DEBUG("name [%s]-[%s], len [%d] - [%d]\n", ifname, pParams->name, strlen(ifname),strlen(pParams->name));//Added for test 
	if ((strlen(pParams->name)==0)||(memcmp(ifname, pParams->name, strlen(pParams->name))))
	{
		DEBUG("%s(%d): ifname=%s, pParams->name=%s, go out here[2].\n", __FUNCTION__,__LINE__,ifname,pParams->name);//Added for test 
		toRet=FAILED;
		goto err;
	}
	retVal=pParams->moreData;
	
	get_wifi_bin_dir(path, sizeof(path));
	strcat(path, "/");
	
	if(pParams->type==WAPI_IOCTL_TYPE_REQ_ACTIVE)
	//if(0)
	{
		//To test
		//To dump WAPI_IOCTL_TYPE_REQ_ACTIVE pkt from driver
		DEBUG("recv pkt from driver. WAPI_IOCTL_TYPE_REQ_ACTIVE\n");
		dumpHex(Buf, 20);

		//To store ADDID from Buf into ADDID_FILE for generate cert verify request
		ret=storeStr2File(ADDID_FILE, (const unsigned char *)&Buf[8], 12);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), storeStr2File failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		
		//To send driver some parts of wapi verify activate pkt
		DEBUG("%s(%d), recv pkt from driver: WAPI_IOCTL_TYPE_REQ_ACTIVE.\n",__FUNCTION__,__LINE__);//Added for test

		//To malloc memory
		pWapiVerifyActivate=(WAPI_VERIFY_ACTIVATE_Tp)malloc(sizeof(WAPI_VERIFY_ACTIVATE_T));
		if(pWapiVerifyActivate==NULL)
		{
			ERR_PRINT("%s(%d), malloc failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		
		ret=genVerifyActivate(pWapiVerifyActivate);//!!!!!To buffer directly(to do.)
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), genVerifyActivate failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

#if 1
		//To send to driver
		memset(Buf2Drv, 0, APP2DRV_BUF_LEN);
		pParams2Drv=(COMM_PARAMSp)Buf2Drv;
		pParams2Drv->eventID=DOT11_EVENT_WAPI_WRITE_QUEUE;
		pParams2Drv->type=WAPI_IOCTL_TYPE_ACTIVEAUTH;
		pParams2Drv->ptr=pParams->ptr;
		memset(pParams2Drv->name,0,IFNAMSIZ);
		memcpy(pParams2Drv->name,ifname,strlen(ifname));
//		tmpLen=8;
		tmpLen=WAPI_COMM_PARAM_SIZE;

		//local ASU Identification
		memcpy((void *)(Buf2Drv+tmpLen), (void *)&(pWapiVerifyActivate->asuID.idFlag), 2);
		tmpLen+=2;
		memcpy((void *)(Buf2Drv+tmpLen), (void *)&(pWapiVerifyActivate->asuID.idLen), 2);
		tmpLen+=2;
		memcpy((void *)(Buf2Drv+tmpLen), (void *)&(pWapiVerifyActivate->asuID.idData), pWapiVerifyActivate->asuID.idLen);
		tmpLen+=pWapiVerifyActivate->asuID.idLen;

		//AE cert
		memcpy((void *)(Buf2Drv+tmpLen), (void *)&(pWapiVerifyActivate->aeCert.certFlag), 2);
		tmpLen+=2;
		memcpy((void *)(Buf2Drv+tmpLen), (void *)&(pWapiVerifyActivate->aeCert.certLen), 2);
		tmpLen+=2;
		memcpy((void *)(Buf2Drv+tmpLen), (void *)&(pWapiVerifyActivate->aeCert.certData), pWapiVerifyActivate->aeCert.certLen);
		tmpLen+=pWapiVerifyActivate->aeCert.certLen;

		//ECDH parameters
		memcpy((void *)(Buf2Drv+tmpLen), (void *)&(pWapiVerifyActivate->ecdhParms.flag), 1);
		tmpLen+=1;
		memcpy((void *)(Buf2Drv+tmpLen), (void *)&(pWapiVerifyActivate->ecdhParms.length), 2);
		tmpLen+=2;
		memcpy((void *)(Buf2Drv+tmpLen), (void *)(pWapiVerifyActivate->ecdhParms.data), pWapiVerifyActivate->ecdhParms.length);
		tmpLen+=pWapiVerifyActivate->ecdhParms.length;

		DEBUG("%s(%d), WAPI VERIFY ACTIVATE FRAME: total bytes from wapi application to wapi driver: tmpLen=%d---------------\n", __FUNCTION__,__LINE__, tmpLen);
		
#if 1
		//ret=requestWrite(fd,"wlan0",(char *)pParams2Drv,sizeof(COMM_PARAMS));
		ret=requestWrite(fd,ifname, Buf2Drv,tmpLen);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), requestWrite failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
#endif
#endif
	}

#if 1
	else if(pParams->type==WAPI_IOCTL_TYPE_CA_AUTH)
	{
		int revLen;
	
		WAPI_CERT_VERIFY_REQ_Tp pCertVerifyReq;
		WAPI_CERT_VERIFY_RES_Tp pCertVerifyRes;
		
		char verifyRes;
		unsigned char tmpBuf[100];
		int tmpBufLen, infoLen;

		//For test
		int i;
		//End test
	
		//To send driver access verify response
		DEBUG("recv pkt from driver. WAPI_IOCTL_TYPE_CA_AUTH\n");


#if 1
		////////////////////////////////
		pAccessVerifyReq=(WAPI_ACCESS_VERIFY_REQ_Tp)malloc(sizeof(WAPI_ACCESS_VERIFY_REQ_T));
		if(pAccessVerifyReq==NULL)
		{
			ERR_PRINT("%s(%d), malloc failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		//DEBUG("%s(%d)---------------\n", __FUNCTION__,__LINE__);
		
		//To receive ASUE access verify request
		//pAccessVerifyReq=(WAPI_ACCESS_VERIFY_REQ_Tp)(pParams->data);

		//Buffer to WAPI_ACCESS_VERIFY_REQ_T ----new!!!!!!!!!
		//ret=parseBuf2AccessVerifyReq(pAccessVerifyReq, pParams->data, len-8);
		ret=parseBuf2AccessVerifyReq(pAccessVerifyReq, &infoLen, pParams->data, len-8);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), parseBuf2AccessVerifyReq failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		DEBUG("%s(%d), pAccessVerifyReq->flag=0x%x\n", __FUNCTION__,__LINE__, pAccessVerifyReq->flag);

		if((pAccessVerifyReq->flag & 0x08)==0x08)
		{
			//To use optional segment: ASU list trusted by ASUE
			useOptionalSeg=1;
		}
		
		//To check AE Identification
		ret=checkAeId(pAccessVerifyReq);
		if(ret!=1)
		{
			ERR_PRINT("%s(%d), AE Identification not match.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		DEBUG("%s(%d)---------------\n", __FUNCTION__,__LINE__);

		//To store temporary peer public key for ecdhtest use
		ret=storeStr2File(TMP_PEER_PUB_KEY, pAccessVerifyReq->asueKey.content, pAccessVerifyReq->asueKey.length);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), storeStr2File failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		DEBUG("%s(%d), (%p)---------------\n", __FUNCTION__,__LINE__, pAccessVerifyReq);

		//To get ASUE pub key from pAccessVerifyReq and store into TMP_USER_PUB_KEY -- NOT USE NOW
		//At the same time: store ASUE cert into TMP_USER_CERT_DER and TMP_USER_CERT -- used for ASUE signature verify!!!!
		ret=getAsuePubKeyFromAsueCert(&(pAccessVerifyReq->asueCert));
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), getAsuePubKeyFromAsueCert failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		DEBUG("%s(%d), infoLen=%d,pAccessVerifyReq->signByAsue.signVal.length=%d---------------\n", __FUNCTION__,__LINE__, infoLen,ntohs(pAccessVerifyReq->signByAsue.signVal.length));

		//To check signature alg before verifyMsgSignature -- to do!!!!!
		ret=verifyMsgSignature2(pParams->data, infoLen, (const char *) (pAccessVerifyReq->signByAsue.signVal.data), (const int) (ntohs(pAccessVerifyReq->signByAsue.signVal.length)), TMP_USER_CERT, &verifyRes);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), verifyMsgSignature2 failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		if(verifyRes!=1)
		{
			ERR_PRINT("%s(%d), signature verify wrong.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		else
		{
			DEBUG("signature verify OK.\n");//Added for test
		}
		
		//To generate wapi cert verify request
		//To malloc memory first
		pSndWaiPkt=(WAPI_PKT_Tp)malloc(sizeof(WAPI_PKT_T));
		if(pSndWaiPkt==NULL)
		{
			ERR_PRINT("%s(%d), malloc failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		memset(pSndWaiPkt, 0, sizeof(WAPI_PKT_T));


#if 1
		sprintf(tmpBuf, ECDSATEST" -pem2der -in %s -out %s", AP_CERT, AP_CERT_DER);
#else
		sprintf(tmpBuf, OPENSSL" x509 -inform PEM -in %s -outform DER -out %s", AP_CERT,AP_CERT_DER);
#endif
		//sprintf(cmdline, "%s%s", path, tmpBuf);
		system(cmdline);
		
		ret=genCertVerifyReqPkt2(pSndWaiPkt, pAccessVerifyReq, AP_CERT_DER);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), genCertVerifyReqPkt2 failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		//To store ADDID, Nae, Nasue into tmp file for openssl cmd use 
		//when ECDH compute BK, NextAuthSeed, BKID
		pCertVerifyReq=(WAPI_CERT_VERIFY_REQ_Tp)pSndWaiPkt->data;
		DEBUG("%s(%d), asueCert.certFlag=%d, asueCert.certLen=%d\n",__FUNCTION__,__LINE__, pCertVerifyReq->asueCert.certFlag, pCertVerifyReq->asueCert.certLen);//Added for test
		DEBUG("%s(%d), aeCert.certFlag=%d, aeCert.certLen=%d\n",__FUNCTION__,__LINE__, pCertVerifyReq->aeCert.certFlag, pCertVerifyReq->aeCert.certLen);//Added for test
		ret=storeStr2File(ADDID_FILE, pCertVerifyReq->addID, 12);
		DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), storeStr2File failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		ret=storeStr2File(NAE_FILE, pCertVerifyReq->aeChallenge, 32);
		DEBUG("%s(%d),ret=%d\n",__FUNCTION__,__LINE__,ret);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), storeStr2File failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}


		ret=storeStr2File(NASUE_FILE, pCertVerifyReq->asueChallenge, 32);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), storeStr2File failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		////////////////////////////////////
		ret=certVerifyReqPkt2Buf((unsigned char *)Buf2Drv, &tmpBufLen, pSndWaiPkt, useOptionalSeg);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), certVerifyReqPkt2Buf failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		
		//To malloc memory first
		pRevWapiPkt=(WAPI_PKT_Tp)malloc(sizeof(WAPI_PKT_T));
		if(pRevWapiPkt==NULL)
		{
			ERR_PRINT("%s(%d), malloc failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		
		//To send wapi cert verify request pkt and waiting for receive wapi cert verify response pkt				
		//ret=sendMsg((void *)pSndWaiPkt, sizeof(WAPI_PKT_T), (void *)pRevWapiPkt, &revLen,sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr));

		tmpBuffer=(char *)malloc(APP2DRV_BUF_LEN);
		if(tmpBuffer==NULL)
		{
			ERR_PRINT("%s(%d), malloc failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		//Send buffer, and receive buffer, not structure!
		ret=sendMsg((void *)Buf2Drv, tmpBufLen, (void *)tmpBuffer, &revLen,sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr));//???????
		DEBUG("%s(%d), ret=%d, revLen=%d\n",__FUNCTION__,__LINE__, ret, revLen);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), sendMsg failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		DEBUG("%s(%d)---------------\n", __FUNCTION__,__LINE__);


				
		//To change receive buffer into structure of wapi cert verify response pkt
		ret=buf2CertVerifyResPkt(pRevWapiPkt, (unsigned char *)tmpBuffer, revLen);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), buf2CertVerifyResPkt failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		//To process wapi cert verify response pkt
		pCertVerifyRes=(WAPI_CERT_VERIFY_RES_Tp)pRevWapiPkt->data;
		
		//To compare ADDID
		if(memcmp(pCertVerifyReq->addID, pCertVerifyRes->addID, 12)!=0)
		{
			ERR_PRINT("%s(%d), ADDID not match, drop this cert verify response pkt.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		//To compare Nae
		if(memcmp(pCertVerifyReq->aeChallenge, pCertVerifyRes->certVerifyResult.rand_1, 32)!=0)
		{
			ERR_PRINT("%s(%d), AE challenge not match, drop this cert verify response pkt.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		DEBUG("%s(%d)---------------\n", __FUNCTION__,__LINE__);

		//To check signature alg before verifyMsgSignature -- to do!!!!!
		//To verify wapi cert verify response signature
		DEBUG("%s(%d), msg---------------\n", __FUNCTION__,__LINE__);
		DEBUG("%s(%d), sig--------------- signVal.length=%d certVerifyResult.length=%d\n", __FUNCTION__,__LINE__,pCertVerifyRes->aeTrustServerSign.signVal.length,pCertVerifyRes->certVerifyResult.length);
		ret=verifyMsgSignature2(&tmpBuffer[24],(int)(pCertVerifyRes->certVerifyResult.length+3), (char *)(pCertVerifyRes->aeTrustServerSign.signVal.data), pCertVerifyRes->aeTrustServerSign.signVal.length, CA4AP_CERT, &verifyRes);
		DEBUG("%s(%d), ret=%d, verifyRes=%d\n",__FUNCTION__,__LINE__, ret, verifyRes);//Added for test
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), verifyMsgSignature2 failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		if(verifyRes!=1)
		{
			ERR_PRINT("%s(%d), signature verify wrong.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
		else
		{
			DEBUG("%s(%d), signature verify OK.\n",__FUNCTION__,__LINE__);//Added for test
		}

		if(tmpBuffer!=NULL)
		{
			free(tmpBuffer);
			tmpBuffer=NULL;
		}
		
		DEBUG("%s(%d)---------------\n", __FUNCTION__,__LINE__);


#if 1
		if(pCertVerifyRes->certVerifyResult.result_1==RES_CERT_VALID)
		{
			//ASUE CERT valid
			
			////////////////////////
			//To do ECDH compute
			//To call ecdhtest
			sprintf(cmdline, "%s%s", ECDSATEST, " -ecdhtest");
			system(cmdline);
			//////////////////////////////////

			///////////////////////////////////
			//To send driver BK and Nae and Nasue
			//To get BK from BK_FILE
			tmpBufLen=0;//Initial
			ret=readFile2Str(tmpBuf,&tmpBufLen, KEY_FOR_BK);
			if(ret==FAILED)
			{
				ERR_PRINT("%s(%d), verifyMsgSignature failed.\n",__FUNCTION__,__LINE__);//Added for test
				toRet=FAILED;
				goto err;
			}
		}
		else
		{
			//ASUE CERT not valid
			//key4bk is set arbitrary
			memset(tmpBuf,0,sizeof(tmpBuf));
			tmpBufLen=24;
		}
#endif
#endif


//////////
#if 1
		//sleep(1);
		//To send to driver
		memset(Buf2Drv, 0, APP2DRV_BUF_LEN);
		pParams2Drv=(COMM_PARAMSp)Buf2Drv;
		pParams2Drv->eventID=DOT11_EVENT_WAPI_WRITE_QUEUE;
		pParams2Drv->type=WAPI_IOCTL_TYPE_SETBK;
 
		pParams2Drv->ptr=pParams->ptr;

		memset(pParams2Drv->name,0,IFNAMSIZ);
		memcpy(pParams2Drv->name,ifname,strlen(ifname));
		tmpLen=WAPI_COMM_PARAM_SIZE;

#if 1
		memcpy((void *)(Buf2Drv+tmpLen), (void *)tmpBuf, tmpBufLen);
		tmpLen+=tmpBufLen;

		//To set Nae 
		memcpy((void *)(Buf2Drv+tmpLen), (void *)(pCertVerifyReq->aeChallenge), 32);
		tmpLen+=32;

		//To set Nasue
		memcpy((void *)(Buf2Drv+tmpLen), (void *)(pCertVerifyReq->asueChallenge), 32);
		tmpLen+=32; 
#endif

		DEBUG("%s(%d), BK FRAME: total bytes from wapi application to wapi driver: tmpLen=%d---------------\n", __FUNCTION__,__LINE__, tmpLen);
		ret=requestWrite(fd,ifname, Buf2Drv,tmpLen);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), requestWrite failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
#endif


#if 1
		DEBUG("%s(%d),pParams->ptr=%p\n",__FUNCTION__,__LINE__,pParams->ptr);//Added for test 
		memset(Buf2Drv, 0, APP2DRV_BUF_LEN);//To clear it
		
		DEBUG("%s(%d),asueCert.certFlag=%d\n",__FUNCTION__,__LINE__,pAccessVerifyReq->asueCert.certFlag);

		ret=genAccessVerifyRes2Buf((unsigned char *)(&Buf2Drv[WAPI_COMM_PARAM_SIZE]), &tmpLen2, pAccessVerifyReq, pCertVerifyRes, pCertVerifyReq);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), genAccessVerifyRes failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}

		//To send driver access verify response
		pParams2Drv=(COMM_PARAMSp)Buf2Drv;
		pParams2Drv->eventID=DOT11_EVENT_WAPI_WRITE_QUEUE;
		pParams2Drv->type=WAPI_IOCTL_TYPE_AUTHRSP;
		pParams2Drv->ptr=pParams->ptr;

		memset(pParams2Drv->name,0,IFNAMSIZ);
		memcpy(pParams2Drv->name,ifname,strlen(ifname));
		tmpLen=WAPI_COMM_PARAM_SIZE+tmpLen2;
		DEBUG("%s(%d), WAPI ACCESS RESPONSE FRAME: total bytes from wapi application to wapi driver: tmpLen=%d---------------\n", __FUNCTION__,__LINE__, tmpLen);

		DEBUG("%s(%d) fd=%08x ifname=%s Buf2Drv=%08x tmpLen=%d\n", __FUNCTION__,__LINE__,fd,ifname,Buf2Drv,tmpLen);
		ret=requestWrite(fd, ifname, Buf2Drv,tmpLen);
		if(ret==FAILED)
		{
			ERR_PRINT("%s(%d), requestWrite failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
		}
#endif
	}
#endif
	else
	{
		ERR_PRINT("%s(%d), unknown pkt type from driver.\n",__FUNCTION__,__LINE__);//Added for test
		goto err;
	}

err:

	//Do nothing
	if(Buf!=NULL)
		free(Buf);
	if(Buf2Drv!=NULL)
		free(Buf2Drv);
	if(tmpBuffer!=NULL)
		free(tmpBuffer);
	if(pWapiVerifyActivate!=NULL)
		free(pWapiVerifyActivate);
	if(pAccessVerifyReq!=NULL)
		free(pAccessVerifyReq);
	if(pSndWaiPkt!=NULL)
		free(pSndWaiPkt);
	if(pRevWapiPkt!=NULL)
		free(pRevWapiPkt);

	return retVal;
}


int sendMsg(void *msg, int msgLen, void * outMsg, int * outMsgLen, int sockfd, struct sockaddr *pservaddr, socklen_t servlen)
{
	int n, tmpSize;
	int toRet;
	//char sendline[MAXLINE], recvline[MAXLINE + 1];
	int maxfd;
	fd_set fds;
	struct timeval timeout={5,0};//poll 5s

	//To initial fd_set
	FD_ZERO(&fds);
	FD_SET(sockfd,&fds);
	maxfd=sockfd+1;
	
	/* connect to server */
	if(connect(sockfd, (struct sockaddr *)pservaddr, servlen) == -1)
	{
		ERR_PRINT("connect error\n");
		toRet=FAILED;
		goto err;
	}

	DEBUG("%s(%d) msgLen=%08x\n",msgLen);//Added for test
	tmpSize=write(sockfd, msg, msgLen);
	if((tmpSize==-1) || (tmpSize<msgLen))
	{
			ERR_PRINT("%s(%d), write failed.\n",__FUNCTION__,__LINE__);//Added for test
			toRet=FAILED;
			goto err;
	}

	switch(select(maxfd,&fds,NULL,NULL,&timeout))//Just test if any data received during timeout at fds
	{
		case -1:
			//select err
			DEBUG("select err.\n");//Added for test
			toRet=FAILED;
			goto err;

		case 0:
			//select timeout
			DEBUG("select timeout.\n");//Added for test
			FD_ZERO(&fds);//To reset fd_set
			toRet=FAILED;
			goto err;

		default:
			//select ok and not timeout
			DEBUG("select ok and not timeout.\n");//Added for test
			if(FD_ISSET(sockfd,&fds))
			{
				DEBUG("data can be read at sockfd.\n");//Added for test
				tmpSize = read(sockfd, outMsg, APP2DRV_BUF_LEN);
				DEBUG("tmpSize=%d\n",tmpSize);//Added for test
				if(tmpSize==-1)
				{
					ERR_PRINT("%s(%d), read failed.\n",__FUNCTION__,__LINE__);//Added for test
					toRet=FAILED;
					goto err;
				}
				*outMsgLen=tmpSize;
				toRet=SUCCESS;
			}
	}
	
err:
	return toRet;
}

//parse wireless interface list from string to global var wlanInterface
//outWlNum: output parameter, wireless interface number in fact
//inStr: input parameter, wireless interface list
int parseWlList2Arr(char *outWlNum, char * inStr)
{
	int ret, toRet,num;
	char *p0,*p1;
	char tmpBuf[IFNAMSIZ];

	if(inStr==NULL)
	{
		ERR_PRINT("%s(%d), err: inStr is NULL.\n",__FUNCTION__,__LINE__);
		toRet=FAILED;
		goto err;
	}

	if(outWlNum==NULL)
	{
		ERR_PRINT("%s(%d), err: wlNum is NULL.\n",__FUNCTION__,__LINE__);
		toRet=FAILED;
		goto err;
	}


	//Initial
	num=0;
	*outWlNum=0;
	
	p0=inStr;
	p1=strchr(p0,',');
	while(p1!=NULL)
	{
		memset(tmpBuf,0,IFNAMSIZ);
		if((p1-p0+1) > IFNAMSIZ)
		{
			ERR_PRINT("%s(%d), err: wireless interface name length > %d\n",__FUNCTION__,__LINE__,IFNAMSIZ);
			toRet=FAILED;
			goto err;
		}
		strncpy(tmpBuf,p0,p1-p0);
		if(num<RTL8190_NUM_WLAN)
		{
			strcpy(wlanInterface[num],tmpBuf);
		}
		else
		{
			ERR_PRINT("%s(%d), err: wireless interface number> %d\n",__FUNCTION__,__LINE__,RTL8190_NUM_WLAN);
			toRet=FAILED;
			goto err;
		}
		num++;
		p1++;
		p0=p1;
		p1=strchr(p0,',');
	}
	
	if(num<RTL8190_NUM_WLAN)
	{
		if((strlen(p0)+1) > IFNAMSIZ)
		{
			ERR_PRINT("%s(%d), err: wireless interface name length > %d\n",__FUNCTION__,__LINE__,IFNAMSIZ);
			toRet=FAILED;
			goto err;
		}
		strcpy(wlanInterface[num],p0);
		num++;
	}
	else
	{
		ERR_PRINT("%s(%d), err: wireless interface number> %d\n",__FUNCTION__,__LINE__,RTL8190_NUM_WLAN);
		toRet=FAILED;
		goto err;
	}

	*outWlNum=num;

	toRet=SUCCESS;
err:
	return toRet;
}

int main(int argc, char **argv)
{
	char badops;
	int ret, toRet;
	int i;
	char *asIP, *wlList;

	//Initial
	badops=0;
	asIP=NULL;
	wlList=NULL;
	
	DEBUG("%s(%d)\n",__FUNCTION__,__LINE__);//Added for test
	/* check args */
	if(argc != 5)
	{
		ERR_PRINT("usage: udpclient -d <IPaddress> -i <wireless interface list>\n");
		ERR_PRINT("IPaddress, ex: 192.168.1.254\n");
		ERR_PRINT("wireless interface list, ex: wlan0,wlan0-va0,wlan0-va1,wlan0-va2,wlan0-va3\n");
		toRet=FAILED;
		goto err;
	}

	argc--;
	argv++;

	while (argc >= 1)
	{
		if(strcmp(*argv,"-d") == 0)
		{
			if (--argc < 1) break;
				asIP=*(++argv);
		}
		else if(strcmp(*argv,"-i") == 0)
		{
			if (--argc < 1) break;
				wlList=*(++argv);
		}
		else
		{
bad:
			ERR_PRINT("unknown option %s\n",*argv);
			badops=1;
			break;
		}
		argc--;
		argv++;	
	}//end while

	if(badops==1)
	{
		ERR_PRINT("usage: udpclient -d <IPaddress> -i <wireless interface list>\n");
		ERR_PRINT("IPaddress, ex: 192.168.1.254\n");
		ERR_PRINT("wireless interface list, ex: wlan0,wlan0-va0,wlan0-va1,wlan0-va2,wlan0-va3\n");
		toRet=FAILED;
		goto err;
	} 

	DEBUG("%s(%d): asIP=%s,len1=%d, wlList=%s, len2=%d\n",__FUNCTION__,__LINE__,asIP,strlen(asIP),wlList,strlen(wlList));//Added for test

	//Initial
	for(i=0;i<RTL8190_NUM_WLAN;i++)
	{
		memset(wlanInterface[i],0,IFNAMSIZ);
	}
	wlanInterfaceNum=0;

	ret=parseWlList2Arr(&wlanInterfaceNum, wlList);
	if(ret==FAILED)
	{
		ERR_PRINT("ParseWlList2Arr failed.\n");
		toRet=FAILED;
		goto err;
	}

	if(wlanInterfaceNum==0)
	{
		ERR_PRINT("%s(%d), err: wlanInterfaceNum=%d.\n",__FUNCTION__,__LINE__,wlanInterfaceNum);
		toRet=FAILED;
		goto err;
	}

	/* init servaddr */
	bzero(&servaddr, sizeof(servaddr));
	servaddr.sin_family = AF_INET;
	servaddr.sin_port = htons(SERV_PORT);
	if(inet_pton(AF_INET, asIP, &servaddr.sin_addr) <= 0)
	{
		ERR_PRINT("[%s] is not a valid IPaddress\n", asIP);
		toRet=FAILED;
		goto err;
	}

	sockfd = socket(AF_INET, SOCK_DGRAM, 0);
	DEBUG("%s(%d), sockfd=%d\n",__FUNCTION__,__LINE__,sockfd);//Added for test


	//To initial things related to communication with wapi driver
	fd=get_fd();
	DEBUG("%s(%d), fd=%d\n",__FUNCTION__,__LINE__,fd);//Added for test


	/*signal SIGIO*/
	signal(SIGIO,ProcessEvent);
	//signal(SIGUSR1,InitEvent);
	//signal(SIGUSR2,WriteEvent);

	for(i=0;i<wlanInterfaceNum;i++)
	{
#if 0
		memset(wlanInterface[i],0,IFNAMSIZ);
		if(i==0)
		{
			sprintf(wlanInterface[i],"%s","wlan0");
		}
		else
		{
			sprintf(wlanInterface[i],"%s%d","wlan0-va",i-1);
		}
#endif
		DEBUG("i=%d, [%s],[%d], IFNAMSIZ=%d\n",i,wlanInterface[i],strlen(wlanInterface[i]), IFNAMSIZ);//Added for test

		/*Initial queue at kernel*/
		requestInit(fd,wlanInterface[i],NULL,NULL);
		/*register pid*/
		RegisterPID(fd,wlanInterface[i]);
	}

	while(1)
	{
		//ProcessEvent(SIGIO);
		sleep(10);
	}
	////////////////////////////////////////////
	
	toRet=SUCCESS;
err:
//	DEBUG("%s(%d), toRet=%d\n",__FUNCTION__,__LINE__, toRet);//Added for test
	return toRet;
}

