#!/bin/sh

#if [ "$1" != "" ]; then
#        dev=$1
#else
#        dev=`nvram_get 2860 wan_3g_dev`
#fi

#set device to HUAWEI
#dev=HUAWEI-E220

#sleep 10
#change 3G dongle state to modem
#if [ "$dev" = "MU-Q101" ]; then
#        usb_modeswitch -c /etc_ro/usb/usb_modeswitch_MU-Q101.conf
#elif [ "$dev" = "HUAWEI-E169" ]; then
#        usb_modeswitch -c /etc_ro/usb/usb_modeswitch_HUAWEI-E169.conf
#elif [ "$dev" = "HUAWEI-E220" ]; then
#        usb_modeswitch -c /etc_ro/usb/usb_modeswitch_HUAWEI-E220.conf
#elif [ "$dev" = "BandLuxe-C270" ]; then
#	sdparm --command=eject /dev/sr0
#	sdparm --command=eject /dev/sg0
#elif [ "$dev" = "OPTION-ICON225" ]; then
#	usb_modeswitch -c /etc_ro/usb/usb_modeswitch_OPTION-ICON225.conf
#else
        #other supported devcies
#fi

#wait for state change
#sleep 10

#insmod usbserial module
#if [ "$dev" = "MU-Q101" ]; then
#        vend_id="0x0408"
#        prod_id="0xea02"
#elif [ "$dev" = "HUAWEI-E169" ]; then
#        vend_id="0x12d1"
#        prod_id="0x1001"
#elif [ "$dev" = "HUAWEI-E220" ]; then
#        vend_id="0x12d1"
#        prod_id="0x1003"
#elif [ "$dev" = "BandLuxe-C270" ]; then
#        vend_id="0x1a8d"
#        prod_id="0x1009"

#else
        #other supported devcies
#fi

#if [ "$dev" != "OPTION-ICON225" ]; then
#	rmmod usbserial
#	rmmod hso
#	sleep 3
#	insmod usbserial vendor=$vend_id product=$prod_id
#	sleep 3
#elif [ "$dev" = "OPTION-ICON225" ]; then
#	rmmod usbserial
#	rmmod hso
#	sleep 3
#	insmod hso
#	sleep 3
#fi

#create ppp call script for 3G connection
#if [ "$dev" = "MU-Q101" ]; then
#        modem_f=ttyUSB0
#elif [ "$dev" = "HUAWEI-E169" ]; then
#        modem_f=ttyUSB0
#elif [ "$dev" = "HUAWEI-E220" ]; then
#        modem_f=ttyUSB0
#elif [ "$dev" = "BandLuxe-C270" ]; then
#        modem_f=ttyUSB0
#else
        #other supported devcies
#        modem_f=ttyUSB0
#fi


#if [ "$dev" = "HUAWEI-E220" ]; then
#	if [ -d	/var/lock ]; then
#		pppd call e220
#	else
#		mkdir /var/lock
#		pppd call e220
#	fi	
#elif [ "$dev" != "OPTION-ICON225" ]; then	
#		config-3g-ppp.sh -p pass -u user -m $modem_f -c Generic_conn.scr -d Generic_disconn.scr
#		pppd call 3g
#elif [ "$dev" = "OPTION-ICON225" ]; then
#	echo "APN=internet" > /etc/conninfo.ini
	#echo "PIN=internet >" /etc/conninfo.ini
	#echo "USER="  > /etc/conninfo.ini
	#echo "PASS="  > /etc/conninfo.ini
#	hso_connect.sh up
#fi

#set config value
#nvram_set 2860 wan_pincode "0000"
#nvram_set 2860 wan_apn "internet"
#nvram_set 2860 wan_init_string1 "AT&F"
#nvram_set 2860 wan_init_string2 "ATE0V1X1&D2&C1S0=0"
#nvram_set 2860 wan_dial_string "ATDT*99#"
#nvram_set 2860 wan_username ""
#nvram_set 2860 wan_password ""

#get parameter wait for mode switch 
if [ "$1" == "3g_backup" ]; then
	echo "3G backup wan"
	DEV3G=$(nvram_get 2860 3gwan_dev)
	PIN=$(nvram_get 2860 3gwan_pincode)
else
	sleep 10
	DEV3G=$(nvram_get 2860 wan_dev)
	PIN=$(nvram_get 2860 wan_pincode)
fi

#disconnect first
#comgt -d "$DEV3G" -s /etc_ro/ppp/3g/Generic_disconn.scr

#step0: set PIN code if need
PINCODE=$PIN comgt -d "$DEV3G" -s /etc_ro/ppp/3g/setpin.gcom || {
	ERR=$?
	#echo "$config(3g): Please check your SIM card and PIN code setting."
	#set_3g_led 0 0 0
	#return 1
	#ERR=1
}		

if [ "$ERR" == "1" ]; then
	echo "Set PIN code error!!!!" 
	rm -f /var/network/3g_info >/dev/null
	exit 1
elif [ "$ERR" == "2" ]; then
	echo "Set PIN code timeout!!!!"
	rm -f /var/network/3g_info >/dev/null
else
	#step1: log data for web display information
	rm -f /var/network/3g_info >/dev/null
	CARDINFO=$(comgt -d "$DEV3G" -s /etc_ro/ppp/3g/getcardinfo.gcom)
	SIG=$(comgt -d $DEV3G -s /etc_ro/ppp/3g/getstrength.gcom)
	echo "==3G Card Info== :">/var/network/3g_info
	echo "$CARDINFO">>/var/network/3g_info
	echo "==3G Signal Strength== :">>/var/network/3g_info
	echo "$SIG">>/var/network/3g_info
fi

#step2: check if 3G device existed
if [ "$DEV3G" != "" ]; then
	TEST=$(comgt -d $DEV3G -s /etc_ro/ppp/3g/getstrength.gcom | grep "Can't open device")
else
	TEST=$(comgt | grep "Unable to locate default")
fi

if [ "$TEST" != "" ]; then
	echo "3G device not exist........."
	exit 1
fi

#step3: make sure 3g device is locked
if [ "$1" == "3g_backup" ]; then
	INUSE=$(nvram_get 2860 3gwan_3gdev)
	if [ "$INUSE" == "" ]; then
		nvram_set 2860 3gwan_3gdev "xxxx/xxxx/x"
	fi
else
	INUSE=$(nvram_get 2860 wan_3gdev)
	if [ "$INUSE" == "" ]; then
		nvram_set 2860 wan_3gdev "xxxx/xxxx/x"
	fi
fi

#step4: get value from config
if [ "$1" == "3g_backup" ]; then
	W_APN=$(nvram_get 2860 3gwan_apn)
	W_INIT_STR1=$(nvram_get 2860 3gwan_init_string1)
	W_INIT_STR2=$(nvram_get 2860 3gwan_init_string2)
	W_DIAL_STR=$(nvram_get 2860 3gwan_dial_string)
	W_USER=$(nvram_get 2860 3gwan_username)
	W_PASSWD=$(nvram_get 2860 3gwan_password)
else
	W_APN=$(nvram_get 2860 wan_apn)
	W_INIT_STR1=$(nvram_get 2860 wan_init_string1)
	W_INIT_STR2=$(nvram_get 2860 wan_init_string2)
	W_DIAL_STR=$(nvram_get 2860 wan_dial_string)
	W_USER=$(nvram_get 2860 wan_username)
	W_PASSWD=$(nvram_get 2860 wan_password)
fi

#step5: set 3g.chat temp file
echo "ABORT   BUSY" > /var/3g.chat
echo "ABORT   'NO CARRIER'" >> /var/3g.chat
echo "ABORT   ERROR" >> /var/3g.chat
echo "REPORT  CONNECT" >> /var/3g.chat
echo "TIMEOUT 10" >> /var/3g.chat
echo "\"\"      \"$W_INIT_STR1\"" >> /var/3g.chat
echo "OK      \"$W_INIT_STR2\"" >> /var/3g.chat
echo "OK      'AT+CGDCONT=1,\"IP\",\"$W_APN\"'" >> /var/3g.chat
echo "SAY     \"Calling UMTS/GPRS\"" >> /var/3g.chat
echo "TIMEOUT 30" >> /var/3g.chat
echo "OK      \"$W_DIAL_STR\"" >> /var/3g.chat
echo "CONNECT ' '" >> /var/3g.chat

#step6: set ppp number and 3G connecting
if [ "$1" == "3g_backup" ]; then
	#connect ppp1
	pppd unit 1 ${W_USER:+user "$W_USER" password "$W_PASSWD"} noaccomp nopcomp novj\
	nobsdcomp noauth lock crtscts 115200 "$DEV3G" call e220
else
	#connect ppp0
	pppd unit 0 ${W_USER:+user "$W_USER" password "$W_PASSWD"} noaccomp nopcomp novj\
	nobsdcomp noauth lock crtscts 115200 "$DEV3G" call e220
fi
